﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 87 V (1 yr) VER /5502
DATE:                  2015-04-14 13:08:39
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10838 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       182
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author(s):
#        DFM, VY, GMO, PS, ND, DAC
#
#  Source(s):
#        Fluke 80 Series V Calibration Manual *
#        PN 2102915, September 2004, Rev.1, 2/05
#
#        Fluke 80 Series V Calibration Manual Supplement
#        Supplement Issue: 6, Issue Date: 8/12
#
#        * The tolerances used by this procedure were taken from the published
#          specifications table.
#
#  Additional Equipment and/or Accessories Required:
#        Probe, test, safety plug (normally supplied with UUT)
#        Fluke 80AK K-Type (thermocouple) DMM Adapter
#        Type K thermocouple extension cable with SMP (m)-(m) plugs
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
#  Global String Variables:
#         @ModelNum = Model number of UUT.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  5502E        Standby
  1.003  ENDIF

  1.004  ASK-   R   Q N              P                            F        V

  1.005  IF           NOT(VERSIONCHECK("8.1.4"))
  1.006  END
  1.007  ENDIF

  1.008  CALL         Sub Display Copyright
  1.009  CALL         Sub High Voltage Safety Warning

  1.010  HEAD         TEST CONDITIONS
  1.011  DISP         - No specific warm-up time requirement.
  1.011  DISP         - Ambient temperature: 18 °C - 28 °C.
  1.011  DISP         - Relative humidity: less than 90 %.

  1.012  HEAD         EQUIPMENT REQUIREMENTS
  1.013  OPBR         -z Do you want to review the list of additional
  1.013  OPBR         equipment and/or accessories required?

  1.014  IF           MEM1
  1.015  DISP         The following additional equipment is required:
  1.015  DISP
  1.015  DISP         - Probe, test, safety plug (normally supplied with UUT)
  1.015  DISP         - Thermocouple extension cable, Type K SMP (m)-(m) plug
  1.015  DISP         - Fluke 80AK K-Type DMM (thermocouple) Adapter
  1.016  ENDIF

  1.017  HEAD         SETUP PROCEDURE EXECUTION PARAMETERS
  1.018  CALL         Sub Select Failed Test Mode
  1.019  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)

  1.020  RSLT         =
  1.021  HEAD         {UUT IDENTIFICATION}
  1.022  DISP         [32]                 ** PLEASE NOTE **
  1.022  DISP         Depending on the version of UUT firmware, different
  1.022  DISP         methods must be used to determine the revision level.
  1.022  DISP
  1.022  DISP         Read the following instructions carefully, prior to
  1.022  DISP         proceeding.

  1.023  MEMI         PRESS and HOLD the UUT AutoHOLD button while turning
  1.023  MEMI         the UUT rotary switch from OFF to V=.
  1.023  MEMI
  1.023  MEMI         If the firmware version is IMMEDIATELY DISPLAYED:
  1.023  MEMI         [32] Note the indication, then release the UUT
  1.023  MEMI         [32] AutoHOLD pushbutton.
  1.023  MEMI
  1.023  MEMI         If the firmware version is NOT IMMEDIATELY DISPLAYED:
  1.023  MEMI         [32] Release the UUT AutoHOLD pushbutton, noting the
  1.023  MEMI         [32] momentary display of the installed firmware
  1.023  MEMI         [32] version.
  1.023  MEMI
  1.023  MEMI         Enter displayed UUT firmware version:
  1.024  MATH         MEM2 = FMT(MEM, "%4.2f")
  1.025  RSLT         =
  1.026  RSLT         =Firmware Level:  [MEM2]

  1.027  CALL         Sub Fluke 80 Series V Backlight Test
  1.028  CALL         Sub Fluke 80 Series V Basic Operability Tests
  1.029  JMPL         END                            @Abort

# NOTE: The execution order of this verification procedure has been optimized
# to minimize operator intervention, while retaining the correct sequence for
# reported test results.  For more information about the method used, refer
# to this application note, available at www.flukecal.com:
# Application Note 6001075: Preserving Results Order While Optimizing
# Execution Sequence in MET/CAL Procedures.

  1.030  JMPL         CAPACITANCE

  1.031  LABEL        AC_VOLTAGE
  1.032  CALL         Sub Fluke 87 V (1 yr) AC Volts VER /5502
  1.033  CALL         Sub Fluke 83,87 V (1 yr) Frequency VER /5502
  1.034  CALL         Sub Fluke 80 Series V (1 yr) Freq Sensitivity VER /5502
  1.035  JMPL         LOW_PASS_FILTER

  1.036  LABEL        TRIGGER_LEVEL
  1.037  CALL         Sub Fluke 80 Series V (1 yr) Trigger Level VER /5502
  1.038  CALL         Sub Fluke 80 Series V (1 yr) Duty Cycle VER /5502
  1.039  JMPL         DC_MILLIVOLTS

  1.040  LABEL        DC_VOLTAGE
  1.041  CALL         Sub Fluke 87 V (1 yr) DC Volts VER /5502
  1.042  JMPL         MIN_MAX

  1.043  LABEL        DC_MILLIVOLTS
  1.044  CALL         Sub Fluke 87 V (1 yr) DC Millivolts VER /5502
  1.045  JMPL         DIODE_TEST

  1.046  LABEL        RESISTANCE
  1.047  CALL         Sub Fluke 87 V (1 yr) Resistance VER /5502
  1.048  CALL         Sub Fluke 80 Series V (1 yr) Conductance VER /5502
  1.049  JMPL         AC_AMPS

  1.050  LABEL        DIODE_TEST
  1.051  CALL         Sub Fluke 80 Series V (1 yr) Diode Test VER /5502
  1.052  JMPL         RESISTANCE

  1.053  LABEL        AC_AMPS
  1.054  CALL         Sub Fluke 87 V (1 yr) AC Amps VER /5502
  1.055  CALL         Sub Fluke 87 V (1 yr) DC Amps VER /5502
  1.056  CALL         Sub Fluke 87 V (1 yr) AC Milliamps VER /5502
  1.057  CALL         Sub Fluke 87 V (1 yr) DC Milliamps VER /5502
  1.058  CALL         Sub Fluke 87 V (1 yr) AC Microamps VER /5502
  1.059  CALL         Sub Fluke 87 V (1 yr) DC Microamps VER /5502
  1.060  JMPL         TEMPERATURE

  1.061  LABEL        CAPACITANCE
  1.062  CALL         Sub Fluke 80 Series V (1 yr) Capacitance VER /5502
  1.063  JMPL         AC_VOLTAGE

  1.064  LABEL        LOW_PASS_FILTER
  1.065  CALL         Sub Fluke 87 V (1 yr) Low Pass Filter VER /5502
  1.066  JMPL         DC_VOLTAGE

  1.067  LABEL        MIN_MAX
  1.068  CALL         Sub Fluke 87,88 V Peak Min/Max VER /5502
  1.069  JMPL         TRIGGER_LEVEL

  1.070  LABEL        TEMPERATURE
  1.071  CALL         Sub Fluke 87,88 V Temperature VER /5502

  1.072  LABEL        END

  1.073  IF           @Abort
  1.074  LABEL        ABORT
  1.075  HEAD         V E R I F I C A T I O N   A B O R T E D
  1.076  ENDIF

  1.077  DISP         Rotate UUT function switch to OFF.
  1.078  END
