﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            QuadTech Sentry 10 Plus: (1 yr) VER /5320,5320LOAD,DMM
DATE:                  2016-06-28 11:50:38
AUTHOR:                QuadTech
REVISION:              $Revision: 16401 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       89
CONFIGURATION:         Fluke 5320A
CONFIGURATION:         Digital Multimeter
STANDARD:              Fluke 5320A-LOAD
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  This procedure contains the following tests whose Test Uncertainty Ratio
#  are less than 4:1.
#        AC Voltage
#                     - 1.000 kV      TUR 1.5000
#                     - 2.000 kV      TUR 1.6667
#                     - 5.000 kV      TUR 1.8333
#
#  Source:
#        QuadTech Sentry Plus Series
#        Hipot Testers
#        Instruction Manual
#        Form 150697/A3, February 2004
#
#        Sentry Plus B & A Data Sheet
#        Form 150701/A1
#
#  Additional Equipment Required:
#
#        - Digital Multimeter, suitable for use with configured
#          DMM, 0 to 40 mA, 0. % accuracy
#
#        - 5 kV test leads: 3 required
#          single banana (m) to single banana (m)
#
#        - Adapter: Clip lead to single banana (m)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by QuadTech Corporation.
#
#  NOTE
#   JMPL/LABEL statements in this procedure are used to minimize rotary knob
#   movement and connection chages. However, the order of the tests in the
#   results are determined by statement number.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Dummy statement to force main procedure list required references.
  1.001  IF           0
  1.002  5320         Mode = Meter; +Voltage = 1.000 kV; Freq = 60 Hz
  1.002  5320         Probe = 10 kV; Setup
  1.003  IEEE         [@DMM]
  1.004  STD          Fluke 5320A-LOAD
  1.005  ENDIF

  1.006  ASK-   R     N              P                                     V

  1.007  IF           NOT(VERSIONCHECK("8.0"))
  1.008  END
  1.009  ENDIF

  1.010  CALL         Sub Display Copyright
  1.011  CALL         Sub High Voltage Safety Warning
  1.012  CALL         Sub Select Failed Test Mode
  1.013  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)
  1.014  CALL         Sub QuadTech Sentry Plus Additional Equipment Req.
  1.015  CALL         Sub QuadTech Sentry Plus Set Line Frequency
  1.016  CALL         Sub QuadTech Sentry Plus (1 yr) Gnd Cont VER /5320
  1.017  CALL         Sub QuadTech Sentry Plus (1 yr) GFI VER /5320LOAD
  1.018  CALL         Sub QuadTech Sentry Plus (1 yr) ACV VER /5320
  1.019  CALL         Sub QuadTech Sentry Plus (1 yr) ACI VER /5320LOAD,DMM

  1.020  END
