﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub QuadTech Sentry Plus (1 yr) ACI VER /5320LOAD,DMM
DATE:                  2016-06-28 11:48:23
AUTHOR:                Fluke
REVISION:              $Revision: 16401 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       13
NUMBER OF LINES:       272
CONFIGURATION:         Digital Multimeter
STANDARD:              Fluke 5320A-LOAD
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Model(s) Covered:
#        Sentry 10 Plus, Sentry 20 Plus, & Sentry 30 Plus
#
#  Additional Equipment Required:
#        Adapter: Clip lead to single banana (m)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@DMM]
  1.003  ENDIF

  1.004  RSLT         =
  1.005  HEAD         {AC OUTPUT CURRENT}
  1.006  STD          Fluke 5320A-LOAD
  1.007  CALL         Sub Initialize /DMM
  1.008  MATH         @DMM_Func = "AC_Current"; @DMM_Freq = @LineFreq
  1.009  CALL         Sub Reset /DMM
  1.010  CALL         Sub Setup /DMM

  1.011  RSLT         =
  1.012  HEAD         AC OUTPUT CURRENT:{ 20 mA Range}
  1.013  RSLT         =  5000 V / 5 MOhm
  1.014  TSET         CPT = 10.00 mA
  1.015  MATH         S[1] = @DMM_DevName
  1.016  TARGET       -p

  1.017  LABEL        ACI_5000V_5MOhm
  1.018  DISP         Connect UUT and [S1] to the 5320A-LOAD
  1.018  DISP         as follows:
  1.018  DISP
  1.018  DISP         [32] UUT OUTPUT <===========> 5320A-LOAD 1 mA/5 MOhm (1)
  1.018  DISP
  1.018  DISP         [32] UUT RTN/LOW <==========> [S1] [V @DMM_CurrentLo]
  1.018  DISP
  1.018  DISP         [32] 5320A-LOAD COM <=======> [S1] [V @DMM_CurrentHi]
  1.018  DISP
  1.018  DISP         1. Requires clip lead to single banana (m) adapter.
  1.019  DISP         Press F1 (PROGRAM).
  1.019  DISP
  1.019  DISP         Press F3 (NEXT) to highlight mode.
  1.019  DISP         Press F1 (INC.) or F2 (DEC.) to select "AC" mode.
  1.019  DISP
  1.019  DISP         Press F3 (NEXT) to highlight VOLT value.
  1.019  DISP         Press F1 (INC.) or F2 (DEC.) to select VOLT :5.000kV
  1.019  DISP
  1.019  DISP         Press F3 (NEXT) to highlight HIGH value.
  1.019  DISP         Press F1 (INC.) or F2 (DEC.) to select HIGH :20.00mA
  1.019  DISP
  1.019  DISP         Press F3 (NEXT) to highlight TIME value.
  1.019  DISP         Press F1 (INC.) or F2 (DEC.) to select TIME : 15.0s
  1.019  DISP
  1.019  DISP         Press F4 (EXIT).
  1.020  TARGET       -m
  1.021  DISP         Press START and then select Advance immediately.
  1.022  MATH         SAFEON("UUT", "5000V", "Sine")
  1.023  CALL         Sub Read /DMM
  1.024  WAIT         [D1000]
  1.025  MATH         SAFEOFF("UUT")
  1.026  MATH         @DMM_Meas = MEM
  1.027  CALL         Sub Get Accuracy /DMM
  1.028  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
  1.029  ACC    10    mA             L1U
  1.030  MEMI         Wait until UUT measurement test cycle completes.
  1.030  MEMI
  1.030  MEMI         Enter UUT reading in milliamps:
  1.031  MEMCX  20    mA             1.5% 0.05U
  2.001  JMPL         ACI_5000V_5MOhm_PASS_FAIL_TEST

# Establish TARGET for post test Repeat and Cancel.
  2.002  TARGET       -p
  2.003  JMPL         ACI_5000V_5MOhm

  2.004  LABEL        ACI_5000V_5MOhm_PASS_FAIL_TEST
  2.005  EVAL   -s "  UUT PASS/FAIL Indication" : Is UUT displaying "PASS"?

  3.001  RSLT         =  1500 V / 100 kOhm
  3.002  TSET         CPT = 15.00 mA
  3.003  TARGET       -p

  3.004  LABEL        ACI_1500V_100kOhm
  3.005  DISP         Move connection at 5320A-LOAD to 10 mA/500 kOhm.
  3.006  DISP         Press F1 (PROGRAM).
  3.006  DISP
  3.006  DISP         Press F3 (NEXT) to highlight VOLT value.
  3.006  DISP         Press F1 (INC.) to select VOLT :1.500kV
  3.006  DISP
  3.006  DISP         Press F4 (EXIT).
  3.007  TARGET       -m
  3.008  DISP         Press START and then select Advance immediately.
  3.009  MATH         SAFEON("UUT", "1500V", "Sine")
  3.010  CALL         Sub Read /DMM
  3.011  WAIT         [D1000]
  3.012  MATH         SAFEOFF("UUT")
  3.013  MATH         @DMM_Meas = MEM
  3.014  CALL         Sub Get Accuracy /DMM
  3.015  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
  3.016  ACC    15    mA             L1U
  3.017  MEMI         Wait until UUT measurement test cycle completes.
  3.017  MEMI
  3.017  MEMI         Enter UUT reading in milliamps:
  3.018  MEMCX  20    mA             1.5% 0.05U
  4.001  JMPL         ACI_1500V_100kOhm_PASS_FAIL_TEST

  4.002  TARGET       -p
  4.003  JMPL         ACI_1500V_100kOhm

  4.004  LABEL        ACI_1500V_100kOhm_PASS_FAIL_TEST
  4.005  EVAL   -s "  UUT PASS/FAIL Indication" : Is UUT displaying "PASS"?

  5.001  RSLT         =  1000 V / 100 kOhm
  5.002  TSET         CPT = 10.00 mA
  5.003  TARGET       -p

  5.004  LABEL        ACI_1000V_100kOhm
  5.005  DISP         Press F1 (PROGRAM).
  5.005  DISP
  5.005  DISP         Press F3 (NEXT) to highlight VOLT value.
  5.005  DISP         Press F1 (INC.) or F2 (DEC.) to select VOLT :1.000kV
  5.005  DISP
  5.005  DISP         Press F4 (EXIT).
  5.006  TARGET       -m
  5.007  DISP         Press START and then select Advance immediately.
  5.008  MATH         SAFEON("UUT", "1000V", "Sine")
  5.009  CALL         Sub Read /DMM
  5.010  WAIT         [D1000]
  5.011  MATH         SAFEOFF("UUT")
  5.012  MATH         @DMM_Meas = MEM
  5.013  CALL         Sub Get Accuracy /DMM
  5.014  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
  5.015  ACC    10    mA             L1U
  5.016  MEMI         Wait until UUT measurement test cycle completes.
  5.016  MEMI
  5.016  MEMI         Enter UUT reading in milliamps:
  5.017  MEMCX  20    mA             1.5% 0.05U
  6.001  JMPL         ACI_1000V_100kOhm_PASS_FAIL_TEST

  6.002  TARGET       -p
  6.003  JMPL         ACI_1000V_100kOhm

  6.004  LABEL        ACI_1000V_100kOhm_PASS_FAIL_TEST
  6.005  EVAL   -s "  UUT PASS/FAIL Indication" : Is UUT displaying "PASS"?

  7.001  RSLT         =  1250 V / 250 kOhm
  7.002  TSET         CPT = 5.00 mA
  7.003  TARGET       -p

  7.004  LABEL        ACI_1250V_250kOhm
  7.005  DISP         Move connection at 5320A-LOAD to 10 mA/250 kOhm.
  7.006  DISP         Press F1 (PROGRAM).
  7.006  DISP
  7.006  DISP         Press F3 (NEXT) to highlight VOLT value.
  7.006  DISP         Press F1 (INC.) or F2 (DEC.) to select VOLT :1.250kV
  7.006  DISP
  7.006  DISP         Press F4 (EXIT).
  7.007  TARGET       -m
  7.008  DISP         Press START and then select Advance immediately.
  7.009  MATH         SAFEON("UUT", "1250V", "Sine")
  7.010  CALL         Sub Read /DMM
  7.011  WAIT         [D1000]
  7.012  MATH         SAFEOFF("UUT")
  7.013  MATH         @DMM_Meas = MEM
  7.014  CALL         Sub Get Accuracy /DMM
  7.015  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
  7.016  ACC    5     mA             L1U
  7.017  MEMI         Wait until UUT measurement test cycle completes.
  7.017  MEMI
  7.017  MEMI         Enter UUT reading in milliamps:
  7.018  MEMCX  20    mA             1.5% 0.05U
  8.001  JMPL         ACI_1250V_250kOhm_PASS_FAIL_TEST

  8.002  TARGET       -p
  8.003  JMPL         ACI_1250V_250kOhm

  8.004  LABEL        ACI_1250V_250kOhm_PASS_FAIL_TEST
  8.005  EVAL   -s "  UUT PASS/FAIL Indication" : Is UUT displaying "PASS"?

  9.001  RSLT         =
  9.002  HEAD         AC OUTPUT CURRENT:{ 3 mA Range}
  9.003  RSLT         =  1250 V / 500 kOhm
  9.004  TSET         CPT = 2.500 mA
  9.005  TARGET       -p

  9.006  LABEL        ACI_1250V_500kOhm
  9.007  DISP         Move connection at 5320A-LOAD to 10 mA/500 kOhm.
  9.008  DISP         Press F1 (PROGRAM).
  9.008  DISP
  9.008  DISP         Press F3 (NEXT) to highlight HIGH value.
  9.008  DISP         Press F2 (DEC.) to select HIGH : 3.00mA
  9.008  DISP
  9.008  DISP         Press F4 (EXIT).
  9.009  TARGET       -m
  9.010  DISP         Press START and then select Advance immediately.
  9.011  MATH         SAFEON("UUT", "1250V", "Sine")
  9.012  CALL         Sub Read /DMM
  9.013  WAIT         [D1000]
  9.014  MATH         SAFEOFF("UUT")
  9.015  MATH         @DMM_Meas = MEM
  9.016  CALL         Sub Get Accuracy /DMM
  9.017  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
  9.018  ACC    2.5   mA             L1U
  9.019  MEMI         Wait until UUT measurement test cycle completes.
  9.019  MEMI
  9.019  MEMI         Enter UUT reading in milliamps:
  9.020  MEMCX  3     mA             1.5% 0.005U
 10.001  JMPL         ACI_1250V_500kOhm_PASS_FAIL_TEST

 10.002  TARGET       -p
 10.003  JMPL         ACI_1250V_500kOhm

 10.004  LABEL        ACI_1250V_500kOhm_PASS_FAIL_TEST
 10.005  EVAL   -s "  UUT PASS/FAIL Indication" : Is UUT displaying "PASS"?

 11.001  RSLT         =  1250 V / 5 MOhm
 11.002  TSET         CPT = 0.250 mA
 11.003  TARGET       -p

 11.004  LABEL        ACI_1250V_5MOhm
 11.005  DISP         Move connection at 5320A-LOAD to 1 mA/5 MOhm.
 11.006  TARGET       -m
 11.007  DISP         Press START and then select Advance immediately.
 11.008  MATH         SAFEON("UUT", "1250V", "Sine")
 11.009  CALL         Sub Read /DMM
 11.010  WAIT         [D1000]
 11.011  MATH         SAFEOFF("UUT")
 11.012  MATH         @DMM_Meas = MEM
 11.013  CALL         Sub Get Accuracy /DMM
 11.014  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
 11.015  ACC    0.24  mA             L1U
 11.016  MEMI         Wait until UUT measurement test cycle completes.
 11.016  MEMI
 11.016  MEMI         Enter UUT reading in milliamps:
 11.017  MEMCX  3     mA             1.5% 0.005U
 12.001  JMPL         ACI_1250V_5MOhm_PASS_FAIL_TEST

 12.002  TARGET       -p
 12.003  JMPL         ACI_1250V_5MOhm

 12.004  LABEL        ACI_1250V_5MOhm_PASS_FAIL_TEST
 12.005  EVAL   -s "  UUT PASS/FAIL Indication" : Is UUT displaying "PASS"?

 13.001  DISP         Remove all connections.
 13.002  END
