﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub QuadTech Sentry Plus (1 yr) ACV VER /5320
DATE:                  2016-06-28 11:48:14
AUTHOR:                Fluke
REVISION:              $Revision: 16401 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       6
NUMBER OF LINES:       166
CONFIGURATION:         Fluke 5320A
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Model(s) Covered:
#        Sentry 10 Plus, Sentry 20 Plus, & Sentry 30 Plus
#
#  This procedure contains the following tests whose Test Uncertainty Ratio
#  are less than 4:1.
#        AC Voltage
#                     - 1.000 kV      TUR 1.5000
#                     - 2.000 kV      TUR 1.6667
#                     - 5.000 kV      TUR 1.8333
#
#  Additional Equipment Required:
#        Adapter: Clip lead to single banana (m)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {AC OUTPUT VOLTAGE}
  1.003  TSET         TDESC = 0.050kV @ [V @LineFreq]Hz
  1.004  TARGET       -p
  1.005  5320         Mode = Meter; +Voltage = 0.050 kV
  1.005  5320         Freq = [V @LineFreq] Hz; Setup
  1.006  DISP         Connect the UUT to the 5320A as follows:
  1.006  DISP
  1.006  DISP         [32]   UUT                      5320A
  1.006  DISP         [32] OUTPUT <=============> METER INPUT V (1)
  1.006  DISP         [32] RTN/LOW <============> METER INPUT COM
  1.006  DISP
  1.006  DISP         1. Requires clip lead to single banana (m) adapter.
  1.007  DISP         Press F1 (PROGRAM).
  1.007  DISP
  1.007  DISP         Press F3 (NEXT) to highlight mode.
  1.007  DISP         Press F1 (INC.) or F2 (DEC.) to select "AC" mode.
  1.007  DISP
  1.007  DISP         Press F3 (NEXT) to highlight VOLT value.
  1.007  DISP         Press F1 (INC.) or F2 (DEC.) to select VOLT :0.050kV
  1.007  DISP
  1.007  DISP         Press F3 (NEXT) to highlight TIME value.
  1.007  DISP         Press F1 (INC.) or F2 (DEC.) to select TIME :  5.0s
  1.007  DISP
  1.007  DISP         Press F4 (EXIT).
  1.008  TARGET       -m
  1.009  DISP         Press START and then select Advance immediately.
  1.010  MATH         SAFEON("UUT", "50 V", "Sine")
  1.011  WAIT         -t 2 Settling...
  1.012  5320         Mode = Meter; +Voltage = 0.050 kV
  1.012  5320         Freq = [V @LineFreq] Hz; Read
  1.013  WAIT         [D1000]
  1.014  MATH         SAFEOFF("UUT")
  1.015  MEMC   5     0.050kV        1% 0.005U

  2.001  TSET         TDESC = 0.500kV @ [V @LineFreq]Hz
  2.002  TARGET       -p
  2.003  5320         Mode = Meter; +Voltage = 0.500 kV
  2.003  5320         Freq = [V @LineFreq] Hz; Setup
  2.004  DISP         Press F1 (PROGRAM).
  2.004  DISP
  2.004  DISP         Press F3 (NEXT) to highlight VOLT value.
  2.004  DISP         Press F1 (INC.) or F2 (DEC.) to select VOLT :0.500kV
  2.004  DISP
  2.004  DISP         Press F4 (EXIT).
  2.005  TARGET       -m
  2.006  DISP         Press START and then select Advance immediately.
  2.007  MATH         SAFEON("UUT", "500 V", "Sine")
  2.008  WAIT         -t 2 Settling...
  2.009  5320         Mode = Meter; +Voltage = 0.500 kV
  2.009  5320         Freq = [V @LineFreq] Hz; Read
  2.010  WAIT         [D1000]
  2.011  MATH         SAFEOFF("UUT")
  2.012  MEMC   5     0.500kV        1% 0.005U

  3.001  DISP         Remove all connections.

  3.002  TSET         TDESC = 1.000kV @ [V @LineFreq]Hz
  3.003  TARGET       -p
  3.004  PIC          qt_sentry_plus_5320_10kV_div.jpg
  3.005  5320         Mode = Meter; +Voltage = 1.000 kV
  3.005  5320         Freq = [V @LineFreq] Hz; Probe = 10kV; Setup
  3.006  DISP         Press F1 (PROGRAM).
  3.006  DISP
  3.006  DISP         Press F3 (NEXT) to highlight VOLT value.
  3.006  DISP         Press F1 (INC.) or F2 (DEC.) to select VOLT :1.000kV
  3.006  DISP
  3.006  DISP         Press F4 (EXIT).
  3.007  TARGET       -m
  3.008  DISP         Press START and then select Advance immediately.
  3.009  MATH         SAFEON("UUT", "1000 V", "Sine")
  3.010  WAIT         -t 2 Settling...
  3.011  5320         Mode = Meter; +Voltage = 1.000 kV
  3.011  5320         Freq = [V @LineFreq] Hz; Probe = 10kV; Read
  3.012  WAIT         [D1000]
  3.013  MATH         SAFEOFF("UUT")
  3.014  MEMC   5     1.000kV        1% 0.005U
#! WARNING: Test Tol 15, Sys Tol 10 V, TUR 1.5000 (< 4.00).

  4.001  TSET         TDESC = 2.000kV @ [V @LineFreq]Hz
  4.002  TARGET       -p
  4.003  5320         Mode = Meter; +Voltage = 2.000 kV
  4.003  5320         Freq = [V @LineFreq] Hz; Probe = 10 kV; Setup
  4.004  DISP         Press F1 (PROGRAM).
  4.004  DISP
  4.004  DISP         Press F3 (NEXT) to highlight VOLT value.
  4.004  DISP         Press F1 (INC.) or F2 (DEC.) to select VOLT :2.000kV
  4.004  DISP
  4.004  DISP         Press F4 (EXIT).
  4.005  TARGET       -m
  4.006  DISP         Press START and then select Advance immediately.
  4.007  MATH         SAFEON("UUT", "2000 V", "Sine")
  4.008  WAIT         -t 2 Settling...
  4.009  5320         Mode = Meter; +Voltage = 2.000 kV
  4.009  5320         Freq = [V @LineFreq] Hz; Probe = 10 kV; Read
  4.010  WAIT         [D1000]
  4.011  MATH         SAFEOFF("UUT")
  4.012  MEMC   5     2.000kV        1% 0.005U
#! WARNING: Test Tol 25, Sys Tol 15 V, TUR 1.6667 (< 4.00).

  5.001  TSET         TDESC = 5.000kV @ [V @LineFreq]Hz
  5.002  TARGET       -p
  5.003  5320         Mode = Meter; +Voltage = 5.000 kV
  5.003  5320         Freq = [V @LineFreq] Hz; Probe = 10 kV; Setup
  5.004  DISP         Press F1 (PROGRAM).
  5.004  DISP
  5.004  DISP         Press F3 (NEXT) to highlight VOLT value.
  5.004  DISP         Press F1 (INC.) or F2 (DEC.) to select VOLT :5.000kV
  5.004  DISP
  5.004  DISP         Press F4 (EXIT).
  5.005  TARGET       -m
  5.006  DISP         Press START and then select Advance immediately.
  5.007  MATH         SAFEON("UUT", "5000 V", "Sine")
  5.008  WAIT         -t 2 Settling...
  5.009  5320         Mode = Meter; +Voltage = 5.000 kV
  5.009  5320         Freq = [V @LineFreq] Hz; Probe = 10 kV; Read
  5.010  WAIT         [D1000]
  5.011  MATH         SAFEOFF("UUT")
  5.012  MEMC   5     5.000kV        1% 0.005U
#! WARNING: Test Tol 55, Sys Tol 30 V, TUR 1.8333 (< 4.00).

  6.001  DISP         Remove all connections.
  6.002  END
