﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub QuadTech Sentry Plus (1 yr) DCI VER /5320LOAD,DMM
DATE:                  2016-06-28 11:47:44
AUTHOR:                Fluke
REVISION:              $Revision: 16401 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       6
NUMBER OF LINES:       181
CONFIGURATION:         Digital Multimeter
STANDARD:              Fluke 5320A-LOAD
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Model(s) Covered:
#        Sentry 20 Plus & Sentry 30 Plus
#
#  Additional Equipment Required:
#        Adapter: Clip lead to single banana (m)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@DMM]
  1.003  ENDIF

  1.004  RSLT         =
  1.005  HEAD         {DC OUTPUT CURRENT}
  1.006  STD          Fluke 5320A-LOAD
  1.007  CALL         Sub Initialize /DMM
  1.008  MATH         @DMM_Func = "DC_Current";
  1.009  CALL         Sub Reset /DMM
  1.010  CALL         Sub Setup /DMM

  1.011  RSLT         = 1000 V / 250 kOhm
  1.012  TSET         CPT = 4.00 mA
  1.013  TARGET       -p
  1.014  MATH         S[1] = @DMM_DevName
  1.015  DISP         Connect UUT and [S1] to the 5320A-LOAD
  1.015  DISP         as follows:
  1.015  DISP
  1.015  DISP         [32] UUT OUTPUT <========> 5320A-LOAD 40 mA/250 kOhm (1)
  1.015  DISP
  1.015  DISP         [32] UUT RTN/LOW <=======> [S1] [V @DMM_CurrentLo]
  1.015  DISP
  1.015  DISP         [32] 5320A-LOAD COM <====> [S1] [V @DMM_CurrentHi]
  1.015  DISP
  1.015  DISP         1. Requires clip lead to single banana (m) adapter.
  1.016  DISP         Press F1 (PROGRAM).
  1.016  DISP
  1.016  DISP         Press F3 (NEXT) to highlight mode.
  1.016  DISP         Press F1 (INC.) or F2 (DEC.) to select "DC" mode.
  1.016  DISP
  1.016  DISP         Press F3 (NEXT) to highlight VOLT value.
  1.016  DISP         Press F1 (INC.) or F2 (DEC.) to select VOLT :1.000kV
  1.016  DISP
  1.016  DISP         Press F3 (NEXT) to highlight HIGH value.
  1.016  DISP         Press F1 (INC.) or F2 (DEC.) to select HIGH : 5.00mA
  1.016  DISP
  1.016  DISP         Press F3 (NEXT) to highlight TIME value.
  1.016  DISP         Press F1 (INC.) or F2 (DEC.) to select TIME : 15.0s
  1.016  DISP
  1.016  DISP         Press F4 (EXIT).
  1.017  TARGET       -m
  1.018  DISP         Press START and then select Advance immediately.
  1.019  MATH         SAFEON("UUT", "1000V", "")
  1.020  CALL         Sub Read /DMM
  1.021  WAIT         [D1000]
  1.022  MATH         SAFEOFF("UUT")
  1.023  MATH         @DMM_Meas = MEM
  1.024  CALL         Sub Get Accuracy /DMM
  1.025  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
  1.026  ACC    4     mA             L1U
  1.027  MEMI         Wait until UUT measurement test cycle completes.
  1.027  MEMI
  1.027  MEMI         Enter UUT reading in milliamps:
  1.028  MEMCX  20    mA             1.5% 0.05U    1000V

  2.001  RSLT         = 1000 V / 500 kOhm
  2.002  TSET         CPT = 2.00 mA
  2.003  TARGET       -p
  2.004  DISP         Move connection at 5320A-LOAD to 10 mA/500 kOhm.
  2.005  TARGET       -m
  2.006  DISP         Press START and then select Advance immediately.
  2.007  MATH         SAFEON("UUT", "1000V", "")
  2.008  CALL         Sub Read /DMM
  2.009  WAIT         [D1000]
  2.010  MATH         SAFEOFF("UUT")
  2.011  MATH         @DMM_Meas = MEM
  2.012  CALL         Sub Get Accuracy /DMM
  2.013  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
  2.014  ACC    2     mA             L1U
  2.015  MEMI         Wait until UUT measurement test cycle completes.
  2.015  MEMI
  2.015  MEMI         Enter UUT reading in milliamps:
  2.016  MEMCX  20    mA             1.5% 0.05U    1000V

  3.001  TSET         CPT = 2.00 mA
  3.002  TARGET       -p
  3.003  DISP         Press F1 (PROGRAM).
  3.003  DISP
  3.003  DISP         Press F3 (NEXT) to highlight HIGH value.
  3.003  DISP         Press F1 (INC.) or F2 (DEC.) to select HIGH : 3.00mA
  3.003  DISP
  3.003  DISP         Press F4 (EXIT).
  3.004  TARGET       -m
  3.005  DISP         Press START and then select Advance immediately.
  3.006  MATH         SAFEON("UUT", "1000V", "")
  3.007  CALL         Sub Read /DMM
  3.008  WAIT         [D1000]
  3.009  MATH         SAFEOFF("UUT")
  3.010  MATH         @DMM_Meas = MEM
  3.011  CALL         Sub Get Accuracy /DMM
  3.012  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
  3.013  ACC    2     mA             L1U
  3.014  MEMI         Wait until UUT measurement test cycle completes.
  3.014  MEMI
  3.014  MEMI         Enter UUT reading in milliamps:
  3.015  MEMCX  20    mA             1.5% 0.05U    1000V

  4.001  RSLT         = 1000 V / 5 MOhm
  4.002  TSET         CPT = 0.20 mA
  4.003  TARGET       -p
  4.004  MATH         S[1] = @DMM_DevName
  4.005  DISP         Move connection at 5320A-LOAD to 1 mA/5 MOhm.
  4.006  TARGET       -m
  4.007  DISP         Press START and then select Advance immediately.
  4.008  MATH         SAFEON("UUT", "1000V", "")
  4.009  CALL         Sub Read /DMM
  4.010  WAIT         [D1000]
  4.011  MATH         SAFEOFF("UUT")
  4.012  MATH         @DMM_Meas = MEM
  4.013  CALL         Sub Get Accuracy /DMM
  4.014  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
  4.015  ACC    0.2   mA             L1U
  4.016  MEMI         Wait until UUT measurement test cycle completes.
  4.016  MEMI
  4.016  MEMI         Enter UUT reading in milliamps:
  4.017  MEMCX  20    mA             1.5% 0.05U    1000V

  5.001  TSET         CPT = 0.20 mA
  5.002  TARGET       -p
  5.003  MATH         S[1] = @DMM_DevName
  5.004  DISP         Move connection at 5320A-LOAD to 1 mA/5 MOhm.
  5.005  DISP         Press F1 (PROGRAM).
  5.005  DISP
  5.005  DISP         Press F3 (NEXT) to highlight HIGH value.
  5.005  DISP         Press F1 (INC.) or F2 (DEC.) to select HIGH : 0.30mA
  5.005  DISP
  5.005  DISP         Press F4 (EXIT).
  5.006  TARGET       -m
  5.007  DISP         Press START and then select Advance immediately.
  5.008  MATH         SAFEON("UUT", "1000V", "")
  5.009  CALL         Sub Read /DMM
  5.010  WAIT         [D1000]
  5.011  MATH         SAFEOFF("UUT")
  5.012  MATH         @DMM_Meas = MEM
  5.013  CALL         Sub Get Accuracy /DMM
  5.014  MATH         L[1] = @DMM_Acc / 1E-3; MEM = MEM / 1E-3
  5.015  ACC    0.2   mA             L1U
  5.016  MEMI         Wait until UUT measurement test cycle completes.
  5.016  MEMI
  5.016  MEMI         Enter UUT reading in milliamps:
  5.017  MEMCX  20    mA             1.5% 0.05U    1000V

  6.001  END
