<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Edit.Master" Inherits="System.Web.Mvc.ViewPage<orx.Models.File>" %>

<%@ Import Namespace="orx" %>
<%@ Import Namespace="orx.Helpers" %>
<%@ Import Namespace="orx.Models" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" runat="server">
    <script src="<%: Url.Content("~/Scripts/jquery.validate.min.js") %>" type="text/javascript"></script>
    <script src="<%: Url.Content("~/Scripts/jquery.validate.unobtrusive.min.js") %>" type="text/javascript"></script>
    <% 
        var isNewRecord = (GuidHelper.GuidHandler.IsNewRecord(Model.PrimaryKey));
        var isLocked = Model.nManualTemplateUID.HasValue;
    %>
    <style type="text/css">
        .tb-download {
            background-image: url( ../../Content/images/icons/open.png ) !important;
            width: 48px !important;
        }
    </style>
    <script type="text/javascript">

        var myTable = '<%: Html.GetTable( Model ) %>';
        var recordID = '<%: Model.PrimaryKey %>';
        var isNewRecord = <%: GuidHelper.AspxGuidHandler.IsNewRecord(Model.PrimaryKey) %>;
        var varFirst = true;

        var chkURLHandler = {
            check: function (self) {
                if (self.getValue()) {
                    // Show the url panel.
                    Ext.getCmp('pnlUploadURL').setVisible(true);
                    Ext.getCmp('cmdUploadFile').getEl().parent().setVisible(false);

                    //MTM-4153: disable file name to force new comments
                    if (varFirst === false) {
                        Ext.getCmp("cFileName").setValue("");
                        editWindow.setDataDirty();
                    }
                    varFirst = false;

                } else {
                    // Show the file upload panel.
                    Ext.getCmp('pnlUploadURL').setVisible(false);
                    Ext.getCmp('cmdUploadFile').getEl().parent().setVisible(true);

                    //MTM-4153: disable URL and file name
                    if (varFirst === false) {
                        if (Ext.getCmp("cFilePath") !== "") {
                            Ext.getCmp("cFilePath").setValue("");
                            editWindow.setDataDirty();
                        }
                    }
                    varFirst = false;
                }
            },
            // MTM-4130 This is needed so the customize menu will appear on a right click
            render: function (e) {
                initField(e, 'Files', e.id);
            }
        };

        function setDefaultText(val) {
            var cmb = Ext.getCmp('cFileType');
            if (cmb !== undefined) {

                // Iterate through it's items.
                cmb.getStore().each(function (item) {
                    if (item.get('cText') === val) {
                        cmb.setValue(val);
                    }
                });

            }
        }

        function notImplemented() {
            top.Ext.Msg.alert(___('NOT_IMPLEMENTED_TITLE'), ___('NOT_IMPLEMENTED_MSG'));
        }

        function changeFile() {
            //debugger;
            Ext.getCmp("cmdUploadFile").fileInput.dom.click();
        }

        function downloadFile() {
            File.Open(recordID);
		//window.open( '<%: Url.Content( "~/File/Open/" ) %>' + recordID );
        }

        function doFind() {
            var findWindow = app.openWindow({
                title: ___('FIND_FILE_TITLE'),
                url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            modal: true,
            callbacks: {
                context: "FindFiles",
                controller: "File",
                //MTM-4199
                //cancel: function() {
                //	findWindow.close();
                //}, 
                onRecordSelected: function (record) {
                    var id = record.get("UID");
                    window.location = '<%: Url.Content( "~/File/Edit" ) %>/' + id;
                    findWindow.close();
                }
            }
        });
        }

        // This function is called automatically whenever the DataDirty state changes
        function onDataDirtyChanged() {

            var dirty = editWindow.getDataDirty();

            Ext.getCmp("tbSave").setDisabled(!dirty);
            Ext.getCmp("tbCancel").setDisabled(!dirty);

            Ext.getCmp("tbClose").setDisabled(dirty);
            Ext.getCmp("tbAdd").setDisabled(dirty);
            Ext.getCmp("tbDelete").setDisabled(dirty);
            Ext.getCmp("tbFind").setDisabled(dirty);
            Ext.getCmp("tbExtract").setDisabled(dirty);

        }

        function cancelEdit() {
            Ext.Msg.confirm(___('CANCEL'), ___('DISCARD_CHANGES'), function (btn) {
                if (btn == "yes") {
                    if (isNewRecord) {
                        editWindow.clearDataDirty();
                        clientWindow.close(true);
                    }
                    else {
                        window.location.reload();
                    }
                }
            });
        }

        var onLoadListener = {
            enable: function () {
                var btn = Ext.getCmp('cmdUploadFile');
                btn.setDisabled(false);
            },
            disable: function () {
                var btn = Ext.getCmp('cmdUploadFile');
                btn.setDisabled(true);
            },
            change: function () {
                if (Ext.getCmp('lUrl').getValue() == 0)
                    return;

                editWindow.setDataDirty();
            }
        };

        editForm = Ext.extend(Ext.form.FormPanel, {

            id: 'edit-form',
            url: window.location,
            frame: false,
            hideBorders: true,
            labelWidth: 120,
            labelAlign: 'top',
            layout: 'fit',
            height: 300,
            width: 500,
            // Must be specified in order to upload files
            // http://stackoverflow.com/a/5468215/154165
            fileUpload: true,

            defaults: {
                msgTarget: 'side'
            },

            initComponent: function () {
                this.items = [
                    {
                        xtype: 'panel',
                        layout: 'absolute',
                        width: 500,
                        height: 250,
                        items: [
						<%= Html.Field( m => Model.lActive, new { X = 10, Y = 10, Width = 125, ReadOnly = isLocked } ) %>,
                        <%= Html.Field( m => Model.lUrl, new { X = 10, Y = 35, Width = 125, ReadOnly = isLocked, Listeners = "chkURLHandler" } ) %>,
						<%= Html.Label( m => Model.cFileType, new { X = 10, Y = 65, Width = 125 } ) %>,

						<%= Html.Field(
                            m => Model.cFileType, new {
                                X = 10,
                                Y = 80,
                                Width = 200,
                                Store = new ExtArrayStore {
                                    AutoLoad = true,
                                    Fields = new string[] { "cText", "cTextLocalized" },
                                    // Note: This list MUST be kept in sync with the list defined in UCIHelper.cs GetComboItems()! With the exception of Manual Templates, we do not need manual templates on this view.
                                    Data = new List<object> {
                                        new List<string> { "Accreditation", L.__("Accreditation") },
                                        new List<string> { "Asset", L.__("Asset") },
                                        new List<string> { "Checklist", L.__("Checklist") },
                                        new List<string> { "Facility", L.__("Facility") },
                                        new List<string> { "Image", L.__("Image") },
                                        new List<string> { "Job Number", L.__("Job Number") },
                                        new List<string> { "Part", L.__("Part") },
                                        new List<string> { "Problem Report", L.__("Problem Report") },
                                        new List<string> { "Procedure", L.__("Procedure") },
                                        new List<string> { "Project", L.__("Project") },
                                        new List<string> { "Tool Assignment", L.__("Tool Assignment") },
                                        new List<string> { "Type", L.__("Type") },
                                        new List<string> { "Work Order", L.__("Work Order") }
                                     }
                                },
                                DisplayField = "cTextLocalized",
                                ValueField = "cText",
                                ReadOnly = isLocked
                            }
                        ) %>,

                        new Ext.Container({
                            id: 'pnlUploadFile',
                            x: 10,
                            y: 115,
                            layout: {
                                type: 'table',
                                columns: 2
                            },
                            items: [
								<%= Html.Label( m => Model.cFileName, new { Colspan = 2 } ) %>,
								<%= Html.Field( m => Model.cFileName, new { Width = 370, Listeners = "onLoadListener" } ) %>,
                                {
                                    xtype: 'fileuploadfield',
                                    id: 'cmdUploadFile',
                                    name: 'iFile',
                                    readOnly: '<%= isLocked.ToString().ToLower() %>',
                                    buttonOnly: true,
                                    tooltip: ___('CALLSHEET_BROWSE_FOR_FILE_TOOLTIP'),
                                    buttonCfg: {
                                        id: 'btnFileUpload',
                                        text: ___('BROWSE_FILE')
                                    },
                                    listeners: {
                                        fileselected: function (fb, v) {
                                            Ext.getCmp("cFileName").setValue(v.replace(/^.*[\\\/]/, ''));
                                            editWindow.setDataDirty();
                                        },
                                        afterrender: function (self) {
                                            // Check if the filename control is disabled.
                                            if (Ext.getCmp('cFileName').disabled) {
                                                self.setDisabled(true);
                                            }
                                        }
                                    }
                                }
                            ]
                        }),

                        new Ext.Container({
                            hidden: true,
                            id: 'pnlUploadURL',
                            x: 10,
                            y: 165,
                            layout: {
                                type: 'table',
                                columns: 2
                            },
                            items: [
								<%= Html.Label( m => Model.cFilePath, new { Colspan = 2 }) %>,
								<%= Html.Field( m => Model.cFilePath, new { Width = 460 }) %>
                            ]
                        })
                    ]
                }
            ];
            this.tbar = {
                xtype: 'toolbar',
                border: false,
                frame: false,
                margin: 0,
                padding: 0,
                defaults: {
                    scale: 'large',
                    iconAlign: 'top',
                    cls: 'x-btn-icon-text',
                    width: 50,
                    height: 50
                },
                items: [
					<%= new ExtButton( "Files", "tbFind" ) { 
						Text = L.__("FIND"), 
                        Tooltip= L.__("FIND"), //MTM-2521 : Tooltip added
				        IconClass = "tb-find",
				        CSSClass = "x-btn-icon-text",
				        Handler = "doFind",
						Disabled = false
					} %>,
                    { xtype: 'menuseparator' },
//					%= new ExtButton( "Files", "tbChange" ) {
//						Text = "Change", 
//						IconClass = "tb-change",
//                      CSSClass = "x-btn-icon-text",
//						Handler = "changeFile",
//						Disabled = isNewRecord,
//						Hidden = true
//					} %>,
					<%= new ExtButton( "Files", "tbAdd" ) { 
						Text = L.__("ADD"), 
                        Tooltip= L.__("ADD"), //MTM-2521 : Tooltip added
						IconClass = "tb-add",
				        CSSClass = "x-btn-icon-text",
						Handler = "this.doAdd",
						Disabled = isNewRecord
					} %>,
					<%= new ExtButton( "Files", "tbDelete" ) { 
						Text = L.__("DELETE"), 
                        Tooltip= L.__("DELETE"), //MTM-2521 : Tooltip added
						IconClass = "tb-delete",
				        CSSClass = "x-btn-icon-text",
						Handler = "this.doDelete",
						Disabled = isNewRecord
					} %>,
                    { xtype: 'menuseparator' },
					<%= new ExtButton( "Files", "tbExtract" ) { 
						Text = L.__("EXTRACT"), 
                        Tooltip= L.__("EXTRACT"), //MTM-2521 : Tooltip added
						IconClass = "tb-download",
				        CSSClass = "x-btn-icon-text",
						Handler = "downloadFile",
						Disabled = isNewRecord
					} %>,
                    { xtype: 'menuseparator' },
					<%= new ExtButton( "Files", "tbSave" ) { 
						Text = L.__("SAVE"), 
                        Tooltip= L.__("SAVE"), //MTM-2521 : Tooltip added
						IconClass = "tb-save",
				        CSSClass = "x-btn-icon-text",
						Handler = "this.doSubmit",
						Disabled = true
					} %>,
					<%= new ExtButton( "Files", "tbCancel" ) { 
					    Text = L.__("CANCEL"), 
                        Tooltip= L.__("CANCEL"), //MTM-2521 : Tooltip added
                        IconClass = "tb-cancel",
				        CSSClass = "x-btn-icon-text",
						Handler = "cancelEdit",
						Disabled = true
					} %>,
                    { xtype: 'menuseparator' },
					<%= new ExtButton( "Files", "tbClose" ) { 
						Text = L.__("CLOSE"),
                        Tooltip= L.__("CLOSE"), //MTM-2521 : Tooltip added
						IconClass = "tb-close", 
				        CSSClass = "x-btn-icon-text",
						Handler = "function() { if (window.onClose) window.onClose(); clientWindow.close(); }"
					} %>
                ]
            };
            editForm.superclass.initComponent.call(this);
        },

        doAdd: function () {
            window.location.assign("/File/Create");
        },

        doDelete: function () {
			<% if (Model.nManualTemplateUID.HasValue)
        { %>
            Ext.Msg.alert("Attention", "This is a system managed record used by the Manual Template engine.<br/>It may not be deleted.");
            return;
			<% } %>
            Ext.Msg.confirm(___('DELETE_RECORD_TITLE'), ___('DELETE_RECORD_MSG'), function (btn) {

                // If they don't answer yes, break out.
                if (btn != "yes") return;

                // If they do answer yes, then continue
                var actionUrl = '<%: Url.Content("~/File/Delete/") %>' + recordID;

                // Make the centralized framework call.
                app.call({
                    url: actionUrl,
                    params: { id: recordID },
                    success: function (result) {

                        // Alert the user to the result message in the bottom toolbar
                        app.showBusyStatus(result.message, true);

                        // Check if there were problems deleting the record
                        if (!result.success) {
                            // Pop up a message with the results.
                            Ext.Msg.alert(___('ATTENTION_TITLE'), result.message, function () { });
                        } else {
                            // Navigate to the find.
                            // Close the window and open the find screen.
                            var findWindow = app.openWindow({
                                title: ___('FIND_FILE_TITLE'),
                                url: '/Shared/Find',
                                modal: true,
                                callbacks: {
                                    context: "FindFiles",
                                    controller: "File"
                                    //MTM-4199
                                    //,
                                    //cancel: function() {
                                    //	findWindow.close();
                                    //}
                                }
                            });

                            // Close our parent screen
                            clientWindow.close();
                        }
                    },
                    error: function (err) {
                        debugger;
                        Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNKNOWN_ERROR_MSG'));
                    }
                }); // Close the app.call function.
            }); // Close the question
        },

        doSubmit: function () {
			<% if (Model.nManualTemplateUID.HasValue)
        { %>
            Ext.Msg.alert("Attention", "This is a system managed record used with the Manual Template system.<br/>Changes may not be saved.");
            return;
			<% } %>

            var form = window.form.getForm();

            // Performs client-side validation
            if (!form.isValid()) {
                return;
            }

            // Indicate busy status to user
            app.showBusyStatus(___('SAVING_INFORMATION') + " <%: Html.GetTable( Model ) %> ", true);

            // Perform Ext form submission via Ajax
            form.submit({
                url: window.location.toString(),
                params: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                },  
                waitMsg: ___('SAVING_FILE'),
                waitTitle: ___('PLEASE_WAIT'),
                success: function (form, action) {

                    // When a new record is created, action.result.id will contain the 
                    // new record's primary key value
                    if (action.result && action.result.id) {
                        // If we saved the record and a new uid is returned, update
                        // the recordID variable so we can perform more actions.
                        recordID = action.result.id;
                    } else if (!(action.result || {}).success) {
                        // Otherwise, if there is a success and it's a failure
                        // then print the error message.
                        Ext.Msg.alert(___("Attention"), ___("FILE_UPLOAD_ERROR_TOO_BIG"));
                    }

                    editWindow.clearDataDirty();
                    Ext.getCmp("cFileType").setDisabled(false);

                    app.sendMessage("recordchanged", {
                        table: myTable,
                        id: recordID,
                        sender: editForm
                    });

                    app.setStatus(___('FILE_SAVED'), true);

                    if (window.onSave) {
                        window.onSave(recordID);
                        clientWindow.close(true);
                    } else {
                        if (((action || {}).result || {}).id || 0 > 0) {
                            window.location.assign("/File/Edit/" + action.result.id);
                        }
                    }

                },
                failure: function (form, action) {
                    switch (action.failureType) {
                        case Ext.form.Action.CLIENT_INVALID:
                            app.showError(___('VALIDATION_ERROR_TITLE'), ___('VALIDATION_ERROR_MSG'));
                            break;
                        case Ext.form.Action.CONNECT_FAILURE:
                            app.showError(___('COMMUNICATION_ERROR_TITLE'), ___('COMMUNICATION_ERROR_MSG'));
                            break;
                        case Ext.form.Action.SERVER_INVALID:
                            if (action.result && action.result.errors) {

                                // If the DataChecks script changed anything in the model,
                                // the changed data will be in [action.result.model] as 
                                // JSON data, which will need to be parsed, and the changes
                                // reflected in the UI.
                                var changed = JSON.parse(action.result.model);
                                clientWindow.updateFields(changed);

                                // The DataCheck validation script may have indicated that it 
                                // wanted a dialog presented to the user. 
                                if (action.result.msg) {
                                    // Display the dialog, and wait for the close callback before
                                    // continuing with other validation updates
                                    app.showError(___('VALIDATION_ERROR_TITLE'), action.result.msg, function () {
                                        // The DataCheck script will indicate which focus should
                                        // get control by setting [action.result.focus]. If that 
                                        // value is set, attempt to set focus to the control with 
                                        // the same ID 
                                        if (action.result.focus) {
                                            clientWindow.setFocus(action.result.focus);
                                        }
                                    });
                                }

                            }
                            else {
                                app.showError(___('USER_ERROR_TITLE'), action.result.msg || ___('USER_ERROR_MSG'));
                                app.setStatus(___('USER_ERROR_STATUS_MSG'), true);
                            }
                            break;
                    }
                }
            });

        }

    });

        var form = new editForm();

        Ext.onReady(function () {

            var body = Ext.get(document.body);

            form.render(body);
            editWindow.initForm(form, myTable);

            //MTM-8297 - Code to get the History Log button control.
            var tool = clientWindow.windowObj.getTool("audit");//Get History log tool bar control

            //Code to hide the History Log button control on Add screen.
            if (tool)
                isNewRecord ? tool.hide() : tool.show();

            if (!isNewRecord)
                clientWindow.setTitle(___('EDIT') + " <%: Html.GetTable( Model ) %> - " + $("#cFileType").val());
        else
            clientWindow.setTitle(___('ADD_FILE'));

        clientWindow.setIcon("window-icon-default");

        clientWindow.setSize(515, 330);

        // 2013-05-10 - JMC
        var qs = getQueryString();
        if (qs["Type"] !== undefined) {
            setDefaultText(unescape(qs["Type"]));
        }

        editWindow.getField("cFileName").focus();

        // Call the check handler so it updates appropriately.
        chkURLHandler.check(Ext.getCmp('lUrl'));

        clientWindow.windowObj.on("message", function (tag, data) {

            // Do our best to ignore messages that originated in this window
            if (data.sender && data.sender == editForm) {
                return;
            }

            if (tag === "labelchanged" && data.table === myTable) {
                var field = editWindow.getField(data.column);
                if (field) {
                    field.setLabel(data.text);
                }
            }
            else if (tag === "recordchanged" && data.table === myTable) {
                if (data.id == recordID) {
                    // NOTE: Using Ext.Msg.alert() instead of app.showAlert() means that 
                    // only this edit window will be blocked while the dialog is displayed.
                    Ext.Msg.alert(___('RECORD_CHANGED_TITLE'), ___('RECORD_CHANGED_MSG'));
                }
            }

        });
        $('input[type="file"]').attr('title', ' '); //MTM-8559 to remove tool tip form browse button.
    });

    </script>

</asp:Content>

