<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Edit.Master" Inherits="System.Web.Mvc.ViewPage<vw_CallSheet>" %>

<%@ Import Namespace="orx" %>
<%@ Import Namespace="orx.Helpers" %>
<%@ Import Namespace="orx.Models" %>
<%@ Import Namespace="MetTeamShared" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" runat="server">

    <script src="<%=Url.Content("~/Scripts/EmxWeb.ExtendedData.js")%>"></script>
    <script src="<%=Url.Content("~/Scripts/EmxWeb.CrystalReports.js")%>"></script>
    <script src="<%: Url.Content("~/Scripts/MetTeam.Core.js") %>" type="text/javascript"></script>

    <%
        var isNewRecord = GuidHelper.GuidHandler.IsNewRecord(Model.nCallSheetUID);
        var isLocked = Model.IsClosed;
        var isMetCal = orx.Models.EmxUser.CurrentUser.IsRemoteInstance();
        var DisableStatusField = !SystemDefault.IsActive(SysDefHelper.WORK_ORDER_EDIT_STATUS);
        bool isUnlocked = Session["isUnlocked"] != null;
        var DisableAmbientConditions = !SystemDefault.IsActive(SysDefHelper.WORK_ORDER_TEMPERATURE_AND_HUMIDITY_DATA);
        var hasProc = GuidHelper.GuidHandler.IsExistingRecord(Model.nProcedureUID);

        if (isLocked) { DisableStatusField = true; }
        if (isUnlocked) { isLocked = false; }

        var isMobile = MetMobile.IsMobileInstance();

        // set flag to indicate Work Order was created after Mobile Check Out
        // if this is not a Mobile instance, this flag will always be set to true!
        bool createdAfterMobileCheckOut = DateTime.Compare(MetMobile.GetMobileCheckOutDate(), Model.tAddTime) < 0;

        var addResultsDisabled = (isNewRecord || isLocked || isMetCal);
    %>

    <input type="hidden" id="nCallSheetAttributeUID" name="nCallSheetAttributeUID" value="<%: Model.nCallSheetAttributeUID %>" />
    
    <style>
        .centered {
            text-align: center;
            background: transparent;
            border: none;
        }
    </style>

    <script type="text/javascript">

        // "enum" for the data sheet possibilities
        var t_datasheet = {
            "Error": "-1",
            "METCal": "0",
            "METTeam": "1",
            "METTeamLegacy": "2",
            "File": "3",
            "None": "4",
            "Mismatch": "5"
        };

        var setting_workOrderRevisionTracking = '<%= SystemDefault.GetValue(SysDefHelper.WORK_ORDER_REVISION_TRACKING, "") %>';
        var nCallSheetAttributeUID = '<%= (Model.nCallSheetAttributeUID ?? GuidHelper.KnownGuids.GuidNewRecord).ToString() %>';
        var createdAfterMobileCheckOut = ('<%= createdAfterMobileCheckOut %>' == 'True');
        var isMobile = '<%= MetMobile.IsMobileInstance() %>' == 'True';
        var userCannotAddAssets = ('<%:EmxUser.CurrentUser.HasAccess("/Asset/Edit/","tbAdd")%>' == 'False').toString();
        var userUID = '<%=EmxUser.CurrentUser.nUserUID%>';
        this.complete_record = <%= CallSheet.Retrieve(Model.nCallSheetUID).ToFullJSON() %>;

        var isSignedByTechnician = '<%= (Model.nTechnicianApprovedByUID != null) %>' == 'True';
        var isSignedByQC = '<%= (Model.nQCApprovedByUID != null) %>' == 'True';
        var technicianSignatureDateTimeStamp = '';
        var qcSignatureDateTimeStamp = '';
        var bypassClearSignaturesPrompt = false;
        var reloadWindow = false;

        var nonStatusChangeMade = false;
        var statusChangedOnly = false;
        var changingStatus = false;

        function showDirtyWarning(callback) {
            if (editWindow.getDataDirty() && !isUnlocked) {
                Ext.MessageBox.show({
                    title: ___('WARNING_TITLE'),
                    msg: ___('DISCARD_CHANGES_MSG'),
                    width: 350,
                    buttons: Ext.MessageBox.YESNO,
                    fn: function (result) {
                        if (result === 'no') return;

                        if (callback) callback();
                    }
                });
            }
            else {
                if (callback) callback();
            }
        }

        var stickerButtonListener = {
            afterrender: function (self) {
                var stickertype = Ext.getCmp("cStickerType");
                if (stickertype !== undefined && stickertype !== null
                    && !stickertype.isVisible()) {
                    self.setVisible(false);
                }
            }
        };

        var resultsListener = {
            afterrender: function (self) {
                doUpdateGUI();
            }
        }

        // **************************************************************************************************************
        // NOTE: If you modify any of the Signature code, you may need to make similar changes in BatchChange\Edit.aspx
        //       as well as CallSheet\CustomerCallSheetView.aspx!!
        // **************************************************************************************************************

        function doGetTechnicianSignature() {

            // if the user bypasses security by pressing the button before it gets disabled, block it here
            if ('<%:EmxUser.CurrentUser.HasAccess("/CallSheet/Edit/","cmdTechSignature")%>' == 'False')
                return;

            if (isSignedByTechnician) {
                // prompt to replace signature, remove signature, or cancel - if not cancelled, clear both signatures
                Ext.MessageBox.show({
                    title: ___('UPDATE_SIGNATURE_TITLE'),
                    msg: ___('UPDATE_CURRENT_SIGNATURE_MSG') + '<br/><br/>' + ___('UPDATING_TECHNICIAN_SIGNATURE_NOTE'),
                    width: 350,
                    buttons: Ext.MessageBox.YESNOCANCEL,
                    fn: function (result) {
                        if (result === 'cancel')
                            return;

                        if (result === 'yes') {
                            // replace current signature and remove QC signature
                            selectApprover('nTechnicianApprovedByUID', 'tTechnicianApprovedDate', updateTechnicianSignatureLabels, removeQCSignature);
                        }
                        else {
                            // remove both current signatures
                            removeTechnicianSignature();
                            removeQCSignature();

                            // bypass prompt to clear signatures in onDataDirtyChanged event handler
                            bypassClearSignaturesPrompt = true;
                            editWindow.setDataDirty();
                            // restore prompt to clear signatures
                            bypassClearSignaturesPrompt = false;
                        }
                    }
                });
            }
            else {
                // prompt to enter user/password and set date/time
                selectApprover('nTechnicianApprovedByUID', 'tTechnicianApprovedDate', updateTechnicianSignatureLabels, toggleTechnicianSignature);
            }
        }

        function removeTechnicianSignature() {
            // only remove the technician signature if there is one
            if (isSignedByTechnician) {
                var approvedBy = Ext.getCmp('nTechnicianApprovedByUID');
                var approvedByDisplay = Ext.getCmp('nTechnicianApprovedByUID_display');
                var approvedDate = Ext.getCmp('tTechnicianApprovedDate');
                if (approvedBy === undefined || approvedByDisplay === undefined || approvedDate === undefined)
                    return;

                approvedBy.setRawValue(null);
                approvedByDisplay.setValue(null);
                approvedDate.setValue(null);
                updateTechnicianSignatureLabels();
                toggleTechnicianSignature();
                removeQCSignature();
            }
        }

        function toggleTechnicianSignature() {
            isSignedByTechnician = !isSignedByTechnician;

            var signatureLabel = Ext.getCmp('techSignatureName');
            var dateStampLabel = Ext.getCmp('techSignatureDate');
            if (signatureLabel === undefined || dateStampLabel === undefined)
                return;

            signatureLabel.setVisible(isSignedByTechnician);
            dateStampLabel.setVisible(isSignedByTechnician);
        }

        function doGetQCSignature() {

            // if the user bypasses security by pressing the button before it gets disabled, block it here
            if ('<%:EmxUser.CurrentUser.HasAccess("/CallSheet/Edit/","cmdQCSignature")%>' == 'False')
                return;

            if (!isSignedByTechnician) {
                Ext.Msg.alert(___('ALERT_TITLE'), ___('APPLY_TECHNICIAN_SIGNATURE_MSG'));
                return;
            }

            if (isSignedByQC) {
                // prompt to replace signature, remove signature, or cancel - if not cancelled, clear signature
                Ext.MessageBox.show({
                    title: ___('UPDATE_SIGNATURE_TITLE'),
                    msg: ___('UPDATE_CURRENT_SIGNATURE_MSG'),
                    width: 350,
                    buttons: Ext.MessageBox.YESNOCANCEL,
                    fn: function (result) {
                        if (result === 'cancel')
                            return;

                        if (result === 'yes') {
                            // replace current signature
                            selectApprover('nQCApprovedByUID', 'tQCApprovedDate', updateQCSignatureLabels);
                        }
                        else {
                            // remove current signature
                            removeQCSignature();

                            // bypass prompt to clear signatures in onDataDirtyChanged event handler
                            bypassClearSignaturesPrompt = true;
                            editWindow.setDataDirty();
                            // restore prompt to clear signatures
                            bypassClearSignaturesPrompt = false;
                        }
                    }
                });
            }
            else {
                // prompt to enter user/password and set date/time
                selectApprover('nQCApprovedByUID', 'tQCApprovedDate', updateQCSignatureLabels, toggleQCSignature);
            }
        }

        function removeQCSignature() {
            // only remove the QC signature if there is one
            if (isSignedByQC) {
                var approvedBy = Ext.getCmp('nQCApprovedByUID');
                var approvedByDisplay = Ext.getCmp('nQCApprovedByUID_display');
                var approvedDate = Ext.getCmp('tQCApprovedDate');
                if (approvedBy === undefined || approvedByDisplay === undefined || approvedDate === undefined)
                    return;

                approvedBy.setRawValue(null);
                approvedByDisplay.setValue(null);
                approvedDate.setValue(null);
                updateQCSignatureLabels();
                toggleQCSignature();
            }
        }

        function toggleQCSignature() {
            isSignedByQC = !isSignedByQC;

            var signatureLabel = Ext.getCmp('qcSignatureName');
            var dateStampLabel = Ext.getCmp('qcSignatureDate');
            if (signatureLabel === undefined || dateStampLabel === undefined)
                return;

            signatureLabel.setVisible(isSignedByQC);
            dateStampLabel.setVisible(isSignedByQC);
        }

        function updateTechnicianSignatureLabels() {
            updateSignatureLabels('nTechnicianApprovedByUID_display', 'tTechnicianApprovedDate', 'techSignatureName', 'techSignatureDate');
        };

        function updateQCSignatureLabels() {
            updateSignatureLabels('nQCApprovedByUID_display', 'tQCApprovedDate', 'qcSignatureName', 'qcSignatureDate');
        };

        function updateSignatureLabels(approvedByDisplay, approvedDate, signatureName, signatureDate) {
            var approvedBy = Ext.getCmp(approvedByDisplay);
            var approvedDate = Ext.getCmp(approvedDate);
            if (approvedBy === undefined || approvedDate === undefined)
                return;

            var signatureLabel = Ext.getCmp(signatureName);
            var dateStampLabel = Ext.getCmp(signatureDate);
            if (signatureLabel === undefined || dateStampLabel === undefined)
                return;

            if (approvedBy.getValue() === '' || approvedBy.getValue() === null) {
                signatureLabel.setText('');
                dateStampLabel.setText('');
            }
            else {
                signatureLabel.setText(___('SIGNED_BY') + ' ' + approvedBy.getValue());
                dateStampLabel.setText(signatureDate.startsWith('qc') ? qcSignatureDateTimeStamp : technicianSignatureDateTimeStamp);
            }
        }

        function selectApprover(nameField, dateField, updateCallback, otherCallback) {
            var window = userNameAndPasswordPrompt(function (userUid) {

                var valueField = Ext.getCmp(nameField);
                var displayField = Ext.getCmp(nameField + '_display');
                if (valueField === undefined || displayField === undefined)
                    return;

                $.ajax({
                    type: 'post',
                    url: '/User/Retrieve/' + userUid,
                    data: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                    },
                    dataType: 'json',
                    success: function (user) {
                        // bypass prompt to clear signatures in onDataDirtyChanged event handler when updating approver
                        bypassClearSignaturesPrompt = true;

                        valueField.setRawValue(user.nUserUID);
                        displayField.setValue(user.FullName);
                        editWindow.setDataDirty();
                        updateApprovedDate(dateField, new Date());

                        updateCallback();
                        if (otherCallback != undefined)
                            otherCallback();

                        // restore prompt to clear signatures
                        bypassClearSignaturesPrompt = false;

                        if (window instanceof Ext.Window) {
                            window.close();
                        }
                    }
                });
            });
        }

        function userNameAndPasswordPrompt(callback) {

            var win = new Ext.Window({
                modal: true,
                width: 300,
                height: 180,
                layout: 'absolute',
                resizable: false,
                title: ___('USERNAME_PASSWORD_PROMPT_TITLE'),
                items: [
                    {
                        xtype: 'displayfield',
                        value: ___('User Name'),
                        x: 20,
                        y: 15
                    },
                    {
                        xtype: 'textfield',
                        name: 'userName',
                        id: 'userName',
                        listeners: {
                            specialKey: function (field, el) {
                                if (el.getKey() == Ext.EventObject.ENTER) {
                                    Ext.getCmp('password').focus();
                                    return false;
                                }
                            }
                        },
                        x: 20,
                        y: 35,
                        width: 240
                    },
                    {
                        xtype: 'displayfield',
                        value: ___('PASSWORD'),
                        x: 20,
                        y: 65
                    },
                    {
                        xtype: 'textfield',
                        inputType: 'password',
                        name: 'password',
                        id: 'password',
                        listeners: {
                            specialKey: function (field, el) {
                                if (el.getKey() == Ext.EventObject.ENTER) {
                                    var button = Ext.getCmp('btnSubmit');
                                    button.focus();
                                    return false;
                                }
                            }
                        },
                        x: 20,
                        y: 85,
                        width: 240
                    },
                    {
                        xtype: 'button',
                        id: 'btnSubmit',
                        text: ___('SUBMIT'),
                        tooltip: ___('SUBMIT'),
                        x: 190,
                        y: 120,
                        width: 70,
                        height: 22,
                        handler: function () {
                            var userNameField = Ext.getCmp('userName');
                            var pwdField = Ext.getCmp('password');
                            if (userNameField === undefined || pwdField === undefined)
                                return;

                            var userName = escape(userNameField.getValue());
                            var pwd = escape(encrypt(pwdField.getValue()));

                            // Validate user name and password against AD Server or M/T password
                            var winAuthOrSamlEnabled = <%= (AuthenticationHelper.IsWindowsOrSaml2AuthEnabled() ? "-1" : "0") %> ? true : false;
                            if (!winAuthOrSamlEnabled) {
                                // Validate user credentials.
                                $.ajax({
                                    url: '/Authentication/ValidateUserNameAndPassword',
                                    data: {
                                        __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                                        userName: userName,
                                        password: pwd
                                    },
                                    type: 'post',
                                    dataType: 'json',
                                    success: function(result) {
                                        if (result.success) {
                                            callback(result.userUid);
                                        }
                                        else {
                                            Ext.Msg.alert(___('ERROR_TITLE'), result.message, function() { pwd.focus(true, 10); });
                                        }
                                    }
                                });

                            } else {
                                $.ajax({
                                    url: '/Authentication/ValidateADServerUserNameAndPassword',
                                    data: {
                                        __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                                        userName: userName,
                                        password: pwd
                                    },
                                    type: 'post',
                                    dataType: 'json',
                                    success: function(result) {
                                        if (result.success) {
                                            callback(result.userUid);
                                        } else {
                                            // handle AD connection error and to prompt the user with a valid error message 
                                            // redirect valid error message when validating the AD server 
                                            if (result.message == ___("AD_CONNECTION_ERROR_MSG")) {
                                                Ext.Msg.alert(___('ERROR_TITLE'), ___('AD_CONNECTION_ERROR_MSG'), function() { pwd.focus(true, 10); });
                                            } else {
                                                Ext.Msg.alert(___('ERROR_TITLE'), ___('INCORRECT_PASSWORD_MSG'), function() { pwd.focus(true, 10); });
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    }
                ],
                listeners: {
                    add: function () {
                        var userName = Ext.getCmp('userName');
                        // if Auditing is not active...
                        if ('<%: (SystemDefault.IsActive(SysDefHelper.AUDITING)).ToString().ToLower() %>' == 'false') {
                            // default the user name to the current user
                            if (userName !== undefined)
                                userName.setValue('<%:EmxUser.CurrentUser.cUsername%>');

                            // set focus to the password field
                            var password = Ext.getCmp('password');
                            if (password !== undefined)
                                password.focus(true, 200);
                        }
                        else {
                            if (userName !== undefined)
                                userName.focus(true, 200);
                        }
                    }
                }
            });

            win.show();
            return win;
        }

        function doShowPartialCalInfo() {
            app.openWindow({
                url: '/TagMap/ShowPartialProcedure/?nCallSheetUID=' + recordID
            });
        }

        function promptReverseTraceability(reportType) {
            var window = new Ext.Window({
                title: ___('CALLSHEET_REVERSE_TRACEABILITY_TITLE'),
                items: [
                    {
                        xtype: 'container',
                        width: 258,
                        height: 253,
                        layout: 'absolute',
                        items: [
                            {
                                xtype: 'datefield',
                                id: 'trSd',
                                x: 20,
                                y: 50,
                                width: 220
                            },
                            {
                                xtype: 'datefield',
                                x: 20,
                                y: 120,
                                id: 'trEd',
                                width: 220
                            },
                            {
                                xtype: 'displayfield',
                                value: ___('End Date'),
                                x: 20,
                                y: 100
                            },
                            {
                                xtype: 'displayfield',
                                value: ___('Start Date'),
                                x: 20,
                                y: 30
                            },
                            {
                                xtype: 'displayfield',
                                value: ___('Depth'),
                                x: 20,
                                y: 170
                            },
                            {
                                xtype: 'combo',
                                x: 20,
                                lastQuery: '',
                                forceSelection: true,
                                editable: false,
                                triggerAction: 'all',
                                value: '2',
                                y: 190,
                                id: 'trD',
                                width: 100,
                                displayField: 'val',
                                valueField: 'val',
                                mode: 'local',
                                store: new Ext.data.ArrayStore({
                                    fields: ['val'],
                                    data: [['1'], ['2'], ['3'], ['4'], ['5'], ['6'], ['7'], ['8'], ['9'], ['10'], ['11'], ['12'], ['13'], ['14'], ['15'], ['16'], ['17'], ['18'], ['19'], ['20'], ['21'], ['22'], ['23'], ['24'], ['25']]
                                }),
                                listeners: {
                                    beforequery: function (qe) {
                                        qe.query = '';
                                        delete this.lastQuery;
                                    }
                                }
                            },
                            {
                                xtype: 'button',
                                text: ___('SUBMIT'),
                                tooltip: ___('SUBMIT'),
                                x: 160,
                                y: 190,
                                height: 30,
                                width: 80,
                                handler: function () {
                                    var qs = 'nCallSheetUID=' + recordID;

                                    // Get the start date
                                    var sd = Date.parse(Ext.getCmp('trSd').getValue());
                                    var ed = Date.parse(Ext.getCmp('trEd').getValue());

                                    qs += '&start=' + sd;
                                    qs += '&end=' + ed;
                                    qs += '&depth=' + Ext.getCmp('trD').getValue();

                                    window.close();

                                // Do the trace
                                <%  var rtr = SystemDefault.GetValue(SysDefHelper.WORK_ORDER_REVERSE_TRACE_REPORT, ""); %>
                                doPrintTraceability('<%= rtr %>', qs, reportType);
                                }
                            }
                        ]
                    }
                ]
            });

            window.show();
            // Pre-populate the dates.
            var endDt = Date();
            var startDt = new Date(endDt.toString()).add(Date.MONTH, -2);
            window.items.items[0].items.items[0].setValue(startDt);
            window.items.items[0].items.items[1].setValue(endDt);
        }

        function clearSignatures(reload, callback) {
            // if there are no signatures or bypassing this prompt intentionally, abort
            if (bypassClearSignaturesPrompt || (!isSignedByQC && !isSignedByTechnician)) {
                if (callback) callback();
                return;
            }

            // when unlocking a Work Order that has only the Technician signature, do not clear the signatures 
            // unless changes are made other than adding the QC signature
            if (isUnlocked && isSignedByTechnician && !isSignedByQC && bypassClearSignaturesPrompt) {
                if (callback) callback();
                return;
            }

            var clearMe = ('<%= SystemDefault.IsActive(SysDefHelper.WORK_ORDER_CLEAR_QC_APPROVED_FIELDS) %>' == 'True');
            if (!clearMe) {
                if (callback) callback();
                return;
            }

            Ext.Msg.confirm(___('ATTENTION_TITLE'), ___('WORK_ORDER_APPROVAL_CLEAR'), function (btn) {
                if (btn == 'yes') {
                    // if a callback function was specified (used for all hot-save actions),
                    // use ajax to remove signatures and save the change, then reload the form to avoid 
                    // the user needing to click the Save button to save only the removal of the signature(s).
                    if (callback) {
                        $.ajax({
                            url: '/CallSheet/RemoveSignatures/',
                            data: {
                                __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                                nCallSheetUID: '<%: Model.nCallSheetUID %>'
                            },
                            type: 'post',
                            dataType: 'json',
                            success: function (result) {
                                if (result.success) {
                                    // bypass prompt to clear signatures in onDataDirtyChanged event handler
                                    bypassClearSignaturesPrompt = true;

                                    // remove signatures from UI
                                    removeTechnicianSignature();
                                    removeQCSignature();

                                    callback();

                                    if (reload)
                                        window.location.reload();
                                }
                                else
                                    Ext.Msg.alert(___('ERROR_TITLE'), result.message);
                            }
                        });
                    }
                    else {
                        // remove signatures and enable Save button
                        removeTechnicianSignature();
                        removeQCSignature();
                        editWindow.setDataDirty();
                    }
                }
                else {
                    if (!callback) window.location.reload();
                }
            });
        }

        var myTable = 'CallSheet';
        var recordID = '<%: Model.nCallSheetUID %>';
        var isNewRecord = <%= GuidHelper.AspxGuidHandler.IsNewRecord(Model.nCallSheetUID) %>;
        var isLocked = <%: ViewData[ "locked" ] != null ? "true" : "false" %>;
        var isMetCal = <%= (isMetCal) ? "true" : "false" %>;
        var hasProcedure = <%= GuidHelper.AspxGuidHandler.IsExistingRecord(Model.nProcedureUID) %>;
        var isUserGroup = <%: EmxUser.CurrentUser.IsMemberOfGroup("User") ? "true" : "false" %>;
        var isUnlocked = <%: Session["isUnlocked"] != null ? "true" : "false" %>;
        var isClosed = <%= Model.IsClosed ? "true" : "false" %>;
        var hasInvoice = <%= GuidHelper.AspxGuidHandler.IsExistingRecord(Model.nInvoiceUID) %>;

        if (isUnlocked == true) {
            isLocked = false;
            $.ajax({
                url: '/CallSheet/DestroyUnlockSession/',
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                },  
                type: 'post',
                dataType: 'json',
            });
        }

        function masterclose() {
            clientWindow.close();
        }

        function notImplemented() {
            Ext.Msg.alert(___('NOT_IMPLEMENTED_TITLE'), ___('NOT_IMPLEMENTED_MSG'));
        }

        function getAddress(facility, callback) {
            app.getAddress(facility, "shipping", callback, false, false);
        }

        function doPrintInvoice(reportType) {
            var invoiceUID = '<%= Model.nInvoiceUID %>';
            var reportName = '<%= SystemDefault.GetValue(SysDefHelper.BILLING) %>';
            app.getInvoiceFacilityUID(invoiceUID, 'working', function (nWorkingFacilityUID) {
                app.getInvoiceFacilityUID(invoiceUID, 'shipFrom', function (nFacilityUID) {
                    app.getInvoiceFacilityUID(invoiceUID, 'shipTo', function (nShipToUID) {
                        app.getAddress(nWorkingFacilityUID, "billing", function (address) {
                            app.getAddress(nFacilityUID, "billing", function (address2) {
                                app.getAddress(nShipToUID, "billing", function (address3) {

                                    Report.PreviewReport(reportName, [
                                        { Key: 'nInvoiceUID', Value: invoiceUID },
                                        { Key: 'Lab', Value: address },
                                        { Key: 'Owner', Value: address2 },
                                        { Key: 'ShipTo', Value: address3 }
                                    ], null, false, false, reportType);

                                }, undefined, undefined, "Ship To Address");

                            }, undefined, undefined, "Owner Address");

                        }, undefined, undefined, "Lab Address");

                    }, undefined, undefined, "Ship To Address");

                }, undefined, undefined, "Owner Address");

            }, undefined, undefined, "Lab Address");
        }

        function doPrintTraceability(reportName, qs, reportType) {
            if (reportName == '') {
                Ext.Msg.alert(___('ERROR_TITLE'), ___('CALLSHEET_CANNOT_FIND_REPORT_ERROR_MSG'));
                return;
            }

            var parameters = [];
            Report.PreviewReport(reportName, parameters, '/CallSheet/DoPrint/?' + qs + '&', true, false, reportType);
        }

        function doStickerNote() {
            var window = app.openWindow({
                url: '/CallSheet/ViewStickerNote/' + recordID + '<%= ( isUnlocked ) ? "/?isUnlocked=1" : "" %>',
                title: ___('Sticker Notes'),
                modal: true,
                callbacks: {
                    onSave: function (id) {
                        if (isUnlocked) editWindow.setDataDirty();
                    }
                }
            });
        }

        function doPrintStickerNote(reportType) {
            var reportName = '';

            // Derive the report name
            var stickerType = Ext.getCmp('cStickerType');
            if (stickerType === undefined) return;

            // define endsWith in Javascript if needed
            if (typeof String.prototype.endsWith !== 'function') {
                String.prototype.endsWith = function (suffix) {
                    return this.indexOf(suffix, this.length - suffix.length) !== -1;
                };
            }

            // If the supplied value does NOT contain .rpt
            reportName = (stickerType.getValue() || "CalSticker.rpt");
            if (!reportName.toLowerCase().trim().endsWith(".rpt")) {
                reportName += ".rpt";
            }

            if (reportName != '') {
                var parameters = [];
                parameters[parameters.length] = {
                    Key: 'nCallSheetUID',
                    Value: recordID
                };

                Report.PreviewReport(reportName, parameters, null, false, false, reportType);
            } else {
                Ext.Msg.alert(__('ERROR_TITLE'), __('CALLSHEET_CANNOT_FIND_REPORT_ERROR_MSG'));
            }
        }
        function doFT(reportType) {
	    <%  var ftReport = SystemDefault.GetValue(SysDefHelper.WORK_ORDER_FORWARD_TRACE_REPORT, "");
        if (string.IsNullOrEmpty(ftReport))
            ftReport = "ttrace.rpt"; %>
        Ext.Msg.confirm(___('ATTENTION_TITLE'), ___('CALLSHEET_DUPLICATE_BRANCHES_MSG'), function (btn) {
            var qs = 'nCallSheetUID=' + recordID + '&';
            if (btn == 'yes') {
                qs += 'checkDupes=true';
            } else {
                qs += 'checkDupes=false';
            }

            doPrintTraceability('<%= ftReport %>', qs, reportType);
        });
        }
        function doRT(reportType) {
            promptReverseTraceability(reportType);  // Report Type Pararmeter hardcoded to Print the report
        }

        function getStandards(context, nProcedureUID) {
            clearSignatures(false, function () {
                var url = '';
                if (nProcedureUID === undefined) {
                    url = '<%: Url.Content( "~/Shared/MultiFind/" ) %>';
                }
                else {
                    url = '<%: Url.Content( "~/Shared/MultiFind/" ) %>?nProcedureUID=' + nProcedureUID;
                }

                var findWindow = app.openWindow({
                    title: ___('CALLSHEET_SELECT_STANDARDS_TITLE'),
                    url: url,
                    modal: true,
                    closable: false,
                    callbacks: {
                        context: context,
                        controller: 'Asset',
                        disableAddButton: userCannotAddAssets,
                        cancel: function () {
                            findWindow.close();
                        },
                        onRecordSelected: function (a, b, c) {
                            var standards = [];

                            // Retrieve the Service Date (use 'today' if not defined)
                            var serviceDate = new Date().clearTime();
                            var maintDate = Ext.getCmp('tMaintDate');
                            var value = maintDate.getValue();
                            if (value.toString().length > 0) {
                                serviceDate = value;
                            }

                            var serviceDateString = serviceDate.toISOString(); // make sure to use UTC since the database time is UTC

                            // The modified onRecordSelected signature now sends
                            // a = record selected, b = context grid, c = multiSelectGrid
                            // So iterate through each record in the multi select grid.
                            c.getStore().each(function (item) {
                                standards[standards.length] = item.get('UID'); // adding all the standards UID to standards array
                            });

                            var assetsToAdd = [];
                            function process() {
                                $.ajax({
                                    type: 'post',
                                    url: '/CallSheet/AddStandards/',
                                    data: {
                                        __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                                        nCallSheetUID: '<%= Model.nCallSheetUID %>',
                                        nAssetUIDS: assetsToAdd.join(',') // add the standards only when the Yes button is pressed.
                                    },
                                    success: function () {
                                        var grid = Ext.getCmp('grdStandards');
                                        if (grid === undefined) return;
                                        grid.getStore().load(grid.getStore().lastOptions);
                                        if (isUnlocked)
                                            editWindow.setDataDirty();
                                        else
                                            window.location.reload();
                                    }
                                });
                            }

                            $.ajax({
                                type: 'post',
                                data: {
                                    __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                                    uids: standards.join(','),
                                    serviceDate: serviceDateString
                                },
                                url: '/CallSheet/CheckForOverdueAssets/',
                                async: false,
                                success: function (result) {

                                    var index = 0;
                                    function next() {
                                        if (index == result.length) {
                                            process();
                                        } else {
                                            var item = result[index];
                                            index++;

                                            if (!item.overdue) {
                                                assetsToAdd[assetsToAdd.length] = item.uid;
                                                next();
                                            } else {
                                                Ext.Msg.confirm(___('ATTENTION_TITLE'), item.message + ___('CALLSHEET_LIKE_TO_ADD_MSG'), function (btn) {
                                                    if (btn == "yes") {
                                                        assetsToAdd[assetsToAdd.length] = item.uid;
                                                    }

                                                    next();
                                                });
                                            }
                                        }
                                    }

                                    // Start the recursive method
                                    next();
                                }
                            });

                            findWindow.close();

                        }
                    }
                });
            });
        }

        function addStandard() {
            getStandards('FindStandards');
        }

        function addProcedureStandard() {
            var nProcedureUID = Ext.getCmp('nProcedureUID').getValue();
            if (nProcedureUID === undefined || nProcedureUID === '') {
                Ext.Msg.alert(___("ATTENTION_TITLE"), ___("WORK_ORDER_PROCEDURE_MISSING"));
            }
            else {
                var actionUrl = '<%: Url.Content( "~/Procedure/HasProcedureStandardTypes/" ) %>?id=' + nProcedureUID;

                $.ajax({
                    url: actionUrl,
                    data: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                    },
                    type: 'POST',
                    async: false,
                    dataType: 'json',
                    success: function (result) {
                        if (result.message === 'false') {
                            Ext.Msg.alert(___("ATTENTION_TITLE"), ___('SELECTED_PROCEDURE_NO_STDS'));
                            return;
                        }
                        else {
                            getStandards('FindStandards', nProcedureUID);
                            if (isLocked)
                                editWindow.setDataDirty();
                        }
                    }
                });
            }
        }

        function swapStandard() {
            var grid = Ext.getCmp('grdStandards');
            if (grid === undefined) return;

            var sm = grid.getSelectionModel();
            var record = sm.getSelected();
            if (record === undefined) return;

            clearSignatures(false, function () {
                var id = record.get('nCallSheetStandardLinkUID');
                var mainWindow = self;

                var window = app.openWindow({
                    title: ___('SWAP_STANDARD'),
                    url: '/CallSheetStandardLink/Edit/' + id,
                    modal: true,
                    callbacks: {
                        close: function () {
                            var grid = Ext.getCmp('grdStandards');
                            if (grid === undefined) return;
                            grid.getStore().load(grid.getStore().lastOptions);
                            if (!isUnlocked) mainWindow.location.reload();
                        }
                    }
                });
            });
        }

        function editStandard() {
            var grid = Ext.getCmp('grdStandards');
            if (grid === undefined) return;

            var sm = grid.getSelectionModel();
            var record = sm.getSelected();
            if (record === undefined) return;

            var id = record.json['nAssetUID'];

            var window = app.openWindow({
                url: '/Asset/Edit/' + id,
                title: ___('EDIT_ASSET')
            });

            // For unlocked Work Order, set dirty flag
            if (isUnlocked) {
                window.on("message", function (tag) {
                    if (tag === "recordchanged") {
                        editWindow.setDataDirty();
                    }
                });
            }
        }

        function removeStandard() {
            var grid = Ext.getCmp('grdStandards');
            if (grid === undefined) return;

            var sm = grid.getSelectionModel();
            var record = sm.getSelected();
            if (record === undefined) return;

            clearSignatures(false, function () {
                var id = record.get('nCallSheetStandardLinkUID');

                $.ajax({
                    url: '/CallSheet/RemoveStandard/' + id,
                    data: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                    },
                    type: 'post',
                    dataType: 'json',
                    success: function (result) {
                        if (result.success) {
                            grid.getStore().load(grid.getStore().lastOptions);
                            if (isUnlocked)
                                editWindow.setDataDirty();
                            else 
                                window.location.reload();
                        }
                        else
                            Ext.Msg.alert(___('ERROR_TITLE'), result.message);
                    }
                });
            });
        }

        function addAccreditation() {
            clearSignatures(false, function () {
                var mainWindow = self;
                var findWindow = app.openWindow({
                    title: ___('CALLSHEET_SELECT_ACCREDITATIONS_TITLE'),
                    url: '<%: Url.Content( "~/Shared/MultiFind" ) %>',
                    modal: true,
                    closable: false,
                    callbacks: {
                        context: 'FindAccreditation',
                        controller: 'Accreditation',
                        cancel: function () {
                            findWindow.close();
                        },
                        onRecordSelected: function (a, b, c) {
                            var records = 'nCallSheetUID=' + recordID;

                            // The modified onRecordSelected signature now sends
                            // a = record selected, b = context grid, c = multiSelectGrid
                            // So iterate through each record in the multi select grid.
                            c.getStore().each(function (item) {
                                records += "&nAccreditationUIDS=" + item.get('UID');
                            });

                            $.ajax({
                                url: '/CallSheet/AddAccreditations/?' + records,
                                data: {
                                    __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                                },
                                type: 'post',
                                dataType: 'json',
                                success: function (result) {
                                    var grid = Ext.getCmp('grdNist');
                                    if (grid === undefined) return;
                                    grid.getStore().load(grid.getStore().lastOptions);
                                    if (isUnlocked)
                                        editWindow.setDataDirty();
                                    else
                                        mainWindow.location.reload();
                                }
                            });

                            findWindow.close();

                        }
                    }
                });
            });
        }

        function removeAccreditation() {
            clearSignatures(false, function () {
                var grid = Ext.getCmp('grdNist');
                if (grid === undefined) return;

                var sm = grid.getSelectionModel();
                var record = sm.getSelected();
                if (record === undefined) return;

                var id = record.get('nCallSheetAccreditationLinkUID');

                $.ajax({
                    url: '/CallSheet/RemoveAccreditation/' + id,
                    data: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                    },
                    type: 'post',
                    dataType: 'json',
                    success: function (result) {
                        if (result.success) {
                            grid.getStore().load(grid.getStore().lastOptions);
                            if (isUnlocked)
                                editWindow.setDataDirty();
                            else 
                                window.location.reload();
                        }
                        else
                            Ext.Msg.alert(__('ERROR_TITLE'), result.message);
                    }
                });
            });
        }

        function editAccreditation() {
            var grid = Ext.getCmp('grdNist');
            if (grid === undefined) return;

            var sm = grid.getSelectionModel();
            var record = sm.getSelected();
            if (record === undefined) return;

            var id = record.json['nAccreditationUID'];

            var window = app.openWindow({ url: '/Accreditation/Edit/' + id, title: 'Edit Accreditation' });
            // For unlocked Work Order, set dirty flag
            if (isUnlocked) {
                window.on("message", function (tag) {
                    if (tag === "recordchanged") {
                        editWindow.setDataDirty();
                    }
                });
            }
        }


        // get the data sheet type of the current procedure or the procedure passed in.
        function getDataSheetType(proc) {

            var nTypeUID = '<%= Model.nTypeUID %>';

            if ((proc || '') === '')
                proc = Ext.getCmp('nProcedureUID').getValue();

            if (!nTypeUID) {
                Log({ message: 'There is no type for the work order "' + recordID + '"' });
                return t_datasheet.None;
            }

            if (!proc) {
                Log({ message: 'There is no procedure for the work order "' + recordID + '"' });
                return t_datasheet.None;
            }            

            // Make the HTTP request, but do it synchronously.
            var jqhr = $.ajax({
                url: '/CallSheet/GetDataSheetType',
                type: 'post',
                async: false,
                dataType: 'application/text',
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                    nTypeUID: nTypeUID,
                    nProcedureUID: proc
                }
            });

            // When we get here, jqhr has the result!
            return ((jqhr || {}).responseText) || t_datasheet.None;
        }


        // update the interface based on logic from various sources.
        function doUpdateGUI() {
            var grid = Ext.getCmp("grdCallsheetFiles");
            var dataStore = grid.getStore();
            dataStore.setBaseParam('limit', 150000);
            dataStore.reload();
            updateFileButtons();
        }

        function getResultsCount() {
            var csGrid = Ext.getCmp('grdWorkOrderResults');
            if (csGrid) {
                var csStore = csGrid.getStore();
                if (csStore) 
                    return csStore.totalLength;
            }

            return 0;
        }

        function showResultsCount() {
            var resultsTab = Ext.getCmp('panel26');
            if (resultsTab)
                resultsTab.setTitle(___('WORK_ORDER_RESULTS') + ' (' + getResultsCount() + ')');
        }


        // manage the file data sheet functionality.
        function promptFile(nProcedureUID, callback) {

            var nTypeUID = '<%= Model.nTypeUID %>';

            // use the default procdure if not passed in
            if ((nProcedureUID || '') === '')
                nProcedureUID = Ext.getCmp('nProcedureUID').getValue();

            if (nTypeUID === undefined || nProcedureUID === undefined) return;

            var window = new Ext.Window({
                layout: 'fit',
                width: 400,
                height: 225,
                resizable: false,
                minimizable: false,
                closable: true,
                plain: true,
                modal: true,
                title: ___('CALLSHEET_SELECT_DATA_SHEET_OPTION_TITLE'),

                // Define the items in the window.
                items: [
                    new Ext.FormPanel({

                        // Create a new container with a form layout.
                        layout: 'form',
                        labelAlign: 'top',
                        labelWidth: 75,
                        padding: 10,
                        defaults: {
                            width: 360
                        },
                        frame: false,

                        id: 'frmUploadStuff',
                        fileUpload: true,

                        // Define the items.
                        items: [
                            {
                                xtype: 'radiogroup',
                                columns: 1,
                                items: [
                                    {
                                        id: 'chkDownload',
                                        name: 'chkDataSheet',
                                        xtype: 'radio',
                                        boxLabel: ___('CALLSHEET_DOWNLOAD_OPEN_BLANKCOPY_DATA_SHEET_LABEL'),
                                        checked: true,
                                        handler: function () {
                                            Ext.getCmp('pnlUpload').show();
                                        }
                                    },
                                    {
                                        id: 'chkUpload',
                                        name: 'chkDataSheet',
                                        xtype: 'radio',
                                        boxLabel: ___('CALLSHEET_UPLOAD_COMPLETED_COPY_DATA_SHEET_LABEL'),
                                        checked: false,
                                        disabled: false,
                                        handler: function () {
                                            Ext.getCmp('pnlUpload').hide();
                                        }
                                    }
                                ]
                            },
                            new Ext.Container({
                                id: 'pnlUpload',
                                hidden: true,
                                items: [
                                    {
                                        html: '<input type="file" id="btnFilePicker" name="iAttributeFile" />'
                                    }
                                ]
                            })
                        ]
                    })
                ],
                bbar: new Ext.Toolbar({
                    defaults: {
                        scale: 'large'
                    },
                    items: [
                        {
                            xtype: 'button',
                            iconCls: 'tb-ok',
                            handler: function () {

                                var chkDownload = Ext.getCmp('chkDownload');
                                var chkUpload = Ext.getCmp('chkUpload');

                                if (chkDownload === undefined || chkUpload === undefined) return;

                                if (chkDownload.getValue()) {

                                    $.ajax({
                                        url: '/CallSheet/GetDataSheetFileUID',
                                        type: 'post',
                                        dataType: 'json',
                                        data: {
                                            __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                                            nTypeUID: nTypeUID,
                                            nProcedureUID: nProcedureUID
                                        },
                                        success: function (result) {
                                            if (result.success == true) {
                                                var name = '';
                                                if (Ext.getCmp('cCallSheetNumber') !== undefined)
                                                    name = Ext.getCmp('cCallSheetNumber').getValue();

                                                File.Open(result.message, name);
                                            }
                                        }
                                    });

                                    window.close();

                                    if (callback) callback();

                                } else {
                                    var uForm = Ext.getCmp('frmUploadStuff');
                                    if (uForm === undefined) return;

                                    var frmUploadStuff = uForm.getForm();
                                    if (frmUploadStuff === undefined) return;

                                    if ($.trim(($("#btnFilePicker").val() || '')) == '') {
                                        // If they have NOTHING selected, squiggle the field.
                                        Ext.Msg.alert(___("ATTENTION"), ___("INVALID_FILE_NAME_DETECTED"));
                                        return;
                                    }

                                    frmUploadStuff.submit({
                                        waitMsg: ___('CALLSHEET_ATTACHING_FILE_MSG'),
                                        waitTitle: ___('PLEASE_WAIT'),
                                        url: '/CallSheet/AttachAttributeFile',
                                        params: {
                                            __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                                            nCallSheetUID: recordID
                                        },
                                        success: function (form, action) {
                                            var json = (((action || {}).response || {}).responseText) || '';
                                            try {
                                                var obj = eval("[" + json + "]")[0];
                                                nCallSheetAttributeUID = obj.message;
                                                doUpdateGUI();
                                            } catch (ex) { }
                                            window.close();

                                            if (callback) callback();
                                        },
                                        failure: function () {
                                            Ext.Msg.alert(___("ATTENTION_TITLE", ___("A_GENERIC_ERROR_HAS_OCCURED")));
                                            window.close();

                                            if (callback) callback();
                                        }
                                    });
                                }
                            }
                        },
                        {
                            xtype: 'button',
                            iconCls: 'tb-cancel',
                            handler: function () {
                                window.close();

                                if (callback) callback();

                                return;
                            }
                        }
                    ]
                })
            });

            window.show();
        }

        function DisplayMissingDataSheetMessage(callback) {
            var sheet = '<%=L.__(UCIData.GetFieldProperty("Procedures", "nAttTemplateUID", "Label").cValue)%>';
            var msg = ___('MISSING_DATA_SHEET').replace('{0}', sheet);
            Ext.Msg.alert(___('ATTENTION_TITLE'), msg, callback);
        }

        function DisplayDataSheetMismatchMessage(callback) {
            var sheet = '<%=L.__(UCIData.GetFieldProperty("Procedures", "nAttTemplateUID", "Label").cValue)%>';
            var cat = '<%=L.__(UCIData.GetFieldProperty("Procedures", "nCategoryUID", "Label").cValue)%>';
            var msg = ___('DATA_SHEET_CATEGORY_MISMATCH').replace('{0}', sheet).replace('{1}', cat);
            Ext.Msg.alert(___('ATTENTION_TITLE'), msg, callback);
        }

        // determine what to do when the Add Result button on the Toolbar is pressed
        function doAddResult() {
            doLogFileOutput('STATUS: Calling doAddResult()');

            // Derive our information from the grid of callsheet results instead of querying the table again...
            var csGrid = Ext.getCmp('grdWorkOrderResults');
            var csStore = csGrid.getStore();
            var csrCount = csStore.getCount();

            if (csrCount > 0) {
                doLogFileOutput('STATUS: Switching to Results tab');
                var tab = Ext.getCmp("panel26");
                tab.show();
                addWorkOrderResult('As Left');
                return;
            }

            var dsType = getDataSheetType('');
            if (dsType === t_datasheet.None) {
                // no procedure selected - prompt user to select
                Log({ message: 'Data Sheet Type is none, prompting user to select' });
                addWorkOrderResultHandler();
                return;
            }

            if (dsType === t_datasheet.Mismatch) {
                Log({ message: 'Data Sheet Type is mismatch, returning' });
                DisplayDataSheetMismatchMessage();
                return;
            }

            if (dsType === t_datasheet.Error) {
                Log({ message: 'Data Sheet Type is Error, returning' });
                Ext.Msg.alert(___('ATTENTION_TITLE'), ___('ERROR_LOCATING_PROCEDURE'));
                return;
            }

            var defaultDataCondition = 'As Found';

            if (IsExistingRecord(nCallSheetAttributeUID)) {
                defaultDataCondition = 'As Left';

                // allow running same procedure again for Manual Templates and MET/CAL procedures only
                if (!(dsType === t_datasheet.METCal || dsType === t_datasheet.METTeam)) {
                    doLogFileOutput('STATUS: Switching to Results tab');
                    var tab = Ext.getCmp("panel26");
                    tab.show();
                    addWorkOrderResult(defaultDataCondition);
                    return;
                }
            }            

            var tpd = Ext.getCmp('nTypeProcedureDefaultUID');
            if (tpd === undefined) {
                Log({ message: 'Type Procedure Default is undefined, returning' });
                return;
            }

            clearSignatures(false, function () {
                switch (dsType) {
                    case t_datasheet.METCal:
                        doLogFileOutput('USING: MET/CAL Procedure');
                        doLogFileOutput('STATUS: Get User Locale');

                        // Launch MET/CAL
                        $.ajax({
                            url: '/Language/GetUserLocaleName',
                            data: {
                                __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                            },
                            type: 'post',
                            dataType: 'json',
                            success: function (result) {
                                doLogFileOutput('STATUS: Launch MET/CAL');

                                var facilityUID = '<%:EmxUser.CurrentUser.ActiveFacility%>';
                                LaunchMETCal(tpd.getValue(), result.message, getAuthCredentials(), facilityUID);
                            }
                        });
                        break;

                    case t_datasheet.METTeam:
                        doLogFileOutput('USING: Manual Template Procedure');

                        // Launch the manual template system (if we can) or the editor (if applicable).
                        LaunchManualTemplate(recordID, defaultDataCondition, tpd.getValue(), undefined, UpdateWOPassFail);
                        break;

                    case t_datasheet.METTeamLegacy:
                        doLogFileOutput('USING: Legacy Procedure');
                        // NOTE:
                        // We no longer support viewing legacy results. Instead, the user is to
                        // print an old cert report (to view the historical data).
                        Ext.Msg.alert(___('ATTENTION_TITLE'), ___('LEGACY_RESULTS_NOT_SUPPORTED'));
                        break;

                    case t_datasheet.File:
                        doLogFileOutput('USING: File-based Procedure');

                        // Launch the file action window.
                        promptFile('', function () { window.location.reload(); });
                        break;

                    default:
                        Log({ message: 'Internal Error' });

                        // This condition is basically completely impossible to get to 
                        // (except maybe if the network is yanked). Display a generic error message.
                        Ext.Msg.alert(___('ATTENTION_TITLE'), ___('GENERIC_RESULTS_NOT_SUPPORTED'));
                        break;
                }
            });
        }

        function UpdateWOPassFail(win) {

            $.ajax({
                url: '/CallSheet/GetWorkOrderResults',
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                    nCallSheetUID: recordID
                },
                type: 'post',
                dataType: 'json',
                async: false,
                success: function (result) {
                    if (result.success == true) {
                        var woResults = Ext.getCmp('cWorkOrderResults');
                        if (woResults) {
                            woResults.setValue(result.message);
                            Ext.getCmp('tbSave').handler();

                            // update Pass/Fail on WO Results record
                            var csGrid = Ext.getCmp('grdWorkOrderResults');
                            var csStore = csGrid.getStore();
                            csStore.reload();

                            // If the work order is locked, we need to automatically submit.
                            if (isUnlocked) {
                                if (win) win.close();
                                Ext.getCmp('tbSave').handler();
                            }
                        }
                    } else {
                        Ext.Msg.alert(___('ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                    }
                }
            });
        }

        function doLoadResultView(nCallSheetResultUID, callSheetNum, resDescription) {

            // it is of MET/CAL origin, so pop up the viewer grid.
            var edited = false;
            var allowEditing = !isLocked;
            // do not allow editing on Work Orders created before Check Out!
            if (allowEditing && isMobile && !createdAfterMobileCheckOut)
                allowEditing = false;

            var hasSignatures = (isSignedByQC || isSignedByTechnician);

            var win = app.openWindow({
                title: ___('CALLSHEET_VIEW_RESULTS_TITLE') + '  ' + callSheetNum + '-' + resDescription,
                url: '/CallSheetResult/LoadResultView/?nCallSheetResultUID=' + nCallSheetResultUID + '&allowEditing=' + allowEditing + '&workOrderUnlocked=' + isUnlocked + '&hasSignatures=' + hasSignatures,
                resizable: true,
                modal: true,
                maximizable: true,
                minimizable: false,
                width: 1250,
                height: 600,
                callbacks: {
                    close: function () {
                        setTimeout(function () {
                            if (isUnlocked && edited) 
                                editWindow.setDataDirty();
                            else
                                window.location.reload();
                            
                            var csGrid = Ext.getCmp('grdWorkOrderResults');
                            var csStore = csGrid.getStore();
                            csStore.reload();
                        }, 1);
                    }
                }
            });

            win.on('message', function (tag, obj) {
                if (tag === "edited" || tag === "cloned" || tag === "recorddeleted") {
                    // Using a closure here...
                    edited = true;
                }
            });
        }

        function getSelectedRecord(gridName) {

            var grid = Ext.getCmp(gridName);
            var selectionModel = grid.getSelectionModel();
            var selectedRecord = selectionModel.getSelected();

            return selectedRecord;

        }

        // This object specifies the event handlers for the Files grid
        var fileListeners = {
            render: function (grid) {
                grid.getSelectionModel().on("selectionchange", function (selModel) {
                    updateFileButtons();
                });
            },
            rowdblclick: function (grid, index, event) {
                displayFileContextMenu(grid, index, event);
            },
            rowcontextmenu: function (grid, index, event) {
                displayFileContextMenu(grid, index, event);
            }
        };

        function displayFileContextMenu(grid, index, event) {
            event.stopEvent();

            if (isLocked)
                return false;

            var sm = grid.getSelectionModel();
            var store = grid.getStore();
            var record = store.getAt(index);
            var isPrivate = +record.get("lPrivate") != 0;
            var showCurrent = +record.get("lCert") != 0;
            var isCurrent = +record.get("lCertCurrent") != 0;

            // Ensure that the row is selected, looks more consistent
            sm.selectRow(index);

            var contextMenu = null;
            if (showCurrent) {
                contextMenu = new Ext.menu.Menu({
                    items: [
                        {
                            iconCls: isPrivate ? "tb-unlocked-sm" : "tb-locked-sm",
                            text: isPrivate ? ___('MAKE_PUBLIC_TEXT') : ___('MAKE_PRIVATE_TEXT'),
                            handler: function () {
                                toggleFilePrivateFlag();
                            }
                        },
                        {
                            text: isCurrent ? ___('CLEAR_CURRENT_TEXT') : ___('SET_CURRENT_TEXT'),
                            handler: function () {
                                toggleFileCurrentCertFlag();
                            }
                        }
                    ]
                });
            }
            else {
                contextMenu = new Ext.menu.Menu({
                    items: [
                        {
                            iconCls: isPrivate ? "tb-unlocked-sm" : "tb-locked-sm",
                            text: isPrivate ? ___('MAKE_PUBLIC_TEXT') : ___('MAKE_PRIVATE_TEXT'),
                            handler: function () {
                                toggleFilePrivateFlag();
                            }
                        }
                    ]
                });
            }

            contextMenu.showAt(event.getXY());

        }

        function updateFileButtons() {

            var grid = Ext.getCmp("grdCallsheetFiles");
            var selectionModel = grid.getSelectionModel();
            var hasSelection = selectionModel.getCount() > 0;

            if (isLocked) Ext.getCmp("cmdAddLabor").setDisabled(true);

            Ext.getCmp("cmdDeleteFiles").setDisabled(!hasSelection || isLocked);
            Ext.getCmp("cmdModifyFiles").setDisabled(!hasSelection || isLocked);
            Ext.getCmp("cmdViewFiles").setDisabled(!hasSelection);

        }

        function confirmToggleFilePrivateFlag() {

            if (isLocked) return;

            var grid = Ext.getCmp("grdCallsheetFiles");
            var sm = grid.getSelectionModel();
            var store = grid.getStore();
            var record = sm.getSelected();
            var isPrivate = +record.get("lPrivate") != 0;

            var title = isPrivate ? ___('MAKE_PUBLIC_TEXT') : ___('MAKE_PRIVATE_TEXT');
            var msg = isPrivate ? ___('DO_YOU_WANT_TO_MAKE_THIS_FILE_PUBLIC') : ___('DO_YOU_WANT_TO_MAKE_THIS_FILE_PRIVATE');

            Ext.Msg.confirm(title, msg, function (btn) {

                if (btn != "yes")
                    return;

                toggleFilePrivateFlag();

            });

        }

        function toggleFilePrivateFlag() {

            if (isLocked) return;

            var grid = Ext.getCmp("grdCallsheetFiles");
            var sm = grid.getSelectionModel();
            var store = grid.getStore();
            var record = sm.getSelected();
            var isPrivate = +record.get("lPrivate") != 0;
            var id = record.get("nCallSheetFileUID");

            record.beginEdit();
            record.set("lPrivate", isPrivate ? 0 : -1);
            record.endEdit();
            store.commitChanges();

            var actionUrl = '<%: Url.Content( "~/CallSheet/MarkFilePrivate/" ) %>';
            app.call({
                url: actionUrl,
                params: {
                    FileID: id,
                    Private: !isPrivate
                },
                success: function (result) {
                },
                error: function (err) {
                    debugger;
                    Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                }
            });

        }

        function toggleFileCurrentCertFlag() {

            if (isLocked) return;

            var grid = Ext.getCmp("grdCallsheetFiles");
            var sm = grid.getSelectionModel();
            var store = grid.getStore();
            var record = sm.getSelected();
            var isCurrent = +record.get("lCertCurrent") != 0;
            var id = record.get("nCallSheetFileUID");
            var isExport = record.get("lCertExport");

            var actionUrl = '<%: Url.Content( "~/CallSheet/MarkFileCurrentCert/" ) %>';
        app.call({
            url: actionUrl,
            params: {
                FileID: id,
                CallsheetUID: '<%: Model.nCallSheetUID %>',
                Current: !isCurrent,
            },
            success: function (result) {
                store.each(function (item) {
                    var itemId = item.get("nCallSheetFileUID");
                    var isItemCurrent = item.get("lCertCurrent");
                    var isItemExport = item.get("lCertExport");

                    if (itemId == id) {
                        item.beginEdit();
                        item.set("lCertCurrent", isCurrent ? 0 : -1);
                        item.endEdit();
                    }
                    else if (isItemExport == isExport && isItemCurrent != 0) {
                        item.beginEdit();
                        item.set("lCertCurrent", 0);
                        item.endEdit();
                    }
                });
                store.commitChanges();
                setCertButtonMenu();
            },
            error: function (err) {
                debugger;
                Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
            }
        });

        }

        function attachFile(id) {

            if (isLocked)
                return;

            var grid = Ext.getCmp("grdCallsheetFiles");
            var dataStore = grid.getStore();

            $.ajax({
                url: '/File/Retrieve/' + id,
                type: 'post',
                dataType: 'json',
                success: function(result) {
                    
                    var fileName = result.cFileName.toUpperCase();
                    var callSheetNum = Ext.getCmp('cCallSheetNumber').getValue().toUpperCase();
                    var mergeFileName = callSheetNum + '_MERGE.PDF';

                    // check if the file being attached matches the certificate "merge" file schema
                    if (fileName === mergeFileName) {
                        // check for an existing file by this name
                        var existingFileIndex = dataStore.find('cFileName', mergeFileName);
                        if (existingFileIndex >= 0) {
                            Ext.Msg.confirm(___('ALERT_TITLE'), ___('OVERWRITE_MERGE_FILE_MSG'), function(btn) {

                                if (btn != "yes")
                                    return;

                                // delete the existing "merge" file and attach the new one
                                var existingFile = dataStore.getAt(existingFileIndex);
                                if (existingFile !== undefined) {
                                    grid.getSelectionModel().selectRow(existingFileIndex);

                                    deleteFileFromCallSheet(existingFile.data.nCallSheetFileUID,
                                        function() {
                                            attachFileToCallSheet(grid, dataStore, id);
                                        });
                                } else 
                                    Ext.Msg.alert(__('ERROR_TITLE'), __('UNABLE_TO_DELETE_EXISTING_RECORD_MSG'));
                                
                                return;
                            });

                        } else 
                            attachFileToCallSheet(grid, dataStore, id);

                    } else 
                        attachFileToCallSheet(grid, dataStore, id);

                }
            });
        }

        function attachFileToCallSheet(grid, dataStore, id) {

            var selectionModel = grid.getSelectionModel();

            var actionUrl = '<%: Url.Content( "~/CallSheet/AttachFile/" ) %>';
            app.call({
                url: actionUrl,
                contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                    CallSheetID: '<%: Model.nCallSheetUID %>',
                    FileID: id
                },
                success: function (result) {
                    dataStore.setBaseParam('limit', 150000);
                    dataStore.reload({
                        callback: function () {
                            var recordIndex = dataStore.find("nFileUID", id);
                            if (recordIndex >= 0) {
                                setTimeout(function () {
                                    selectionModel.selectRow(recordIndex);
                                }, 1);
                            }
                        }
                    });
                    updateFileButtons();
                    if (reloadWindow) {
                        reloadWindow = false;
                        if (!isUnlocked) window.location.reload();
                    }
                },
                error: function (err) {
                    debugger;
                    Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                }
            });

        }

        // upload a new file into the Files table and links it to the Work Order
        function uploadFile() {

            if (isLocked)
                return;

            clearSignatures(false, function () {
                var mainWindow = self;

                var dialog = app.openWindow({
                    title: ___('FILES'),
                    url: '<%: Url.Content( "~/File/Create/" ) %>?Type=Work Order',
                    modal: true,
                    width: 385,
                    height: 240,
                    callbacks: {
                        onClose: function () {
                            dialog.close();
                            if (!isUnlocked) mainWindow.location.reload();
                        },
                        onSave: function (recordID) {
                            var id = recordID;
                            dialog.close();
                            reloadWindow = true;
                            attachFile(id);
                            if (isUnlocked)
                                editWindow.setDataDirty();
                            else
                                editWindow.location.reload();
                        },
                    }
                });
            });
        }

        // add a file to a Work Order from the Files table
        function addFile() {

            if (isLocked)
                return;

            clearSignatures(false, function () {
                var findWindow = app.openWindow({
                    title: ___('FIND_FILE_TITLE'),
                    url: '<%: Url.Content( "~/Shared/Find/" ) %>?Type=Work Order',
                    modal: true,
                    callbacks: {
                        context: 'FindFiles',
                        controller: 'File',
                        persistFindScreenOnAdd: 'true',
                        cancel: function () {
                            findWindow.close();
                        },
                        onRecordSelected: function (record) {
                            var id = record.get("UID");
                            findWindow.close();
                            reloadWindow = true;
                            attachFile(id);
                            if (isUnlocked)
                                editWindow.setDataDirty();
                        }
                    }
                });
            });
        }

        function doFindProcedure() {
            var nTypeUID = '<%= Model.nTypeUID %>';

            var findWindow = app.openWindow({
                title: ___('FIND_PROCEDURE_TITLE'),
                url: "<%: Url.Content( "~/Shared/Find/" ) %>?cCallSheetType=<%= Model.cCallSheetType %>" + '&nTypeUID=' + nTypeUID + "&customWhereSession=" + 'AssociatedAssets',    //auto-execute find via associated asset param (borrowed from types)
                modal: true,
                callbacks: {
                    context: 'FindTypeProcedure',
                    controller: 'Procedure',
                    persistFindScreenOnAdd: 'true',
                    onRecordSelected: function (record) {

                        // Grab the necessary information from our resources.
                        var nTypeProcedureDefaultUID = record.get("UID");

                        $.ajax({
                            url: '/TypeProcedureDefault/Retrieve/' + nTypeProcedureDefaultUID,
                            type: 'post',
                            dataType: 'json',
                            success: function (tpdResult) {

                                var nProcedureUID = tpdResult.nProcedureUID;

                                // Snag the record data proper.
                                $.ajax({
                                    url: '/Procedure/Retrieve/' + nProcedureUID,
                                    data: {
                                        __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                                    },  
                                    type: 'post',
                                    dataType: 'json',
                                    success: function (result) {
                                        var procName = result.cProcedureName;
                                        var procField = Ext.getCmp('nProcedureUID');
                                        var procDisplayField = Ext.getCmp('nProcedureUID_display');

                                        // Set the values for the procedure lookup.
                                        procField.setValue(nProcedureUID);
                                        procDisplayField.setValue(procName);
                                        Ext.getCmp("nProcedureUID_edit").setDisabled(false); // To enable Quick link button after look up values gets selected

                                        // Get a reference to the type procedure default field.
                                        var tpdValField = Ext.getCmp('nTypeProcedureDefaultUID');

                                        // Set the type procedure default UID to the selected id from the find screen.
                                        tpdValField.setValue(nTypeProcedureDefaultUID);

                                        editWindow.setDataDirty();
                                    }
                                });

                            }
                        });

                        findWindow.close();
                    }
                }
            });
        }

        function viewFile() {

            var grid = Ext.getCmp("grdCallsheetFiles");
            if (grid === undefined) return;

            var record = getSelectedRecord("grdCallsheetFiles");
            if (record === undefined) return;

            var id = record.get("nFileUID");
            if (id === undefined) return;

            var isActive = record.get("lActive");
            if (isActive === undefined)
                isActive = '0';

            if (isActive == '0') {
                Ext.Msg.alert(___("ERROR_TITLE"), ___('SELECT_FILE_NOT_ACTIVE'))
                return;
            }

            File.Open(id);
        }

        function deleteFile() {

            if (isLocked)
                return;

                var record = getSelectedRecord("grdCallsheetFiles");
                var id = record.get("nCallSheetFileUID");

                Ext.Msg.confirm(___('DELETE_RECORD_TITLE'), ___('REMOVE_FILE_MSG'), function (btn) {

                    if (btn != "yes")
                        return;

                    clearSignatures(true, function () {
                        deleteFileFromCallSheet(id);
                    });
                });
        }

        function deleteFileFromCallSheet(callSheetFileId, callback) {

            var grid = Ext.getCmp("grdCallsheetFiles");
            var record = getSelectedRecord("grdCallsheetFiles");

            var actionUrl = '<%: Url.Content( "~/CallSheet/RemoveFile/" ) %>';
            app.call({
                url: actionUrl,
                contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                    CallSheetID: '<%: Model.nCallSheetUID %>',
                    CallSheetFileID: callSheetFileId
                },
                success: function(result) {
                    grid.getStore().remove(record);
                    updateFileButtons();
                    if (isUnlocked)
                        editWindow.setDataDirty();

                    // invoke callback function if defined
                    if (callback !== undefined)
                        callback();

                    if (!isUnlocked) window.location.reload();
                },
                error: function(err) {
                    debugger;
                    Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                }
            });
        }

        function modifyFile() {

            var grid = Ext.getCmp("grdCallsheetFiles");
            var selectionModel = grid.getSelectionModel();
            var record = selectionModel.getSelected();
            var id = record.get("nFileUID");

            var window = app.openWindow({
                title: ___('FILES'),
                url: '<%= Url.Content( "~/File/Edit/" ) %>' + id,
            width: 515,
            height: 330,
            modal: true,
            maximizable: false,
            minimizable: false,
            callbacks: {
                isLocked: isLocked,
            }
        });

            window.on("message", function (tag) {
                if (tag === "recordchanged") {
                    var store = grid.getStore();
                    // If the record was changed, refresh the grid.
                    store.load(store.lastOptions);

                    if (isUnlocked)
                        editWindow.setDataDirty();
                }
            });
        }

        // This object specifies the event handlers for the Labors grid
        var laborListeners = {
            render: function (grid) {
                grid.getSelectionModel().on("selectionchange", function (selModel) {
                    updateLaborButtons();
                });
            },
            rowdblclick: function (grid, index, event) {
                if (Ext.getCmp("cmdModifyLabor").disabled)
                    return;

                showDirtyWarning(modifyLabor);
            }
        };

        function updateLaborButtons() {

            var grid = Ext.getCmp("grdHours");
            var selectionModel = grid.getSelectionModel();
            var hasSelection = selectionModel.getCount() > 0;

            if (isLocked) Ext.getCmp("cmdAddLabor").setDisabled(true);

            Ext.getCmp("cmdDeleteLabor").setDisabled(!hasSelection || isLocked);
            Ext.getCmp("cmdModifyLabor").setDisabled(!hasSelection);

        }

        function addLabor() {

            if (isLocked) return;

            clearSignatures(false, function () {
                var grid = Ext.getCmp("grdHours");
                var dataStore = grid.getStore();
                var selectionModel = grid.getSelectionModel();

                var dialog = app.openWindow({
                    title: ___('LABOR'),
                    url: '<%= Url.Content( "~/Labor/Create/" ) %>?CallSheetID=<%= Model.nCallSheetUID %>' + '&isUnlockedFlag=' + isUnlocked,
                    width: 245,
                    height: 355,
                    modal: true,
                    maximizable: false,
                    minimizable: false,
                    callbacks: {
                        onSave: function (id) {
                            var grid = Ext.getCmp("grdHours");
                            dataStore.reload({
                                callback: function () {
                                    var recordIndex = dataStore.find("nLaborUID", id);
                                    if (recordIndex >= 0) {
                                        setTimeout(function () {
                                            selectionModel.selectRow(recordIndex);
                                        }, 1);
                                        if (isUnlocked)
                                            editWindow.setDataDirty();
                                        else
                                            window.location.reload();
                                    }
                                }
                            });
                        }
                    }
                });
            });
        }

        function deleteLabor() {

            if (isLocked) return;

            var grid = Ext.getCmp("grdHours");
            var record = getSelectedRecord("grdHours");
            var id = record.get("nLaborUID");

            Ext.Msg.confirm(___('DELETE_RECORD_TITLE'), ___('CALLSHEET_REMOVE_RECORD_MSG'), function (btn) {

                if (btn != "yes")
                    return;

                clearSignatures(false, function () {
                    var actionUrl = '<%: Url.Content( "~/Labor/Delete/" ) %>';
                    app.call({
                        url: actionUrl,
                        params: { id: id },
                        success: function (result) {
                            grid.getStore().remove(record);
                            updateLaborButtons();
                            if (isUnlocked)
                                editWindow.setDataDirty();
                            else
                                window.location.reload();
                        },
                        error: function (err) {
                            debugger;
                            Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                        }
                    });

                });
            });
        }

        function modifyLabor() {
            clearSignatures(false, function () {
                var grid = Ext.getCmp("grdHours");
                var selectionModel = grid.getSelectionModel();
                var record = selectionModel.getSelected();
                var id = record.json['nLaborUID'];
                var mainWindow = self;

                var window = app.openWindow({
                    title: ___('EDIT_LABOR_TITLE'),
                    url: '<%= Url.Content( "~/Labor/Edit/" ) %>' + id + '?isUnlockedFlag=' + isUnlocked,
                    width: 245,
                    height: 355,
                    modal: true,
                    maximizable: false,
                    minimizable: false,
                    callbacks: {
                        isLocked: isLocked
                    }
                });

                window.on("message", function (tag) {
                    if (tag === "recordchanged") {
                        var store = grid.getStore();
                        // If the record was changed, refresh the grid.
                        store.load(store.lastOptions);
                        if (isUnlocked)
                            editWindow.setDataDirty();
                        else
                            mainWindow.location.reload();
                    }
                });
            });
        }

        // This object specifies the event handlers for the Parts grid
        var partsListeners = {
            render: function (grid) {
                grid.getSelectionModel().on("selectionchange", function (selModel) {
                    updatePartButtons();
                });
            },
            rowdblclick: function (grid, index, event) {
                if (Ext.getCmp("cmdModifyPartLink").disabled)
                    return;

                showDirtyWarning(editPartLink);
            }
        };

        function updatePartButtons() {

            var grid = Ext.getCmp("grdParts");
            var selectionModel = grid.getSelectionModel();
            var hasSelection = selectionModel.getCount() > 0;

            if (isLocked) Ext.getCmp("cmdAddPart").setDisabled(true);

            Ext.getCmp("cmdDeletePart").setDisabled(!hasSelection || isLocked);
            Ext.getCmp("cmdModifyPart").setDisabled(!hasSelection);
            Ext.getCmp("cmdModifyPartLink").setDisabled(!hasSelection);

        }

        function addPart() {

            if (isLocked) return;

            clearSignatures(false, function () {
                var grid = Ext.getCmp("grdParts");
                var dataStore = grid.getStore();
                var selectionModel = grid.getSelectionModel();
                var mainWindow = self;

                var createPartLink = function (partID) {

                    var dialog = app.openWindow({
                        title: ___('PARTS'),
                        url: '<%= Url.Content( "~/CallSheetPartsLink/Create/" ) %>?CallSheetID=<%= Model.nCallSheetUID %>&PartID=' + partID + '&isUnlockedFlag=' + isUnlocked,
                        width: 310,
                        height: 410,
                        modal: true,
                        closable: false,
                        callbacks: {
                            cancel: function () {
                                dialog.close();
                            },
                            onSave: function (id) {
                                var grid = Ext.getCmp("grdParts");
                                dataStore.reload({
                                    callback: function () {
                                        var recordIndex = dataStore.find("nCallSheetPartLinkUID", id);
                                        if (recordIndex >= 0) {
                                            setTimeout(function () {
                                                selectionModel.selectRow(recordIndex);
                                            }, 1);
                                            if (isUnlocked)
                                                editWindow.setDataDirty();
                                            else 
                                                mainWindow.location.reload();
                                        }
                                    }
                                });
                            }
                        }
                    });

                }

                var findWindow = app.openWindow({
                    title: ___('FIND_PART'),
                    url: '<%: Url.Content( "~/Shared/Find/" ) %>?doWOPartsSearch=1&WorkLab=' + Ext.getCmp('nWorkingFacilityUID').getValue() + '&AdminLab=' + Ext.getCmp('nOwningLabUID').getValue(),
                    modal: true,
                    closable: false,
                    callbacks: {
                        cancel: function () {
                            findWindow.close();
                        },
                        onRecordSelected: function (record) {
                            var id = record.get("UID");
                            findWindow.close();
                            createPartLink(id);
                        },
                        context: "FindProcedureParts",
                        controller: "Part"
                    }
                });
            });
        }

        function modifyPart() {
            var grid = Ext.getCmp("grdParts");
            var selectionModel = grid.getSelectionModel();
            var record = selectionModel.getSelected();
            var id = record.json['nPartUID'];

            var window = app.openWindow({
                title: ___('EDIT_PART'),
                url: '<%= Url.Content( "~/Part/Edit/" ) %>' + id,
                callbacks: {
                    isLocked: isLocked
                }
            });

            if (isUnlocked) {
                window.on("message", function (tag) {
                    if (tag === "recordchanged") {
                        editWindow.setDataDirty();
                    }
                });
            }
        }

        function editPartLink() {
            clearSignatures(false, function () {
                var grid = Ext.getCmp("grdParts");
                var selectionModel = grid.getSelectionModel();
                var record = selectionModel.getSelected();
                var id = record.json['nCallSheetPartLinkUID'];
                var selectedRow = grid.getSelectionModel().last;
                var mainWindow = self;

                app.openWindow({
                    title: ___('PARTS'),
                    url: '<%= Url.Content( "~/CallSheetPartsLink/Edit/" ) %>' + id + '?isUnlockedFlag=' + isUnlocked,
                    width: 310,
                    height: 410,
                    modal: true,
                    closable: false,
                    callbacks: {
                        isLocked: isLocked,
                        cancel: function () {
                            mainWindow.location.reload();
                        },
                        onClose: function () {
                            mainWindow.location.reload();
                        },
                        onSave: function (id) {
                            grid.getStore().reload({
                                callback: function () {
                                    setTimeout(function () {
                                        selectionModel.selectRow(selectedRow);
                                    }, 1);
                                }
                            });
                            if (isUnlocked)
                                editWindow.setDataDirty();
                            else 
                                mainWindow.location.reload();
                        }
                    }
                });
            });
        }

        function deletePart() {

            if (isLocked) return;

                var grid = Ext.getCmp("grdParts");
                var record = getSelectedRecord("grdParts");
                var id = record.get("nCallSheetPartLinkUID");

                Ext.Msg.confirm(___('DELETE_RECORD_TITLE'), ___('CALLSHEET_WISH_TO_REMOVE_THIS_PART_MSG1') + "<br/>" + ___('CALLSHEET_WISH_TO_REMOVE_THIS_PART_MSG2'), function (btn) {

                    if (btn != "yes")
                        return;

                    clearSignatures(false, function () {
                        var actionUrl = '<%: Url.Content( "~/CallSheetPartsLink/Delete/" ) %>' + '?isUnlockedFlag=' + isUnlocked;
                        app.call({
                            url: actionUrl,
                            params: { id: id },
                            success: function (result) {
                                Ext.Msg.alert(___('SUCCESS'), ___('CALLSHEET_PART_REMOVED_MSG'));
                                grid.getStore().remove(record);
                                updatePartButtons();

                                if (isUnlocked)
                                    editWindow.setDataDirty();
                                else 
                                    window.location.reload();
                            },
                            error: function (err) {
                                debugger;
                                Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                            }
                        });
                    });
                });
        }

        // This object specifies the event handlers for the Work Order results grid
        var grdWorkOrderResultsListeners = {
            render: function (grid) {
                grid.getSelectionModel().on("selectionchange", function (selModel) {
                    updateWorkOrderResultsButtons();
                });

                grid.getStore().on("load", function () {
                    updateWorkOrderResultsButtons();
                });
            },
            rowdblclick: function (grid, index, event) {
                var btn = Ext.getCmp("cmdViewWorkOrderResult");
                if (btn === undefined) return;
                if (btn.disabled) return;
                viewWorkOrderResult();
            }
        };

        var canEdit = function (selectionModel) {
            var record = selectionModel.getSelected();
            if (record === undefined) return false;

            if (record.get('nCallSheetResultUID') === undefined) {
                return false;
            }
            var origin = record.get('cDataOrigin');
            return (origin === "MET/TEAM");
        }

        function updateWorkOrderResultsButtons() {
            var grid = Ext.getCmp("grdWorkOrderResults");
            var selectionModel = grid.getSelectionModel();
            var hasSelection = selectionModel.getCount() > 0;
            var dirty = editWindow.getDataDirty();

            //The buttons are disabled always until all the handlers are completed.
            Ext.getCmp("cmdDeleteWorkOrderResult").setDisabled(dirty || !hasSelection || isLocked || (isMobile && !createdAfterMobileCheckOut));
            Ext.getCmp('cmdModifyWorkOrderResult').setDisabled(dirty || !canEdit(selectionModel) || isLocked || (isMobile && !createdAfterMobileCheckOut));
            Ext.getCmp("cmdAddWorkOrderResult").setDisabled(dirty || ('<%:addResultsDisabled%>' == 'True'));
            Ext.getCmp("cmdViewWorkOrderResult").setDisabled(dirty || !hasSelection);
            Ext.getCmp("cmdExternalImport").setDisabled(dirty || isLocked);

            showResultsCount();

            // Update the interface. This function is generally good to call whenever
            doUpdateGUI();
        }

        function getProcedureUID(nTypeProcedureDefaultUID) {
            var jqhr = $.ajax({
                url: '/TypeProcedureDefault/GetProcedureUID',
                type: 'post',
                dataType: 'json',
                async: false,
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                    nTypeProcedureDefaultUID: nTypeProcedureDefaultUID
                }
            });

            var obj = eval('[' + ((jqhr || {}).responseText) + ']');
            if (obj === undefined) return -1;
            if (obj.length === undefined) return -1;
            if (obj.length <= 0) return -1;
            if (obj[0].success === false) return -1;

            return obj[0].message;
        }

        // assemble authentication command line arguments to pass to MET/CAL
        function getAuthCredentials() {
            var winAuthOrSamlEnabled = <%= (AuthenticationHelper.IsWindowsOrSaml2AuthEnabled() ? "-1" : "0") %> ? true : false;

            if (!winAuthOrSamlEnabled) {
                var authCreds = '<%: Encryption.UrlEncode(Convert.ToBase64String(Encoding.UTF8.GetBytes(Encryption.Encrypt( EmxUser.CurrentUser.cUsername + "|" + EmxUser.CurrentUser.GetPasswordHash(), "metteamAuthentication")))) %>'
                return " -l \"auth=" + authCreds + "\"";
            }
            return "";
        }

        function addWorkOrderResultHandler() {
            var cnt = getResultsCount();

            if (cnt > 0)
                addWorkOrderResult('As Left');
            else
                addWorkOrderResult('As Found');
        }

        function addWorkOrderResult(manualCalibrationDataCondition) {
            doLogFileOutput('STATUS: Calling addWorkOrderResult()');

            // First, present the procedure selection find.
            // Parameter to send.
            var nTypeUID = '<%= Model.nTypeUID %>';
            if (nTypeUID === undefined) {
                Log({ message: 'Type is undefined, returning' });
                return;
            }

            // create the function that will process a type procedure default.
            function processTpd(nTypeProcedureDefaultUID, datacondition) {

                if (nTypeProcedureDefaultUID === undefined || nTypeProcedureDefaultUID === null || IsNewRecord(nTypeProcedureDefaultUID)) {
                    Log({ message: 'Type Procedure Default is undefined, returning' });
                    Ext.Msg.alert(___("ATTENTION_TITLE"), ___("WORK_ORDER_PROCEDURE_MISSING"));
                    return;
                }

                // determine what type of procedure was selected
                var nProcedureUID = getProcedureUID(nTypeProcedureDefaultUID);
                var dsType = getDataSheetType(nProcedureUID);
                switch (dsType) {
                    case t_datasheet.METCal:
                        doLogFileOutput('USING: MET/CAL Procedure');
                        doLogFileOutput('STATUS: Get User Locale');

                        // Launch MET/CAL
                        $.ajax({
                            url: '/Language/GetUserLocaleName',
                            data: {
                                __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                            },
                            type: 'post',
                            dataType: 'json',
                            success: function (result) {
                                doLogFileOutput('STATUS: Launch MET/CAL');

                                var facilityUID = '<%:EmxUser.CurrentUser.ActiveFacility%>';
                                    LaunchMETCal(nTypeProcedureDefaultUID, result.message, getAuthCredentials(), facilityUID);
                                    if (isUnlocked)
                                        editWindow.setDataDirty();
                                    else 
                                        window.location.reload();
                                }
                            });
                        break;

                    case t_datasheet.METTeam:
                        doLogFileOutput('USING: Manual Template Procedure');

                        LaunchManualTemplate(recordID, manualCalibrationDataCondition, nTypeProcedureDefaultUID, undefined, UpdateWOPassFail);

                        if (isUnlocked)
                            editWindow.setDataDirty();
                        else 
                            window.location.reload();
                        break;

                    case t_datasheet.File:
                        doLogFileOutput('USING: File Based Procedure');
                        promptFile(nProcedureUID, function () { window.location.reload(); });
                        break;

                    case t_datasheet.None:
                        doLogFileOutput('Data Sheet Type is none, returning');
                        DisplayMissingDataSheetMessage(function () { window.location.reload(); });
                        break;

                    case t_datasheet.Mismatch:
                        doLogFileOutput('Data Sheet Type is mismatch, returning');
                        DisplayDataSheetMismatchMessage(function () { window.location.reload(); });
                        break;

                    case t_datasheet.Error:
                        doLogFileOutput('Data Sheet Type is error, returning');
                        Ext.Msg.alert(___('ATTENTION_TITLE'), ___('ERROR_LOCATING_PROCEDURE'), function() { window.location.reload(); });
                        break;

                    default:
                        doLogFileOutput('Internal error');

                        // This condition is basically completely impossible to get to 
                        // (except maybe if the network is yanked). Display a generic error message.
                        Ext.Msg.alert(___('ATTENTION_TITLE'), ___('GENERIC_RESULTS_NOT_SUPPORTED'), function () { window.location.reload(); });
                        break;
                }
            }

            clearSignatures(false, function () {
                // React based on the system default.
		        <% if (SystemDefault.IsActive(SysDefHelper.WORK_ORDER_USE_MULTIPLE_PROCEDURES))
                { %>

                    var findWindow = app.openWindow({
                        title: ___('FIND_PROCEDURE_TITLE'),
                        url: "<%: Url.Content( "~/Shared/Find/" ) %>?cCallSheetType=<%= Model.cCallSheetType %>" + '&nTypeUID=' + nTypeUID + "&customWhereSession=" + 'AssociatedAssets',    //auto-execute find via associated asset param (borrowed from types)
                        modal: true,
                        callbacks: {
                            context: 'FindTypeProcedure',
                            controller: 'Procedure',
                            persistFindScreenOnAdd: 'true',
                            onRecordSelected: function (record) {

                                // Grab the necessary information from our resources.
                                var nTypeProcedureDefaultUID = record.get("UID");

                                processTpd(nTypeProcedureDefaultUID, manualCalibrationDataCondition);

                                findWindow.close();
                            },
                            cancel: function () {
                                findWindow.close();
                                window.location.reload();
                            }
                        }
                    });

    	        <% }
                else
                { %>

                    // Just use the type procedure default 
                    var tpd = Ext.getCmp('nTypeProcedureDefaultUID');

                    if (tpd === undefined) return;

                    processTpd(tpd.getValue(), manualCalibrationDataCondition);

                <% } %>
            });
        }

        function viewWorkOrderResult() {
            var grid = Ext.getCmp("grdWorkOrderResults");
            if (grid === undefined) return;

            var selectionModel = grid.getSelectionModel();
            var record = selectionModel.getSelected();
            if (record === undefined) return;

            if (Ext.getCmp('cCallSheetNumber') !== undefined)
                var callSheetNum = Ext.getCmp('cCallSheetNumber').getValue();

            var resDescription = record.data["cDescription"];

            var uid = record.get('nCallSheetResultUID');
            doLoadResultView(uid, callSheetNum, resDescription);
        }

        function VerifyImportDataDirectorySet() {

            // check if the Import - Data Directory is valid.
            var jqXHR = $.ajax({
                url: '/Import/VerifyImportDataDirectorySet',
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                },  
                dataType: 'json',
                type: 'POST',
                async: false,
                success: function (result) {
                    if (!result.success) {
                        Ext.Msg.confirm(___('ATTENTION_TITLE'), ___('SYSTEM_DEFAULT_INVALID_DATA_DIRECTORY'),
                            function (btn) {
                                if (btn == "yes") {
                                    // launch System Default find screen
                                    var findWindow = app.openWindow({
                                        title: ___('FIND_SYSTEM_DEFAULTS'),
                                        url: '<%: Url.Content( "~/Shared/Find/" ) %>',
                                modal: true,
                                callbacks: {
                                    context: "FindSystemDefaults",
                                    controller: "SystemDefault",
                                    onRecordSelected: function (record) {
                                        var id = record.get("UID");
                                        app.openWindow({
                                            url: '<%=Url.Content( "~/SystemDefault/Edit" ) %>?id=' + id,
                                            width: 555,
                                            height: 410
                                        });
                                        findWindow.close();
                                    }
                                }
                            });
                            }
                        });
                }
            }
        });

            var result = JSON.parse(jqXHR.responseText);
            return result.success;
        }

        function ExportResults(currentOnly) {

            // set separator before exporting
            $.ajax({
                url: '<%: Url.Content( "~/CallSheetResult/SetCurrentSeparator/" ) %>?separator=' + browserDecimalSeparator(),
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                },  
                type: 'post',
                success: function (result) {
                    DoExportResults(currentOnly);
                }
            });
        }

        function DoExportResults(currentOnly) {
            var id = null;
            if (currentOnly) {
                var record = getSelectedRecord("grdWorkOrderResults");
                id = record.get("nCallSheetResultUID");
            }

            promptForTimeZoneIdAndReadings(function (timeZoneId, readings) {
                var progress = Ext.Msg.wait(___('PROCESSING_RECORDS_MSG') + "...", ___('ATTENTION_TITLE'));
                $.ajax({
                    url: '/Grid/ExportResults',
                    type: 'POST',
                    dataType: 'json',
                    async: true,
                    data: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                        nCallSheetUID: recordID,
                        timeZoneId: timeZoneId,
                        includeReadings: readings,
                        nCallSheetResultUID: id
                    },
                    success: function (result) {
                        progress.hide();
                        if (result.success) {
                            window.location = result.message;
                        } else {
                            Ext.Msg.alert(___("ERROR_TITLE"), ___("FAILED_TO_GENERATE_CSV_FILE"));
                        }
                    }
                });
            });
        }

        function promptForTimeZoneIdAndReadings(callback) {
            var win = new Ext.Window({
                modal: true,
                width: 300,
                height: 180,
                layout: 'absolute',
                resizable: false,
                title: (___('EXPORT_RESULTS')),
                items: [
                    {
                        xtype: 'checkbox',
                        id: 'includeReadings',
                        boxLabel: ___('INCLUDE_POINT_READINGS'),
                        checked: 'true',
                        x: 20,
                        y: 20
                    },
                    {
                        xtype: 'displayfield',
                        value: ___('TIMEZONE'),
                        x: 20,
                        y: 50
                    },
                    {
                        xtype: 'combo',
                        id: 'timeZones',
                        x: 20,
                        y: 70,
                        forceSelection: true,
                        editable: false,
                        allowBlank: false,
                        autoLoad: false,
                        triggerAction: 'all',
                        width: 240,
                        displayField: 'DisplayName',
                        valueField: 'Id',
                        mode: 'remote',
                        store: new Ext.data.XmlStore({
                            id: 'tzStore',
                            url: '/Grid/GetSystemTimeZoneIds',
                            record: 'TimeZone',
                            fields: ['DisplayName', 'Id']
                        }),
                        listeners: {
                            afterrender: function (self) {
                                var tz = Ext.getCmp('timeZones');
                                var store = tz.getStore();
                                store.load({
                                    callback: function (r) {
                                        var tz = Ext.getCmp('timeZones');
                                        tz.setValue(r[0].get('Id'));
                                    }
                                });
                            },
                            specialKey: function (field, el) {
                                if (el.getKey() == Ext.EventObject.ENTER) {
                                    var button = Ext.getCmp('btnSelect');
                                    button.focus();
                                    return false;
                                }
                            }
                        }
                    },
                    {
                        xtype: 'button',
                        id: 'btnSelect',
                        text: ___('SUBMIT'),
                        tooltip: ___('SUBMIT'),
                        x: 190,
                        y: 100,
                        width: 70,
                        height: 22,
                        handler: function () {
                            var tz = Ext.getCmp('timeZones').getValue();
                            var readings = Ext.getCmp('includeReadings').getValue();
                            win.close();
                            callback(tz, readings);
                        }
                    }
                ],
                listeners: {
                    add: function () {
                        var tz = Ext.getCmp('timeZones');
                        if (tz !== undefined)
                            tz.focus(true, 200);
                    }
                }
            });

            win.show();
            return win;
        }

        // import COMPASS data file
        function CompassImport() {
            clearSignatures(true, function () {
                DoCompassImport(UpdateWOPassFail);
            });
        }

        function DoCompassImport(callback) {
            if (VerifyImportDataDirectorySet()) {
                var win = app.openWindow({
                    title: ___('COMPASS_IMPORT'),
                    width: 470,
                    height: 360,
                    url: '<%= Url.Content( "/CompassImport/CompassImport?nCallSheetUID=" + Model.nCallSheetUID + "&utcOffsetInHours=" + (DateTime.UtcNow - DateTime.Now).TotalHours) %>',
                    modal: true,
                    callbacks: {
                        close: function () {
                            // reload standards grid
                            var std = Ext.getCmp('grdStandards');
                            if (std !== undefined) {
                                var st = std.getStore();
                                if (st !== undefined) {
                                    st.reload(st.lastOptions);
                                }
                            }
                            var grid = Ext.getCmp('grdWorkOrderResults');
                            if (grid !== undefined) {
                                var store = grid.getStore();
                                if (store !== undefined) {
                                    store.reload(store.lastOptions);
                                }

                                // Try to call the callback
                                if (callback !== undefined) {
                                    try {
                                        callback.prototype.constructor.call(this);
                                    } catch (exception) { }
                                }
                            }
                            if (isUnlocked)
                                editWindow.setDataDirty();
                        }
                    }
                });
            }
        }

        function METTEMPIIImport() {
            clearSignatures(true, function () {
                DoMETTEMPIIImport(UpdateWOPassFail);
            });
        }

        function DoMETTEMPIIImport(callback) {
            if (VerifyImportDataDirectorySet()) {
                var win = app.openWindow({
                    title: ___('METTEMPII_IMPORT'),
                    width: 470,
                    height: 360,
                    url: '<%= Url.Content( "/METTEMPIIImport/METTEMPIIImport?nCallSheetUID=" + Model.nCallSheetUID + "&utcOffsetInHours=" + (DateTime.UtcNow - DateTime.Now).TotalHours) %>',
                modal: true,
                callbacks: {
                    close: function () {
                        // reload standards grid
                        var std = Ext.getCmp('grdStandards');
                        if (std !== undefined) {
                            var st = std.getStore();
                            if (st !== undefined) {
                                st.reload(st.lastOptions);
                            }
                        }
                        var grid = Ext.getCmp('grdWorkOrderResults');
                        if (grid !== undefined) {
                            var store = grid.getStore();
                            if (store !== undefined) {
                                store.reload(store.lastOptions);
                            }

                            // Try to call the callback
                            if (callback !== undefined) {
                                try {
                                    callback.prototype.constructor.call(this);
                                } catch (exception) { }
                            }
                        }
                        if (isUnlocked)
                            editWindow.setDataDirty();
                    }
                }
            });
            }
        }

        function CubytImport() {
            clearSignatures(true, function () {
                DoCubytImport(UpdateWOPassFail);
            });
        }

        function DoCubytImport(callback) {
            if (VerifyImportDataDirectorySet()) {
                var win = app.openWindow({
                    title: ___('CUBYT_IMPORT'),
                    width: 470,
                    height: 360,
                    url: '<%= Url.Content( "/CubytImport/CubytImport?nCallSheetUID=" + Model.nCallSheetUID + "&utcOffsetInHours=" + (DateTime.UtcNow - DateTime.Now).TotalHours) %>',
                    modal: true,
                    callbacks: {
                        close: function () {
                            // reload standards grid
                            var std = Ext.getCmp('grdStandards');
                            if (std !== undefined) {
                                var st = std.getStore();
                                if (st !== undefined) {
                                    st.reload(st.lastOptions);
                                }
                            }
                            var grid = Ext.getCmp('grdWorkOrderResults');
                            if (grid !== undefined) {
                                var store = grid.getStore();
                                if (store !== undefined) {
                                    store.reload(store.lastOptions);
                                }

                                // Try to call the callback
                                if (callback !== undefined) {
                                    try {
                                        callback.prototype.constructor.call(this);
                                    } catch (exception) { }
                                }
                            }
                            if (isUnlocked)
                                editWindow.setDataDirty();
                        }
                    }
                });
            }
        }

        function modifyWorkOrderResult() {
            var grid = Ext.getCmp('grdWorkOrderResults');
            if (grid === undefined) return;

            var sm = grid.getSelectionModel();
            var record = sm.getSelected();
            if (record === undefined) return;

            // validate call sheet results record UID
            if (record.get('nCallSheetResultUID') === undefined) {

                Ext.Msg.alert(___("ATTENTION_TITLE"), ___("A_GENERIC_ERROR_HAS_OCCURED"));
                return;

            }
            var origin = record.get('cDataOrigin');
            if (origin === "MET/TEAM") {
                clearSignatures(true, function () {
                    // If the callsheet result is a Manual Template row, launch the manual template editor.
                    // If we're good, then launch the points editor.
                    LaunchManualTemplate(recordID, '', undefined, record.get('nCallSheetResultUID'), UpdateWOPassFail);
                    if (isUnlocked)
                        editWindow.setDataDirty();

                    return;
                });
            } else if (origin === "MET/CAL") {
                // If it came from MET/CAL, cannot edit results yet
                notImplemented()
            } else {
                // Error Case. This should never happen unless data has been fat-fingered into the database.
                Ext.Msg.alert(___("ATTENTION_TITLE"), ___("A_GENERIC_ERROR_HAS_OCCURED"));
                return;
            }
        }

        function deleteWorkOrderResult() {
            if (isLocked) return;

            var grid = Ext.getCmp("grdWorkOrderResults");
            var record = getSelectedRecord("grdWorkOrderResults");
            var id = record.get("nCallSheetResultUID");

            Ext.Msg.confirm(___('DELETE_RECORD_TITLE'), ___('REMOVE_WORK_ORDER_RESULT_WARNING_MSG'), function (btn) {

                if (btn != "yes")
                    return;

                clearSignatures(false, function () {
                    app.showBusyStatus(___('DELETING_WORK_ORDER_RESULT'), true);
                    var msg = Ext.MessageBox.wait(___('DELETING_WORK_ORDER_RESULT'), ___('PLEASE_WAIT'));

                    var actionUrl = '<%: Url.Content( "~/CallSheetResult/DeleteWithDependents/" ) %>' + '?isUnlockedFlag=' + isUnlocked;
                    app.call({
                        url: actionUrl,
                        params: { id: id },
                        success: function (result) {
                            Ext.Msg.alert(___('SUCCESS'), ___('WORK_ORDER_RESULT_REMOVED_MSG'));
                            grid.getStore().remove(record);
                            updateWorkOrderResultsButtons();

                            UpdateWOPassFail();

                            // update standards used grid
                            var grid1 = Ext.getCmp('grdStandards');
                            if (grid1 !== undefined) {
                                grid1.getStore().load(grid1.getStore().lastOptions);
                            }

                            if (isUnlocked)
                                editWindow.setDataDirty();
                            else
                                window.location.reload();
                        },
                        error: function (err) {
                            debugger;
                            Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'), function () { window.location.reload(); });
                        }
                    });
                });
            });
        }

        // This object specifies the event handlers for the Log Notes grid
        var logNotesListeners = {
            render: function (grid) {
                grid.getSelectionModel().on("selectionchange", function (selModel) {
                    updateLogNoteButtons();
                });
            },
            rowdblclick: function (grid, index, event) {

                if (Ext.getCmp("cmdEditLogNotes").disabled)
                    return;

                editLogNote();
            }
        };

        function updateLogNoteButtons() {

            var grid = Ext.getCmp("grdLogNotes");
            var selectionModel = grid.getSelectionModel();
            var hasSelection = selectionModel.getCount() > 0;

            if (isLocked) Ext.getCmp("cmdAddLogNotes").setDisabled(true);

            Ext.getCmp("cmdDeleteLogNotes").setDisabled(!hasSelection || isLocked);
            Ext.getCmp("cmdEditLogNotes").setDisabled(!hasSelection);

        }

        function addLogNote() {

            if (isLocked) return;

            var grid = Ext.getCmp("grdLogNotes");
            var dataStore = grid.getStore();
            var selectionModel = grid.getSelectionModel();

            var dialog = app.openWindow({
                title: ___('CALLSHEET_ADD_LOG_NOTE_TITLE'),
                url: '<%= Url.Content( "~/CallSheetLog/Create/" ) %>?CallSheetID=<%= Model.nCallSheetUID %>' + '&isUnlockedFlag=' + isUnlocked,
            width: 335,
            height: 380,
            modal: true,
            callbacks: {
                onSave: function (id) {
                    var grid = Ext.getCmp("grdLogNotes");
                    dataStore.reload({
                        callback: function () {
                            var recordIndex = dataStore.find("nCallSheetLogUID", id);
                            if (recordIndex >= 0) {
                                setTimeout(function () {
                                    selectionModel.selectRow(recordIndex);
                                    updateStatus(selectionModel.getSelected());
                                }, 1);
                            }
                        }
                    });
                }
            }
        });
        }

        function updateStatus(record) {
            var cStatus = Ext.getCmp("cCallSheetStatus").getValue();
            if (cStatus != record.data.cStatus) {
                Ext.getCmp("cCallSheetStatus").setValue(record.data.cStatus);

                changingStatus = true;
                if (!nonStatusChangeMade)
                    statusChangedOnly = true;
                
                editWindow.setDataDirty();

                changingStatus = false;
            }
        }

        function editLogNote() {
            var grid = Ext.getCmp("grdLogNotes");
            var selectionModel = grid.getSelectionModel();
            var record = selectionModel.getSelected();
            var id = record.json['nCallSheetLogUID'];
            var selectedRow = grid.getSelectionModel().last;

            app.openWindow({
                title: ___('CALLSHEET_EDIT_LOG_NOTE_TITLE'),
                url: '<%= Url.Content( "~/CallSheetLog/Edit/" ) %>' + id + '?isUnlockedFlag=' + isUnlocked,
            width: 335,
            height: 380,
            modal: true,
            callbacks: {
                isLocked: isLocked,
                onSave: function (id) {
                    grid.getStore().reload({
                        callback: function () {
                            setTimeout(function () {
                                selectionModel.selectRow(selectedRow);
                                if (isUnlocked) editWindow.setDataDirty();
                            }, 1);
                        }
                    });
                    if (isUnlocked)
                        editWindow.setDataDirty();
                }
            }
        });

        }

        function deleteLogNote() {

            if (isLocked) return;

            if (isUnlocked) {
                Ext.Msg.alert(___("ATTENTION"), ___("CANT_DELETE_LOG_NOTES"));
                return;
            }

            var grid = Ext.getCmp("grdLogNotes");
            var record = getSelectedRecord("grdLogNotes");
            var id = record.data.nCallSheetLogUID;

            Ext.Msg.confirm(___('DELETE_RECORD_TITLE'), ___('DELETE_RECORD_MSG'), function (btn) {

                if (btn != "yes")
                    return;

                var actionUrl = '<%: Url.Content( "~/CallSheetLog/Delete/" ) %>' + '?isUnlockedFlag=' + isUnlocked;
            app.call({
                url: actionUrl,
                params: { id: id },
                success: function (result) {
                    Ext.Msg.alert(___('SUCCESS'), ___('CALLSHEET_LOG_NOTE_DELETED_TITLE'));
                    grid.getStore().remove(record);
                    updateLogNoteButtons();
                    if (isUnlocked)
                        editWindow.setDataDirty();
                },
                error: function (err) {
                    debugger;
                    Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                }
            });

        });

        }

        function selectCategory() {

            if (this.disabled || isLocked)
                return;

            var valueField = Ext.getCmp("nCategoryUID");
            var displayField = Ext.getCmp("nCategoryUID_display");
            var findWindow = app.openWindow({
                title: ___('SELECT_CATEGORY_TITLE') + ' (' + ___('WORKORDER_ABREVIATION') + ')',
                url: '<%: Url.Content( "~/Category/Select" ) %>',
            width: 500,
            height: 350,
            layout: 'fit',
            callbacks: {
                getCategoryType: function () { return 'CallSheets' },
                onRecordSelected: function (record) {
                    var id = record.id;
                    var text = record.data["cDescription"];
                    valueField.setValue(id);
                    displayField.setValue(text);

                    findWindow.close();
                    editWindow.setDataDirty();

                    var subcategoryUID = Ext.getCmp("nSubCategoryUID");
                    var SubCategoryDisplay = Ext.getCmp("nSubCategoryUID_display"); //variables for subcategory comp.
                    if (subcategoryUID != null && SubCategoryDisplay != undefined) {
                        subcategoryUID.setValue("");
                        SubCategoryDisplay.setValue("");
                    }

                }
            }
        });

        }

        function selectSubCategory() {

            if (this.disabled || isLocked)
                return;

            var valueField = Ext.getCmp("nCategoryUID");
            var categoryID = valueField.getValue();
            if (!categoryID) {
                top.Ext.Msg.alert(___('CATEGORY_NOT_SELECTED_TITLE'), ___('CALLSHEET_CATEGORY_NOT_SELECTED_MSG'));
                return;
            }

            valueField = Ext.getCmp("nSubCategoryUID");
            var displayField = Ext.getCmp("nSubCategoryUID_display");
            var findWindow = app.openWindow({
                title: ___('SELECT_SUBCATEGORY_TITLE') + ' (' + ___('WORKORDER_ABREVIATION') + ')',
                url: '<%: Url.Content( "~/SubCategory/Select" ) %>',
            width: 500,
            height: 350,
            layout: 'fit',
            callbacks: {
                getCategory: function () { return categoryID; },
                onRecordSelected: function (record) {
                    var id = record.id;
                    var text = record.data["cDescription"];
                    valueField.setValue(id);
                    displayField.setValue(text);

                    findWindow.close();
                    editWindow.setDataDirty();
                }
            }
        });

        }

        // prevent user from entering a negative number and paste negative number
        var PreventNegativeListener = {
            keypress: function (form, e) {
                var code = e.getKey();
                if (code == 109 || code == 189 || code == 45) {
                    e.stopEvent();
                }
            },
            keydown: function (form, evt) {
                var keyCode = evt.getKey();
                if ((evt.ctrlKey) && (keyCode == 86)) {
                    evt.stopEvent();
                }
            }
        }

        function setCertButtonMenu() {
            var certPrintIsDisabled = false;
            var certExportIsDisabled = false;

            var actionUrl = '<%: Url.Content( "~/CallSheet/ReadCurrentCertStatus/" ) %>';
        app.call({
            url: actionUrl,
            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
            data: {
                __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                CallsheetUID: '<%= Model.nCallSheetUID %>'
            },
            success: function (result) {
                if (result.success) {
                    if (result.exportCert || result.printCert) {
                        if (!result.exportCert) {
                            certExportIsDisabled = true;
                        }

                        if (!result.printCert) {
                            certPrintIsDisabled = true;
                        }
                    }

                    Ext.getCmp("tbCert").menu.items.each(function (item) {
                        if (item.id == "print")
                            item.setDisabled(certPrintIsDisabled);

                        if (item.id == "export")
                            item.setDisabled(certExportIsDisabled);
                    });
                }
                else {
                    Ext.Msg.alert(___('ERROR'), result.message);
                }
            },
            error: function (err) {
                debugger;
                Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
            }
        });
        }

        // called automatically whenever the DataDirty state changes
        function onDataDirtyChanged() {
            var unLockFlag = false;

            if (!changingStatus) {
                nonStatusChangeMade = true;
                statusChangedOnly = false;
            }

            // for Mobile, only allow unlocking Work Orders created after Check Out!
            if (isMobile) {
                unLockFlag = (createdAfterMobileCheckOut && isLocked)
            }
            else {
                if (isLocked) {
                    unLockFlag = true;
                }
            }

            // Removed the "User" group stipulation. The framework handles
            // group-based security by default.
            Ext.getCmp("btnUnlock").setDisabled(!unLockFlag);

            if (isLocked) return;

            var dirty = editWindow.getDataDirty();

            if (dirty && !statusChangedOnly)
                clearSignatures(false);

            Ext.getCmp('btnPrintSticker').setDisabled(dirty || isNewRecord);

            Ext.getCmp("tbSave").setDisabled(!dirty);
            Ext.getCmp("tbCancel").setDisabled(!dirty);

            Ext.getCmp("tbPrint").setDisabled(dirty || isNewRecord);
            Ext.getCmp("tbBarcode").setDisabled(dirty || isNewRecord);
            Ext.getCmp("tbCert").setDisabled(dirty || isNewRecord);

            Ext.getCmp("tbBatch").setDisabled(dirty || isNewRecord || isMetCal || isClosed);
            Ext.getCmp("tbAddResult").setDisabled(dirty || ('<%:addResultsDisabled%>' == 'True'));

            updateWorkOrderResultsButtons();
            
            if (dirty || isNewRecord) {
                Ext.getCmp("tbReturn").setDisabled(true);
            }
            else {
                if ('<%= (System.Web.HttpUtility.JavaScriptStringEncode(Model.cCallSheetStatus ?? "")).ToLower() %>' === "complete")
                    Ext.getCmp("tbReturn").setDisabled(false);
                else
                    Ext.getCmp("tbReturn").setDisabled(true);
            }
            Ext.getCmp("tbDelete").setDisabled(dirty || isNewRecord || isMetCal || (isMobile && !createdAfterMobileCheckOut));
            Ext.getCmp("tbFind").setDisabled(dirty || isMetCal);

            // Clear Sub Category when the Category is cleared.
            var CategoryFieldValue = Ext.getCmp("nCategoryUID").getValue();

            if (!CategoryFieldValue) {
                if (Ext.getCmp("nSubCategoryUID") != null)
                    Ext.getCmp("nSubCategoryUID").setValue("");

                // if sub category field is not visible this comes back as undefined
                if (Ext.getCmp("nSubCategoryUID_display") != undefined)
                    Ext.getCmp("nSubCategoryUID_display").setValue("");
            }

            doUpdateGUI();

        }

        // block the user from selecting the "Closed" item from status combo list if its already exist
        var statusListener = {
            select: function (item) {
                if (item.value == ___('Closed')) // verify against all the the languages
                {
                    Ext.getCmp("cCallSheetStatus").setValue('<%: Model.cCallSheetStatus %>');
                    Ext.Msg.alert(___('ATTENTION_TITLE'), ___('CANNOT_USE_CLOSED_STATUS'));
                }
            },
            // set the dirty flag when Work Order Status changes
            change: function () {
                changingStatus = true;

                if (!nonStatusChangeMade)
                    statusChangedOnly = true;

                editWindow.setDataDirty();

                changingStatus = false;
            }
        };

        function editAssociatedAsset() {
            app.openWindow({
                title: ___('EDIT_ASSET'),
                url: '<%: Url.Content( "~/Asset/Edit" ) %>/' + '<%: Model.nAssetUID %>',
            width: 895,
            height: 535
        })
        }

        function editAssociatedType() {
            app.openWindow({
                title: ___('EDIT_TYPE'),
                url: '<%: Url.Content( "~/Type/Edit" ) %>/' + '<%: Model.nTypeUID %>',
                width: 895,
                height: 535
            })
        }

        function cancelEdit() {
            var message = ___('ARE_YOU_SURE_WANT_TO_DISCARD_CHANGES_MSG');
            if (isClosed) {
                message = ___('ARE_YOU_SURE_WANT_TO_DISCARD_CHANGES_MSG_WITH_NOTE');
            }

            Ext.Msg.confirm(___('RELOAD_DATA'), message, function (btn) {
                if (btn == "yes") {
                    window.location.reload();
                }
            });
        }

        function deleteRecord() {

            if (isLocked) return;

            // if the user bypasses security by pressing the button before it gets disabled, block it here
            if ('<%:EmxUser.CurrentUser.HasAccess("/Callsheet/Edit/","tbDelete")%>' == 'False')
            return;

        Ext.Msg.confirm(___('DELETE_RECORD_TITLE'), ___('DELETE_RECORD_MSG'), function (btn) {

            if (btn != "yes")
                return;

            var msg = Ext.MessageBox.wait(___('PLEASE_WAIT'), ___('ATTENTION'));
            var actionUrl = '<%: Url.Content( "~/CallSheet/Delete/" ) %>';
            app.call({
                url: actionUrl,
                params: { id: '<%= Model.nCallSheetUID %>' },
                success: function (result) {
                    msg.hide();
                    app.showBusyStatus(result.message, true);

                    // Check if there were problems deleting the record
                    if (!result.success) {
                        // Pop up a message with the results.
                        Ext.Msg.alert(___('ATTENTION_TITLE'), result.message, function () { });
                    } else {
                        clientWindow.close()
                    };
                },
                error: function (err) {
                    msg.hide();
                }
            });

        });

        }

        function doFind() {
            var findWindow = app.openWindow({
                title: ___('FIND_WORK_ORDER'),
                url: '<%: Url.Content( "~/Shared/Find" ) %>',
            modal: true,
            callbacks: {
                context: "FindCallsheet",
                controller: "Callsheet",
                disableAddButton: "true",
                onRecordSelected: function (record) {
                    var id = record.get('UID');
                    window.location = '<%: Url.Content( "~/CallSheet/Edit" ) %>/' + id;
                    findWindow.close();
                }
            }
        });
        }

        function doPrintPackingSlip(reportType) {
	    <% 
        string packingReportName = SystemDefault.GetOrderedList(SysDefHelper.RETURNING).FirstOrDefault();
        %>
        var reportName = '<%= packingReportName ?? "" %>';
        var parameters = [];

        if (reportName !== '') {
            $.ajax({
                url: '/CallSheet/RetrievePackingSlipInfo/' + recordID,
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                },  
                type: 'post',
                dataType: 'json',
                success: function (result) {
                    if (result.success) {
                        app.getAddress('<%= EmxUser.CurrentUser.ActiveFacility.ToString() %>', "shipping", function (address) {
                            parameters[parameters.length] = {
                                Key: "ReturnGroup",
                                Value: result.group
                            };

                            parameters[parameters.length] = {
                                Key: "Lab",
                                Value: address
                            };

                            Report.PreviewReport(reportName, parameters, null, false, false, reportType);
                        }, undefined, undefined, "Lab Address");

                    } else {
                        Ext.Msg.alert(___('ATTENTION_TITLE'), result.message);
                    }
                }
            });
            } else {
                Ext.Msg.alert("Attention", "The system default 'Returning' is not configured properly. Cannot print report.");
            }
        }

        function doCertPrint(reportType) {
            // If the report type is "Print", the buttons default handler may be calling this function. We need to verify the Print menu option
            // is enabled. If it isn't then we need to "default" to "Export". You should never see both Print and the Export menu option disabled at the same time.
            if (reportType.toLowerCase() == "print") {
                Ext.getCmp("tbCert").menu.items.each(function (item) {
                    if (item.id == "print" && item.disabled)
                        reportType = "Export";
                });
            }

            // Go find out if there is a PDF/XLS set to current cert. If so, we open (download) that file. If there isn't a report type set to current cert
            // then print the current actual data. 
            var actionUrl = '<%: Url.Content( "~/CallSheet/ReadCurrentCertFile/" ) %>';
        app.call({
            url: actionUrl,
            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
            data: {
                __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                CallsheetUID: '<%= Model.nCallSheetUID %>',
                reportType: reportType
            },
            success: function (result) {
                if (result.success) {
                    if (result.fileId == null) {
                        doCert(reportType);
                    }
                    else {
                        File.Open(result.fileId);
                    }
                }
                else {
                    Ext.Msg.alert(___('ERROR_TITLE'), result.message);
                }
            },
            error: function (err) {
                debugger;
                Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
            }
        });
        }

        function doPrint(reportType) {
            var reportName = '<%= SystemDefault.GetValue(SysDefHelper.WORK_ORDER_REPORT, SysDefHelper.WORK_ORDER_REPORT_DEFAULT_VALUE) %>';
            if (reportName !== '') {
                var parameters = [];

                var nWorkingFacility = Ext.getCmp('nWorkingFacilityUID');
                var nFacility = Ext.getCmp('nFacilityUID');

                app.getAddress(nWorkingFacility.getValue(), "shipping", function (address) {
                    app.getAddress(nFacility.getValue(), "shipping", function (address2) {

                        parameters[parameters.length] = {
                            Key: 'Lab',
                            Value: address
                        };

                        parameters[parameters.length] = {
                            Key: 'Owner',
                            Value: address2
                        };

                        parameters[parameters.length] = {
                            Key: 'WebReport',
                            Value: 0
                        };

                        parameters[parameters.length] = {
                            Key: 'nCallSheetUID',
                            Value: recordID
                        };

                        // Execute the report preview.
                        Report.PreviewReport(reportName, parameters, null, false, false, reportType);
                    }, undefined, undefined, "Owner Report");
                }, undefined, undefined, "Lab Report");
            } else {
                Ext.Msg.alert("Error", "Cannot resolve the report name.");
            }
        }

        function doUnlock() {
            // if the user bypasses security by pressing the button before it gets disabled, block it here
            if ('<%:EmxUser.CurrentUser.HasAccess("/Callsheet/Edit/","btnUnlock")%>' == 'False')
                return;

            doLogFileOutput(`WorkOrder: Unlocking Work Order ID=${recordID}`);

            var msg = Ext.MessageBox.wait(___('UNLOCKING_WORKORDER_RECORD'), ___('ATTENTION_TITLE'));

            $.ajax({
                url: '/CallSheet/Unlock/' + recordID,
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                },  
                type: 'post',
                dataType: 'json',
                success: function (result) {
                    if (result.success) {
                        doLogFileOutput(`WorkOrder: Unlock Successful`);
                        window.location.assign(window.location);
                    } else {
                        doLogFileOutput(`WorkOrder: Unlock NOT Successful: Message:${result.message}`);
                        msg.hide();
                        Ext.Msg.alert(___('ERROR'), result.message);
                    }
                }
            });
        }

        function doBarcode() {
            var reportName = '<%= SystemDefault.GetValue(SysDefHelper.BARCODE_REPORT, SysDefHelper.BARCODE_REPORT_DEFAULT_VALUE) %>';

            if (reportName !== '') {
                var parameters = [];
                parameters[parameters.length] = {
                    Key: 'nAssetUID',
                    Value: '<%: Model.nAssetUID %>'
                };
                Report.PreviewReport(reportName, parameters, null, false, false);
            } else {
                Ext.Msg.alert("Error", "Cannot resolve the report name.");
            }
        }

        function browserDecimalSeparator() {
            var n = 1.1;
            var num = Ext.util.Format.number(n);
            var s = num.toString().substring(1, 2);
            return s;
        }

        function doCert(reportType) { // print and export report for Cert button in MET/Team work order screen. 
            $.ajax({
                url: '<%: Url.Content( "~/CallSheetResult/SetCurrentSeparator/" ) %>?separator=' + browserDecimalSeparator(),
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                },  
                type: 'post',
                success: function (result) {
                    doCertRun(reportType);
                }
            });
        }

        function doCertRun(reportType) { // print and export report for Cert button in MET/Team work order screen. 
            // Grab the report name from the cert textbox.
            var reportLabel = Ext.getCmp('lbl_cCertFormat').text;
            var reportName = Ext.getCmp('cCertFormat').getValue();

            if (reportName == '' || reportName == ' ' || reportName === undefined) {
                var msgTxt = (___('CALLSHEET_ERROR_MSG')).replace("{0}", reportLabel);
                Ext.Msg.alert(___('ERROR_TITLE'), msgTxt);
                return;
            }

            var parameters = [];
            parameters[parameters.length] = {
                Key: 'nCallSheetUID',
                Value: '<%: Model.nCallSheetUID %>'
            };
            parameters[parameters.length] = {
                Key: 'WebReport',
                Value: 0
            };
            app.getAddress(Ext.getCmp('nWorkingFacilityUID').getValue(), "shipping", function (address) {

                parameters[parameters.length] = {
                    Key: 'Lab',
                    Value: address
                };

                app.getAddress(Ext.getCmp('nFacilityUID').getValue(), "shipping", function (address) {
                    parameters[parameters.length] = {
                        Key: 'Owner',
                        Value: address
                    };

                    // For certs - use the certificate number as the output filename
                    var certName = Ext.getCmp('cCertificationNumber').getValue();
                    if (certName === undefined || certName.trim().length === 0)
                        certName = Ext.getCmp('cCallSheetNumber').getValue();
                    // Once the default parameters are added, preview the report.
                    Report.PreviewReport(reportName, parameters, null, false, false, reportType, null, certName); // print and export report for Cert button in MET/TEAM work order screen.
                }, undefined, undefined, "Owner Address");
            }, undefined, undefined, "Lab Address");
        }

        function doReturn() {
            Ext.Msg.confirm(___('ATTENTION_TITLE'), "<%= (EmxUser.CurrentUser.IsRemoteInstance()) ? L.__("CALLSHEET_NAVIGATE_TO_RETURNING_MSG") : L.__("CALLSHEET_NAVIGATE_RETURNING_MET_TEAM") %>", function (btn) {
            if (btn !== "yes") return;

            $.ajax({
                url: '/Returning/CreateReturningWorkOrderStore',
                type: 'POST',
                async: false,
                dataType: 'json'
            });

            $.ajax({
                url: '/Returning/AddReturningWorkOrder/',
                type: 'POST',
                async: false,
                dataType: 'json',
                data:
                {
                    nCallSheetUID: recordID,
                },
            });

            app.openWindow({
                title: ___('RETURNING'),
                url: '/Returning/Edit?1=1'
            });

	        <% if (!EmxUser.CurrentUser.IsRemoteInstance())
        { %>

            clientWindow.close();

	        <% } %>

        });
        }

        function doBatch() {
            var procedureUID = Ext.getCmp('nProcedureUID').getRawValue();
            var procedureName = Ext.getCmp('lbl_nProcedureUID').text;

            if (procedureUID === undefined || procedureUID == '') {
                Ext.Msg.alert(___('ERROR_TITLE'), ___('CALLSHEET_SELECT_PROCEDURE_WARNING_MSG'));
                return;
            }

            var findWindow = app.openWindow({
                title: (___('CALLSHEET_FIND_WORK_ORDER_WITH_MATCHING_TITLE')).replace("{0}", procedureName),
                url: '<%: Url.Content( "~/Shared/MultiFind/" ) %>?nCallSheetUID=' + recordID + "&nProcedureUID=" + procedureUID,
            modal: true,
            callbacks: {
                // Use the specified find context and set the controller to a certain object.
                context: 'FindCallSheetBatch',
                controller: 'CallSheet',
                // Overwrite the onRecordSelected function...
                onRecordSelected: function (a, b, c) {
                    // When a record from the multi select grid is chosen...
                    // Create a QueryString representing the selected values.
                    $.ajax({
                        url: '/CallSheet/CreateBatchWorkOrders',
                        type: 'POST',
                        async: false,
                        dataType: 'json'
                    });

                    // The modified onRecordSelected signature now sends
                    // a = record selected, b = context grid, c = multiSelectGrid
                    // So iterate through each record in the multi select grid.
                    c.getStore().each(function (item) {
                        $.ajax({
                            url: '/CallSheet/AddBatchWorkOrder',
                            type: 'POST',
                            async: false,
                            dataType: 'json',
                            data:
                            {
                                nCallSheetUID: item.get('UID'),
                            },
                        });
                    });

                    app.openWindow({
                        url: '/CallSheet/Batch/?1=1&masterUID=' + recordID,
                        modal: false,
                        title: ___('CALLSHEET_BATCH_PROCESS_WORKORDER_MSG'),
                        // reload the Work Order screen to display updated "cCertificationNumber"
                        callbacks: {
                            close: function () {
                                window.location.reload();
                            }
                        }
                    });
                    findWindow.close();
                }
            }
        });
        }

        function doFindJobNumber() {
            var nFacilityUID = Ext.getCmp('nFacilityUID').getValue();

            var valueField = Ext.getCmp("nJobNumberUID");
            var displayField = Ext.getCmp("nJobNumberUID_display");

            var findWindow = app.openWindow({
                title: ___('SELECT_JOB_NUMBER_TITLE'),
                url: '<%: Url.Content( "~/Shared/Find/" ) %>?nWFacilityUID=<%= EmxUser.CurrentUser.ActiveFacility %>&nFacilityUID=' + nFacilityUID,
            callbacks: {
                context: 'FindFacilityJobNumber',
                controller: 'JobNumber',
                persistFindScreenOnAdd: 'true',
                onRecordSelected: function (record) {
                    var id = record.get('UID');
                    var text = record.get('cJobOrderNumber');

                    valueField.setValue(id);
                    displayField.setValue(text);
                    Ext.getCmp("nJobNumberUID").setDisabled(false); // enable Quick link button after look up values gets selected


                    findWindow.close();
                    editWindow.setDataDirty();
                }
            }
        });

        }

        // Autofill QC Approved Date field when QC Approved By signature is added
        var tQCApprovedDateListener = {
            focus: function () {
	        <% if (!isLocked)
            { %>
                updateApprovedDate('tQCApprovedDate', new Date());
                editWindow.setDataDirty();
            <% } %>
            },
            change: function () {
                editWindow.setDataDirty();
            }
        };

        function updateApprovedDate(field, date) {
            var approvedDate = Ext.getCmp(field);
            if (approvedDate.getValue() != date)    // avoid triggering change tracking when not necessary
                approvedDate.setValue(date);

            // ensure the date is formatted appropriately for the current locale
            const currentLocale = navigator.language;
            var options = {
                year: 'numeric',
                month: '2-digit',
                day: '2-digit',
            };

            if (currentLocale.indexOf('zh') >= 0) {
                options = {
                    year: 'numeric',
                    month: 'long',  //force date separators to match the rest of the UI
                    day: '2-digit',
                };
            }
            const formatter = new Intl.DateTimeFormat(currentLocale, options);
            const dateTimeString = formatter.format(date) + ' ' + date.toLocaleTimeString();

            if (field.startsWith('tQC')) {
                qcSignatureDateTimeStamp = dateTimeString;
            }
            else {
                technicianSignatureDateTimeStamp = dateTimeString;
            }
        }

        // Autofill Technician Approved Date field when Technician Approved By signature is added
        var tTechnicianApprovedDateListener = {
            focus: function () {
	            <% if (!isLocked)
                { %>
                updateApprovedDate('tTechnicianApprovedDate', new Date());
                editWindow.setDataDirty();
                <% } %>
            },
            change: function () {
                editWindow.setDataDirty();
            }
        };

        var serviceDateListener = {
            focus: function () {
	        <% if (!isLocked)
        { %>
            var self = Ext.getCmp('tMaintDate');
            if (self.getValue().toString().length > 0) return;

            var d = new Date();
            self.setValue(d);
            editWindow.setDataDirty();
	        <% } %>
            },
            change: function () {
                editWindow.setDataDirty();
            }
        };

        var dueDateListener = {
            focus: function () {
	        <% if (!isLocked)
        { %>
            var facility = Ext.getCmp('nFacilityUID');
            var nextDate = Ext.getCmp('tMaintNextDate');
            var maintDate = Ext.getCmp('tMaintDate');
            var interval = Ext.getCmp('cInterval');
            var uom = Ext.getCmp('cIntervalUOM');

            if (nextDate.getValue().toString().length > 0) return;
            if (maintDate.disabled) return;
            if (maintDate === undefined || interval === undefined || uom === undefined) return;
            if (maintDate.getValue().toString().length == 0) return;

            // essentially sets the time component of the maintenance date
            // which allows us to properly derive the correct date.
            var today = new Date();
            today.setFullYear(maintDate.getValue().getFullYear(), maintDate.getValue().getMonth(), maintDate.getValue().getDate());
            // in javascript, the getTimezoneOffset() works opposite the C# equivilent function. 
            // The number of minutes returned by getTimezoneOffset() is positive if the local time zone is behind UTC, 
            // and negative if the local time zone is ahead of UTC.For example, for UTC + 10, -600 will be returned.
            var utcOffset = -today.getTimezoneOffset();

            var woResult = Ext.getCmp('cWorkOrderResults').getValue();
            if (woResult.toLowerCase().indexOf('fail') != -1) {
                var today = new Date(Date.now());
                Ext.getCmp('tMaintNextDate').setValue(today);
            }
            else {
                $.ajax({
                    url: '/CallSheet/CalculateNextMaintDate',
                    type: 'post',
                    dataType: 'json',
                    data: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                        utcOffset: utcOffset,
                        start: today.getTime(),
                        interval: interval.getValue(),
                        nFacilityUID: facility.getValue(),
                        uom: uom.getValue()
                    },
                    success: function (result) {
                        if (result.success) {
                            // Signature of the CalculateNextMaintDate function was changed such that
                            // it now returns the JavaScript "ticks" instead of the raw date.
                            // This is meant to allow the client machine to format as it sees fit.
                            // Parse the ticks that were returned by the server.
                            var ticks = parseFloat(result.message);
                            // Verify that we have an actual value and that it is not
                            // an error condition.
                            if (!isNaN(ticks) && ticks >= 0) {
                                // Parse the ticks.
                                // And then set the UTC value.

                                // We dont need to convert the time into UTC again at this point anyway 
                                // I had to do this to fix problems when using servers on different time zones.
                                // Specifically issues with the Amazon server
                                Ext.getCmp('tMaintNextDate').setValue(result.message); // Binding already converted UTC time result.message into Due Date field.
                                editWindow.setDataDirty();
                            }
                        }
                    }
                });
            }
	        <% } %>
            },
            change: function () {
                editWindow.setDataDirty();
            }
        };

        var calcNextMaintListener = {
            change: function () {
                editWindow.setDataDirty();
            }
        };

        // make Find screen to select appropiate checked box automatically
        function selectSubContractor() {
            var findWindow = app.openWindow({
                title: ___('FIND_FACILITY_TITLE'),
                url: '<%: Url.Content( "~/Shared/Find/" ) %>?subcontractor=1',
            layout: 'fit',
            callbacks: {
                context: 'FindFacilities',
                controller: 'Facility',
                onRecordSelected: function (record) {

                    var valueField = Ext.getCmp("nSubContractorUID");
                    var displayField = Ext.getCmp("nSubContractorUID_display");

                    var id = record.get('UID');
                    var text = record.data["cFacilityName"];

                    valueField.setRawValue(id);
                    displayField.setValue(text);
                    Ext.getCmp("nSubContractorUID_edit").setDisabled(false); // enable Quick link button after look up values gets selected


                    editWindow.setDataDirty();
                    findWindow.close();
                }
            }
        });
        }

        // allow the user to enter only numbers
        var AllowNumbersListener = {
            keypress: function (form, e) {
                var code = e.getKey();
                if (!
                    (
                        // Allow values between 0 (48) and 9 (57)
                        (code >= 48 && code <= 57)
                        ||
                        // Allow backspace (8), delete (127), tab (9)
                        (code == 8 || code == 127 || code == 9)
                        ||
                        // Allow Left arrow (37) and Right arrow (39)
                        (code == 37 || code == 39)
                    )
                ) {
                    // Block everything else
                    e.stopEvent();
                }
            },
            change: function () {
                editWindow.setDataDirty();
            }
        }

        function selectWorkingFacility() {
            var cntrl = this.getEl().id;

            var findWindow = app.openWindow({
                title: ___('FIND_FACILITY_TITLE'),
                url: '<%: Url.Content( "~/Shared/Find/" ) %>?labFacility=1',
            layout: 'fit',
            callbacks: {
                context: 'FindFacilities',
                controller: 'Facility',
                onRecordSelected: function (record) {

                    var valueField = '';
                    var displayField = '';

                    if (cntrl == 'nWorkingFacilityUID_display') {
                        valueField = Ext.getCmp("nWorkingFacilityUID");
                        displayField = Ext.getCmp("nWorkingFacilityUID_display");
                    }
                    else if (cntrl == 'nOwningLabUID_display') {
                        valueField = Ext.getCmp("nOwningLabUID");
                        displayField = Ext.getCmp("nOwningLabUID_display");
                    }

                    var id = record.get('UID');
                    var text = record.data["cFacilityName"];

                    valueField.setRawValue(id);
                    displayField.setValue(text);

                    editWindow.setDataDirty();
                    findWindow.close();
                }
            }
        });
        }

        // call AmbientConditions screen and get the requried thngs back as a result
        function popUpAmbientConditions() {
            var ambientWindow = app.openWindow({
                title: ___('AMBIENT_CONDITIONS_TITLE'),
                url: '<%: Url.Content( "~/CallSheet/AmbientConditions" ) %>',
            width: 500,
            height: 350,
            resizable: true,
            layout: 'fit',
            callbacks: {
                onRecordSelected: function (record) {
                    var Temperature = record.data['Temperature'];
                    var Humidity = record.data['Humidity'];
                    if (Temperature != '') {
                        // remove all non-numeric characters
                        Temperature = Temperature.replace(/[^\d\.]/g, '');
                        Ext.getCmp("cTemperature").setValue(Temperature);
                    }
                    if (Humidity != '') {
                        // remove all non-numeric characters
                        Humidity = Humidity.replace(/[^\d\.]/g, '');
                        Ext.getCmp("cHumidity").setValue(Humidity);
                    }
                    editWindow.setDataDirty();
                    ambientWindow.close();
                }
            }
        });
        }

        // first check for RHT.ini file has only one section if so populate the values on the repective fields
        // If not just redirect into AmbientConditions screen there we handle the rest
        function ViewAmbientConditions() {
            $.ajax({
                url: '/CallSheet/checkForSingleSection',
                type: 'post',
                dataType: 'json',
                success: function (result) {
                    if (result.success) {

                        Ext.each(result.values, function (obj) {
                            if (obj.Temperature != '') {
                                var temperature = obj.Temperature.replace(/[^\d\.]/g, '');
                                Ext.getCmp("cTemperature").setValue(temperature);
                            }
                            if (obj.Humidity != '') {
                                var humidity = obj.Humidity.replace(/[^\d\.]/g, '');
                                Ext.getCmp("cHumidity").setValue(humidity);
                            }
                        });

                        editWindow.setDataDirty();
                    }
                    else {
                        // Assuming that now .ini file has multi sections (C# code has been changed according to that)
                        // just redirect this into AmbientConditions screen there we can handle the rest
                        popUpAmbientConditions();
                    }
                },
                error: function (err) {
                    Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                }
            });
        }

        editForm = Ext.extend(Ext.form.FormPanel, {

            id: 'edit-form',
            url: window.location,
            frame: false,
            hideBorders: true,
            padding: 0,
            labelAlign: 'top',
            layout: 'absolute',
            width: 980,
            height: 555,

            defaults: {
                msgTarget: 'side',
                border: false,
                frame: false,
                hideBorders: true
            },

            initComponent: function () {
                this.items = [
                    {
                        xtype: 'panel',
                        x: 0,
                        y: 0,
                        height: 165,
                        width: 370,
                        layout: 'absolute',
                        items: [
						<%= Html.Label( m => Model.cBarcode, new { X = 5, Y = 0 } ) %>,
						<%= Html.Field( m => Model.cBarcode, new { X = 5, Y = 15, Width = 145, ReadOnly = true } ) %>,
						<%= Html.Label( m => Model.cID, new { X = 155, Y = 0 } ) %>,
						<%= Html.Field( m => Model.cID, new { X = 155, Y = 15, Width = 185, ReadOnly = true } ) %>,
						<%= Html.Label( m => Model.cModelNumber, new { X = 5, Y = 40 } ) %>,
						<%= Html.Field( m => Model.cModelNumber, new { X = 5, Y = 55, Width = 195, ReadOnly = true } ) %>,
						<%= Html.Label( m => Model.cSerialNumber, new { X = 210, Y = 40 } ) %>,
						<%= Html.Field( m => Model.cSerialNumber, new { X = 210, Y = 55, Width = 155, ReadOnly = true } ) %>,
						<%= Html.Label( m => Model.nManufacturerUID, new { X = 5, Y = 80 } ) %>,
						<%= Html.Field( m => Model.cManufacturer, new { X = 5, Y = 95, Width = 195, ReadOnly = true } ) %>,
						<%= Html.Label( m => Model.cTyAuthority, new { X = 210, Y = 80 } ) %>,
						<%= Html.Field( m => Model.cTyAuthority, new { X = 210, Y = 95, Width = 130, ReadOnly = true } ) %>,
						<%= Html.Label( m => Model.cDescription, new { X = 5, Y = 120 } ) %>,
						<%= Html.Field( m => Model.cDescription, new { X = 5, Y = 135, Width = 360, ReadOnly = true } ) %>,
						<%= new ExtButton() {
								ID = "btnBarcodeModify",
								X = 345,
								Y = 15,
                                Tooltip = L.__("EDIT_ASSET"),
								IconClass = "btn-modify-sm",
								CSSClass = "lookup-edit-button",
								Handler = "editAssociatedAsset"
						} %>,
                        <%= new ExtButton() {
								ID = "btnAuthorityModify",
								X = 345,
								Y = 95,
                                Tooltip = L.__("EDIT_TYPE"),
								IconClass = "btn-modify-sm",
								CSSClass = "lookup-edit-button",
								Handler = "editAssociatedType"
						} %>
                    ]
                },
                {
                    xtype: 'panel',
                    x: 380,
                    y: 0,
                    width: 185,
                    layout: 'absolute',
                    height: 125,
                    items: [
						<%= Html.Label( m => Model.nFacilityUID, new { X = 5, Y = 0 } ) %>,
						<%= Html.Lookup( m => Model.nFacilityUID, "cFacilityName", new { X = 5, Y = 15, Width = 180, ReadOnly = true, ShowEditButton = true } ) %>,
						<%= Html.Label( m => Model.nDepartmentUID, new { X = 5, Y = 40 } ) %>,
						<%= Html.Lookup( m => Model.nDepartmentUID, "cFacilityName", new { X = 5, Y = 55, Width = 180, ReadOnly = true, ShowEditButton = true } ) %>,
						<%= Html.Label( m => Model.nJobNumberUID, new { X = 5, Y = 80 } ) %>,
                        <% if (Licensing.IsLicensedModule(ModuleType.METTeamExpress, false, false))
        { %>
                        <%= Html.Lookup( m => Model.nJobNumberUID, "cJobOrderNumber", new { X = 5, Y = 95, Width = 180, ShowEditButton = true, TriggerHandler = "doFindJobNumber", Disabled = true, DisableAutocomplete = true }) %> // disable job number for METTEAM Express users / Changed CheckExpiration parameter value to "false"
                        <%}
        else
        {%>
                        <%= Html.Lookup( m => Model.nJobNumberUID, "cJobOrderNumber", new { X = 5, Y = 95, Width = 180, ShowEditButton = true, TriggerHandler = "doFindJobNumber", DisableAutocomplete = true  }) %>
                        <%}%>
                    ]
                },
                {
                    xtype: 'panel',
                    x: 575,
                    y: 0,
                    width: 395,
                    height: 120,
                    layout: 'absolute',
                    items: [
						<%= Html.Label( m => Model.cCallSheetType, new { X = 5, Y = 0 } ) %>,
						<%= Html.DataCombo( m => Model.cCallSheetType, "ServiceType", "cServiceName", new { X = 5, Y = 15, Width = 180, DisableCustomizations = true } ) %>,
						<%= Html.Label( m => Model.cCallSheetStatus, new { X = 200, Y = 0 } ) %>,
						<%= Html.Field( m => Model.cCallSheetStatus, new { X = 200, Y = 15, Width = 180, Listeners = "statusListener", ReadOnly = DisableStatusField } ) %>,
                        
						<%= Html.Label( m => Model.nOwningLabUID, new { X = 5, Y = 40 } ) %>,
						<%= Html.Lookup( m => Model.nOwningLabUID, "cFacilityName", new { X = 5, Y = 55, Width = 375, ShowEditButton = true, TriggerHandler = "selectWorkingFacility" } ) %>,
						<%= Html.Label( m => Model.nWorkingFacilityUID, new { X = 5, Y = 80 } ) %>,
						<%= Html.Lookup( m => Model.nWorkingFacilityUID, "cFacilityName", new { X = 5, Y = 95, Width = 375, ShowEditButton = true, TriggerHandler = "selectWorkingFacility"} ) %>
                    ]
                },
                    {
                        xtype: 'panel',
                        width: 570,
                        height: 45,
                        layout: 'absolute',
                        x: 380,
                        y: 120,
                        items: [
						<%= Html.Label( m => Model.cContactInfo, new { X = 5, Y = 0, Width = 325} ) %>,
						<%= Html.Field( m => Model.cContactInfo, new { X = 5, Y = 15, Width = 325 } ) %>,
                        <%= Html.Label( m => Model.cWorkOrderResults, new { X = 340, Y = 0, Width = 232} ) %>,
                        <%= Html.Field( m => Model.cWorkOrderResults, new { X = 340, Y = 15, Width = 232 } ) %>
                    ]
                },
                {
                    xtype: 'tabpanel',
                    id: 'Tabs',
                    activeTab: 0,
                    x: 0,
                    y: 165,
                    height: 320,
                    width: 975,
                    enableTabScroll: true,
                    minTabWidth: 65,
                    items: [
                        {
                            xtype: 'panel',
                            title: ___('CALLSHEET_SERVICE_TITLE'),
                            tabTip: ___('CALLSHEET_SERVICE_TITLE'),
                            height: 290,
                            layout: 'absolute',
                            padding: '',
                            width: 936,
                            items: [
                                {
                                    xtype: 'panel',
                                    title: '',
                                    x: 0,
                                    y: 0,
                                    width: 975,
                                    height: 45,
                                    layout: 'absolute',
                                    items: [
										<%= Html.Label( m => Model.tRequiredDate, new { X = 5, Y = 0 } ) %>,
										<%= Html.Field( m => Model.tRequiredDate, new { X = 5, Y = 15, Width = 150 } ) %>,
                                        <%= Html.Label( m => Model.nPriority, new { X = 170, Y = 0 } ) %>,
										<%= Html.Field( m => Model.nPriority, new { X = 170, Y = 15, Width = 80 } ) %>,
										<%= Html.Label( m => Model.tOpenDate, new { X = 265, Y = 0 } ) %>,
										<%= Html.Field( m => Model.tOpenDate, new { X = 265, Y = 15, Width = 150 } ) %>,
										<%= Html.Label( m => Model.tMaintDate, new { X = 430, Y = 0 } ) %>,
										<%= Html.Field( m => Model.tMaintDate, new { X = 430, Y = 15, Width = 150, Listeners = "serviceDateListener" } ) %>,
										<%= Html.Label( m => Model.cInterval, new { X = 595, Y = 0 } ) %>,
										<%= Html.Field( m => Model.cInterval, new { X = 595, Y = 15, Width = 60, Listeners = "AllowNumbersListener" } ) %>,// allow the user to enter only numbers
										<%= Html.Label( m => Model.cIntervalUOM, new { X = 670, Y = 0 } ) %>,
										<%= Html.Field( m => Model.cIntervalUOM, new { X = 670, Y = 15, Width = 110, Listeners = "calcNextMaintListener" } ) %>,
                               			<%= Html.Label( m => Model.tMaintNextDate, new { X = 800, Y = 0 } ) %>,
										<%= Html.Field( m => Model.tMaintNextDate, new { X = 800, Y = 15, Width = 150, Listeners = "dueDateListener" } ) %>
                                    ]
                                },
                                {
                                    xtype: 'panel',
                                    title: '',
                                    x: 320,
                                    y: 45,
                                    width: 395,
                                    height: 245,
                                    layout: 'absolute',
                                    items: [
                                        {
                                            xtype: 'hidden',
                                            name: 'nTypeProcedureDefaultUID',
                                            id: 'nTypeProcedureDefaultUID',
                                            value: '<%= Model.nTypeProcedureDefaultUID %>'
                                        },
                                        {
                                            xtype: 'hidden',
                                            name: 'nTypeUID',
                                            id: 'nTypeUID',
                                            value: '<%= Model.nTypeUID %>'
                                        },
										<%= Html.Label( m => Model.nDefaultProcedureUID , new { X = 5, Y = 0 } ) %>,
										<%= Html.Lookup( m => Model.nDefaultProcedureUID , "cProcedureName", new { X = 5, Y = 15, ReadOnly = true, Width = 380, ShowEditButton = true } ) %>,
										<%= Html.Label( m => Model.nProcedureUID, new { X = 5, Y = 40 } ) %>,
										<%= Html.Lookup( m => Model.nProcedureUID, "cProcedureName", new { X = 5, Y = 55, Width = 380, DisableAutocomplete = true, TriggerHandler = "doFindProcedure", ShowEditButton = true } ) %>,

                                        <%= Html.Label( m => Model.cInitialCondition, new { X = 5, Y = 80 } ) %>,
                                        <%= Html.Field( m => Model.cInitialCondition, new { X = 5, Y = 95, Width = 380 } ) %>,
                                        <%= Html.Label( m => Model.cServiceReason, new { X = 5, Y = 120 } ) %>,
                                        <%= Html.Field( m => Model.cServiceReason, new { X = 5, Y = 135, Width = 380 } ) %>,

                                        // hidden fields (positioned off screen) for nTechnicianApprovedByUID and tTechnicianApprovedDate, needed to facilitate signing process
                                        <%= Html.Lookup( m => Model.nTechnicianApprovedByUID, "FullName", new { X = 2000, Y = 2000, Width = 80, Visible = false, ShowEditButton = false } ) %>,
                                        <%= Html.Field( m => Model.tTechnicianApprovedDate, new { X = 2000, Y = 2000, Width = 80, Visible = false, Listeners = "tTechnicianApprovedDateListener" } ) %>,

										<%= new ExtButton( "CallSheets", "cmdTechSignature" ) { 
											CSSClass = "x-btn-text", 
											Handler = "doGetTechnicianSignature",
											Text = L.__("TECH_SIGNATURE_TEXT"),
											Tooltip = L.__("TECH_SIGNATURE_TOOLTIP"),
											X = 5,
											Y = 162,
                                            Width = 135,
                                            Height = 35,
                                            Disabled = isLocked
										} %>,
                                        {
                                            xtype: 'label',
                                            text: '',
                                            x: 160,
                                            y: 164,
                                            width: 250,
                                            hidden: !isSignedByTechnician,
                                            id: 'techSignatureName',
                                            cls: 'centered'
                                        },
                                        {
                                            xtype: 'label',
                                            text: '',
                                            x: 160,
                                            y: 179,
                                            width: 250,
                                            hidden: !isSignedByTechnician,
                                            id: 'techSignatureDate',
                                            cls: 'centered'
                                        },

                                        // hidden fields (positioned off screen) for nQCApprovedByUID and tQCApprovedDate, needed to facilitate signing process
                                        <%= Html.Lookup( m => Model.nQCApprovedByUID, "FullName", new { X = 2000, Y = 2000, Width = 80, Visible = false, ShowEditButton = false } ) %>,
                                        <%= Html.Field( m => Model.tQCApprovedDate, new { X = 2000, Y = 2000, Width = 80, Visible = false, Listeners = "tQCApprovedDateListener" } ) %>,

                                        <%= new ExtButton( "CallSheets", "cmdQCSignature" ) { 
											CSSClass = "x-btn-text", 
											Handler = "doGetQCSignature",
											Text = L.__("QC_SIGNATURE_TEXT"),
											Tooltip = L.__("QC_SIGNATURE_TOOLTIP"),
											X = 5,
											Y = 203,
                                            Width = 135,
                                            Height = 35,
                                            Disabled = isLocked
										} %>,
                                        {
                                            xtype: 'label',
                                            text: '',
                                            x: 160,
                                            y: 205,
                                            width: 250,
                                            hidden: !isSignedByQC,
                                            id: 'qcSignatureName',
                                            cls: 'centered'
                                        },
                                        {
                                            xtype: 'label',
                                            text: '',
                                            x: 160,
                                            y: 220,
                                            width: 250,
                                            hidden: !isSignedByQC,
                                            id: 'qcSignatureDate',
                                            cls: 'centered'
                                        }
                                    ]
                                },
                                {
                                    xtype: 'panel',
                                    title: '',
                                    x: 0,
                                    y: 45,
                                    width: 320,
                                    height: 245,
                                    layout: 'absolute',
                                    items: [
										<%= Html.Label( m => Model.cCallSheetNumber, new { X = 5, Y = 0 } ) %>,
										<%= Html.Field( m => Model.cCallSheetNumber, new { X = 5, Y = 15, ReadOnly = true, Width = 150 } ) %>,
										<%= Html.Label( m => Model.cCertificationNumber, new { X = 170, Y = 0 } ) %>,
										<%= Html.Field( m => Model.cCertificationNumber, new { X = 170, Y = 15, Width = 135 } ) %>,
										<%= Html.Label( m => Model.cStickerType, new { X = 5, Y = 40 } ) %>,
										<%= Html.Field( m => Model.cStickerType, new { X = 5, Y = 55, Width = 230 } ) %>,
										<%= Html.Label( m => Model.cCertFormat, new { X = 5, Y = 80 } ) %>,
										<%= Html.Field( m => Model.cCertFormat, new { X = 5, Y = 95, Width = 230 } ) %>,
                                        {
                                            xtype: 'button',
                                            id: 'btnStickerNote',
                                            tooltip: ___('CALLSHEET_EDIT_STICKER_NOTES'),
                                            iconCls: 'btn-notes-sm',
                                            x: 240,
                                            y: 55,
                                            width: 20,
                                            height: 20,
                                            disabled: false,
                                            handler: doStickerNote,
                                            disabled: isNewRecord,
                                            listeners: stickerButtonListener
                                        },
                                        {
                                            xtype: 'splitbutton',
                                            id: 'btnPrintSticker',
                                            tooltip: ___('PRINT'),
                                            iconCls: 'btn-print-sm',
                                            x: 260,
                                            y: 55,
                                            width: 20,
                                            height: 20,
                                            handler: doPrintStickerNote,
                                            disabled: isNewRecord,
                                            listeners: stickerButtonListener,
                                            // Work Order Sticker to be able to export reports as .CSV files as well as .PDF.
                                            menu: new Ext.menu.Menu({
                                                items: [
                                                    {
                                                        text: ___('PRINT'),
                                                        handler: function () { doPrintStickerNote("Print"); },
                                                        tabTip: ___('PRINT')
                                                    },
                                                    {
                                                        text: ___('EXPORT'),
                                                        handler: function () { doPrintStickerNote("Export"); },
                                                        tabTip: ___('EXPORT')
                                                    }
                                                ]
                                            })
                                        },
										<%= Html.Label( m => Model.nAssignedTechUID, new { X = 5, Y = 120 } ) %>,
										<%= Html.Lookup( m => Model.nAssignedTechUID, "FullName", new { X = 5, Y = 135, Width = 300, ShowEditButton = true } ) %>,
										<%= Html.Label( m => Model.nTechnicianUID, new { X = 5, Y = 160 } ) %>,
										<%= Html.Lookup( m => Model.nTechnicianUID, "FullName", new { X = 5, Y = 175, Width = 300, ShowEditButton = true } ) %>,
										<%= Html.Label( m => Model.cArea, new { X = 5, Y = 200 } ) %>,
										<%= Html.Field( m => Model.cArea, new { X = 5, Y = 215, Width = 300 } ) %>
                                    ]
                                },
                                {
                                    xtype: 'panel',
                                    title: '',
                                    x: 715,
                                    y: 45,
                                    width: 290,
                                    height: 245,
                                    padding: 3,
                                    layout: 'absolute',
                                    items: [
										<%= Html.Field( m => Model.lOnSite, new { X = 5, Y = 5 }) %>,
										<%= Html.Field( m => Model.lExpedite, new { X = 5, Y = 20 }) %>,
										<%= Html.Field( m => Model.lSubContracted, new { X = 5, Y = 35 } ) %>,
										<%= Html.Field( m => Model.lISOCert, new { X = 5, Y = 50 } ) %>,
										<%= Html.Field( m => Model.lCancelled, new { X = 5, Y = 65 } ) %>,
										<%= Html.Field( m => Model.lOOT, new { X = 5, Y = 80 } ) %>,
										<%= Html.Field( m => Model.lReturnNoMaint, new { X = 5, Y = 95 } ) %>,
										<%= Html.Field( m => Model.lDelayed, new { X = 5, Y = 110 } ) %>,
                                        <%= Html.Field( m => Model.lOptional1, new { X = 5, Y = 125 } ) %>,
                                        <%= Html.Field( m => Model.lOptional2, new { X = 5, Y = 140 } ) %>,

                                        <%= Html.Label( m => Model.cTemperature, new { X = 5, Y = 160 } ) %>,
										<%= Html.Field( m => Model.cTemperature, new { X = 5, Y = 175, Width = 90 } ) %>,
										<%= Html.Label( m => Model.cHumidity, new { X = 120, Y = 160 } ) %>,
										<%= Html.Field( m => Model.cHumidity, new { X = 120, Y = 175, Width = 90 } ) %>,
										<%= Html.Label( m => Model.cPressure, new { X = 5, Y = 200 } ) %>,
										<%= Html.Field( m => Model.cPressure, new { X = 5, Y = 215, Width = 90 } ) %>

                                    ]
                                }
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: ___('EXTENDED DATA'),
                            tabTip: ___('EXTENDED DATA'),
                            height: 352,
                            layout: 'absolute',
                            items: [
                                <%= Html.Label( m => Model.nGroupUID, new { X = 5, Y = 250 } ) %>,
                                <%= Html.Field( m => Model.nGroupUID, new { ReadOnly = true, X = 5, Y = 265, Width = 365, XType = "textfield" } ) %>,  //XType needed to show GUID as text, not a number!
								<%= Html.Label( m => Model.cReturnedTo, new { X = 200, Y = 125 } ) %>,
								<%= Html.Field( m => Model.cReturnedTo, new { ReadOnly = true, X = 200, Y = 140, Width = 170 } ) %>,
								<%= Html.Label( m => Model.nCategoryUID, new { X = 5, Y = 85 } ) %>,
								<%= Html.Lookup( m => Model.nCategoryUID, "cDescription", new { X = 5, Y = 100, Width = 170, ShowEditButton = false, TriggerHandler = "selectCategory", DisableAutocomplete = true } ) %>,
                                <%= Html.Label( m => Model.nSubCategoryUID, new { X = 5, Y = 125 } ) %>,
								<%= Html.Lookup( m => Model.nSubCategoryUID, "cDescription", new { X = 5, Y = 140, Width = 170, ShowEditButton = false, TriggerHandler = "selectSubCategory", DisableAutocomplete = true } ) %>,
								<%= Html.Label( m => Model.nQuantity, new { X = 5, Y = 165 } ) %>,
								<%= Html.Field( m => Model.nQuantity, new { X = 5, Y = 180, Width = 170 } ) %>,
								<%= Html.Label( m => Model.tClosedDate, new { X = 5, Y = 5 } ) %>,
								<%= Html.Field( m => Model.tClosedDate, new { X = 5, Y = 20, Width = 170, ReadOnly = true } ) %>,
								<%= Html.Label( m => Model.nCost, new { X = 5, Y = 45, ReadOnly = true  } ) %>,
								<%= Html.Field( m => Model.nCost, new { X = 5, Y = 60, Width = 170, ReadOnly = true, IsCurrency = true  } ) %>,
								<%= Html.Label( m => Model.cInvoiceNo, new { X = 200, Y = 5 } ) %>,
                                <%= Html.Lookup( m => Model.nInvoiceUID, "cInvoiceNo", new { ReadOnly = true, ShowEditButton = true, X = 200, Y = 20, Width = 170 }) %>,
                                {
                                    xtype: 'splitbutton',
                                    id: 'btnPrintInvoice',
                                    tooltip: ___('PRINT'),
                                    iconCls: 'btn-print-sm',
                                    x: 370,
                                    y: 20,
                                    width: 20,
                                    height: 20,
                                    handler: doPrintInvoice,
                                    disabled: isNewRecord || !hasInvoice || isMetCal,
                                    // Work Order invoice to be able to export reports as .XLS files as well as .PDF.
                                    menu: new Ext.menu.Menu({
                                        items: [
                                            {
                                                text: ___('PRINT'),
                                                handler: function () { doPrintInvoice("Print"); },
                                                tabTip: ___('PRINT')
                                            },
                                            {
                                                text: ___('EXPORT'),
                                                handler: function () { doPrintInvoice("Export"); },
                                                tabTip: ___('EXPORT')
                                            }
                                        ]
                                    })
                                },
								<%= Html.Label( m => Model.nReturnedByUID, new { X = 200, Y = 45, ReadOnly = true  } ) %>,
								<%= Html.Lookup( m => Model.nReturnedByUID, "FullName", new { X = 200, Y = 60, Width = 143, ReadOnly = true  } ) %>,
								<%= new ExtButton( "CallSheets", "cmdPrintPackingSlip" ) { 
									IconClass = "btn-print-sm",
									CSSClass = "x-btn-text", 
									Handler = "doPrintPackingSlip",
									Tooltip = L.__("CALLSHEET_PRINT_PACKING_SLIP_TOOLTIP"),
									X = 348,
									Y = 60,
									Text = ""
								} %>,
                                // Work Order return by date able to export reports as .XLS files as well as .PDF.
                                {
                                    xtype: 'splitbutton',
                                    id: 'cmdPrintPackingSlip',
                                    iconCls: 'btn-print-sm',
                                    x: 348,
                                    y: 60,
                                    width: 20,
                                    height: 20,
                                    handler: doPrintPackingSlip,
                                    disabled: !isClosed || isMetCal,
                                    menu: new Ext.menu.Menu({
                                        items: [
                                            {
                                                text: ___('PRINT'),
                                                handler: function () { doPrintPackingSlip("Print"); },
                                                tabTip: ___('PRINT')
                                            },
                                            {
                                                text: ___('EXPORT'),
                                                handler: function () { doPrintPackingSlip("Export"); },
                                                tabTip: ___('EXPORT')
                                            }
                                        ]
                                    })
                                },

								<%= Html.Label( m => Model.tReturnedDate, new { X = 200, Y = 85, ReadOnly = true } ) %>,
								<%= Html.Field( m => Model.tReturnedDate, new { X = 200, Y = 100, Width = 170, ReadOnly = true } ) %>,
                                {
                                    xtype: 'panel',
                                    title: ___('EX_DATA'),
                                    x: 408,
                                    y: 0,
                                    width: 570,
                                    height: 285,
                                    layout: 'fit',
                                    items: [
										<%= ExtendedDataHtmlHelper.ExtendedDataGrid( "CallSheet", Model.nCallSheetUID, new { ColumnLines = true } ) %>
                                    ]
                                }
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: ___('LOG_NOTES'),
                            tabTip: ___('LOG_NOTES'),
                            height: 352,
                            layout: 'fit',
                            items: [
								<%= Html.RenderGrid( "FillgrdLogNotes", new { ID = "grdLogNotes", Listeners = "logNotesListeners" }, Model.nCallSheetUID ) %>
                            ],
                            bbar: {
                                items: [
									<%= new ExtButton( "CallSheets", "cmdAddLogNotes" ) { 
										IconClass = "btn-add-sm",
										CSSClass = "x-btn-icon", 
                                        Handler = @"addLogNote",
                                        Text = "",
                                        Tooltip = L.__("CALLSHEET_ADD_NEW_LOG_NOTE_TOOLTIP"),
										Disabled = isNewRecord || isLocked
									} %>,
									<%= new ExtButton( "CallSheets", "cmdDeleteLogNotes" ) { 
										IconClass = "btn-delete-sm",
										CSSClass = "x-btn-icon", 
                                        Handler = @"deleteLogNote",
										Text = "",
                                        Tooltip = L.__("CALLSHEET_DELETE_SELECTED_LOG_NOTE_TOOLTIP"),
										Disabled = true
									} %>,
									<%= new ExtButton( "CallSheets", "cmdEditLogNotes" ) { 
										IconClass = "btn-modify-sm",
										CSSClass = "x-btn-icon", 
                                        Handler = @"editLogNote",
										Text = "",
                                        Tooltip =L.__("CALLSHEET_MODIFY_SELECTED_LOG_NOTE_TOOLTIP"),
										Disabled = true
									} %>
                                ]
                            }
                        },
                        {
                            xtype: 'panel',
                            title: ___('CALLSHEET_LABOR_FILES_TITLE'),
                            tabTip: ___('CALLSHEET_LABOR_FILES_TITLE'),
                            layout: 'hbox',
                            items: [
                                {
                                    xtype: 'panel',
                                    title: ___('LABOR'),
                                    height: 290,
                                    layout: 'fit',
                                    flex: 4,
                                    items: [
										<%= Html.RenderGrid( "FillgrdHours", new { ID = "grdHours", Listeners = "laborListeners" }, Model.nCallSheetUID ) %>
                                    ],
                                    bbar: {
                                        items: [
											<%= new ExtButton( "CallSheets", "cmdAddLabor" ) { 
												IconClass = "btn-add-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(addLabor); }",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_ADD_NEW_LABOR_ITEM_TOOLTIP"),
												Disabled = isNewRecord || isLocked
											} %>,
											<%= new ExtButton( "CallSheets", "cmdDeleteLabor" ) { 
												IconClass = "btn-delete-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(deleteLabor); }",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_DELETE_SELECTED_LABOR_TOOLTIP"),
												Disabled = true
											} %>,
											<%= new ExtButton( "CallSheets", "cmdModifyLabor" ) { 
												IconClass = "btn-modify-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(modifyLabor); }",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_MODIFY_SELECTED_LABOR_TOOLTIP"),
												Disabled = true
											} %>
                                        ]
                                    }
                                },
                                {
                                    xtype: 'panel',
                                    title: ___('FILES'),
                                    height: 290,
                                    layout: 'fit',
                                    flex: 10,
                                    items: [
										<%= Html.RenderGrid( "FillgrdCSFiles", new { ID = "grdCallsheetFiles", Listeners = "fileListeners", PageSize = 150000, RemoteSort = false }, Model.nCallSheetUID ) %>
                                    ],
                                    bbar: {
                                        items: [
											<%= new ExtButton( "CallSheets", "cmdAddFiles" ) { 
												IconClass = "btn-add-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(addFile); }",
												Text = "",
												Tooltip = L.__("ATTACH_EXISTING_FILE_TOOLTIP"),
												Disabled = isNewRecord || isLocked,
												XType = "splitbutton",
												Menu = new ExtMenu( "CallSheets", "mnuAddFiles", new { Items = new List<ExtMenu>() {
													new ExtMenu( "CallSheets", "mnuAttachFile", new { Text = L.__("ATTACH_FILE_TITLE"), Handler = "function() { showDirtyWarning(addFile); }" } ),
													new ExtMenu( "CallSheets", "mnuUploadFile", new { Text = L.__("UPLOAD_FILE_TEXT"), Handler = "function() { showDirtyWarning(uploadFile); }" } )
												} } )
											} %>,
											<%= new ExtButton( "CallSheets", "cmdDeleteFiles" ) { 
												IconClass = "btn-delete-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(deleteFile); }",
												Text = "",
												Tooltip = L.__("DELETE_SELECTED_FILE_TOOLTIP"),
												Disabled = true
											} %>,
											<%= new ExtButton( "CallSheets", "cmdModifyFiles" ) { 
												IconClass = "btn-modify-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(modifyFile); }",
												Text = "",
												Tooltip = L.__("MODIFY_SELECTED_FILE_TOOLTIP"),
												Disabled = true
											} %>,
											<%= new ExtButton( "CallSheets", "cmdViewFiles" ) { 
												IconClass = "btn-modify2-sm", 
												CSSClass = "x-btn-icon", 
												Handler = @"viewFile",
												Text = "",
												Tooltip = L.__("VIEW_SELECTEDFILE_TOOLTIP"),
												Disabled = true
											} %>
                                        ]
                                    }
                                }
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: ___('CALLSHEET_STANDARDS_ACCREDITATIONS_TITLE'),
                            tabTip: ___('CALLSHEET_STANDARDS_ACCREDITATIONS_TITLE'),
                            layout: 'hbox',
                            items: [
                                {
                                    xtype: 'panel',
                                    title: ___('CALLSHEET_STANDARDS_TITLE'),
                                    height: 290,
                                    flex: 1,
                                    layout: 'fit',
                                    items: [
										<%= Html.RenderGrid( "FillgrdStandards", new { ID = "grdStandards" }, Model.nCallSheetUID ) %>
                                    ],
                                    bbar: {
                                        items: [
											<%= new ExtButton( "CallSheets", "cmdStandardsOnly" ) { 
												CSSClass = "x-btn-Text", 
                                                Handler = "function() { showDirtyWarning(addProcedureStandard); }",
                                                Disabled = isLocked,
												Text = L.__("CALLSHEET_STANDARDS_ONLY_TEXT")
											} %>,
                                            "-",
											<%= new ExtButton( "CallSheets", "cmdAddStandards" ) { 
												IconClass = "btn-add-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(addStandard); }",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_ADD_NEW_STANDARD_TOOLTIP"),
												Disabled = isNewRecord || isLocked
											} %>,
											<%= new ExtButton( "CallSheets", "cmdDeleteStandards" ) { 
												IconClass = "btn-delete-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(removeStandard); }",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_DELETE_STANDARD_TOOLTIP"),
												Disabled = isNewRecord || isLocked
											} %>,
											<%= new ExtButton( "CallSheets", "cmdModifyStandards" ) { 
												IconClass = "btn-modify-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "editStandard",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_MODIFY_STANDARD_TOOLTIP"),
                                                Disabled = isNewRecord // removed disable functionality when work order  closed - "isLocked"
											} %>,
                                            <%= new ExtButton( "CallSheets", "cmdSwapStandards" ) { 
												IconClass = "btn-fix-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(swapStandard); }",
												Text = "",
                                                Tooltip = L.__("SWAP_STANDARD"),
                                                Disabled = isNewRecord
											} %>,
                                            "-",
                                            {
                                                xtype: 'button',
                                                id: 'cmdReverseTraceability',
                                                iconCls: 'x-btn-text',
                                                Disabled: isNewRecord,
                                                text: ___("CALLSHEET_REVERSE_TRACEABILITY_TEXT"),
                                                tooltip: Tooltip = ___("CALLSHEET_REVERSE_TRACEABILITY_TITLE"),
                                                menu: new Ext.menu.Menu({
                                                    items: [
                                                        {
                                                            text: ___('PRINT'),
                                                            handler: function () { doRT("Print"); },
                                                            tabTip: ___('PRINT')
                                                        },
                                                        {
                                                            text: ___('EXPORT'),
                                                            handler: function () { doRT("Export"); },
                                                            tabTip: ___('EXPORT')
                                                        }
                                                    ]
                                                })
                                            },
                                            {
                                                xtype: 'button',
                                                id: 'cmdForwardTraceability',
                                                iconCls: 'x-btn-text',
                                                Disabled: isNewRecord,
                                                text: ___("CALLSHEET_FORWARD_TRACEABILITY_TEXT"),
                                                tooltip: Tooltip = ___("FORWARD_TRACEABILITY_TOOLTIP"),
                                                menu: new Ext.menu.Menu({
                                                    items: [
                                                        {
                                                            text: ___('PRINT'),
                                                            handler: function () { doFT("Print"); },
                                                            tabTip: ___('PRINT')
                                                        },
                                                        {
                                                            text: ___('EXPORT'),
                                                            handler: function () { doFT("Export"); },
                                                            tabTip: ___('EXPORT')
                                                        }
                                                    ]
                                                })
                                            },
                                        ]
                                    }
                                },
                                {
                                    xtype: 'panel',
                                    title: ___('ACCREDITATIONS'),
                                    height: 290,
                                    width: 335,
                                    layout: 'fit',
                                    items: [
										<%= Html.RenderGrid( "FillgrdNist", new { ID = "grdNist" }, Model.nCallSheetUID ) %>
                                    ],
                                    bbar: {
                                        items: [
											<%= new ExtButton( "CallSheets", "cmdAddAccreditations" ) { 
												IconClass = "btn-add-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(addAccreditation); }",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_ADD_NEW_ACCREDITATION_TOOLTIP"),
												Disabled = isNewRecord || isLocked
											} %>,
											<%= new ExtButton( "CallSheets", "cmdDeleteAccreditations" ) { 
												IconClass = "btn-delete-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(removeAccreditation); }",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_DELETE_SELECTED_ACCREDITATION_TOOLTIP"),
												Disabled = isNewRecord || isLocked
											} %>,
											<%= new ExtButton( "CallSheets", "cmdModifyAccreditations" ) { 
												IconClass = "btn-modify-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "editAccreditation",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_MODIFY_SELECTED_ACCREDITATION_TOOLTIP"),
												Disabled = isNewRecord || isLocked
											} %>
                                        ]
                                    }
                                }
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: ___('NOTES'),
                            tabTip: ___('NOTES'),
                            layout: 'absolute',
                            items: [
                                <%= Html.Label( m => Model.mAccuracyNotes, new { X = 3, Y = 5 } ) %>,
                                <%= new ExtButton( "CallSheets", "edit_mAccuracyNotes" ) {
	                                IconClass = "btn-notes-sm",
	                                CSSClass = "x-btn-icon", 
                                    Handler = "function() { editNotesField('mAccuracyNotes'); }",
	                                Text = "",
	                                Tooltip = L.__("EDIT_NOTES_TOOLTIP"),
	                                X = 218, Y = 2
                                } %>,
                                <%= Html.Field( m => Model.mAccuracyNotes, new { X = 3, Y = 24, Width = 239, Height = 265 } ) %>,

                                <%= Html.Label( m => Model.mUncertaintyNotes, new { X = 246, Y = 5 } ) %>,
                                <%= new ExtButton( "CallSheets", "edit_mUncertaintyNotes" ) {
	                                IconClass = "btn-notes-sm",
	                                CSSClass = "x-btn-icon", 
                                    Handler = "function() { editNotesField('mUncertaintyNotes'); }",
	                                Text = "",
	                                Tooltip = L.__("EDIT_NOTES_TOOLTIP"),
	                                X = 461, Y = 2
                                } %>,
                                <%= Html.Field( m => Model.mUncertaintyNotes, new { X = 246, Y = 24, Width = 239, Height = 265 } ) %>,

                                <%= Html.Label( m => Model.mOOTNotes, new { X = 489, Y = 5 } ) %>,
                                <%= new ExtButton( "CallSheets", "edit_mOOTNotes" ) {
	                                IconClass = "btn-notes-sm",
	                                CSSClass = "x-btn-icon", 
                                    Handler = "function() { editNotesField('mOOTNotes'); }",
	                                Text = "",
	                                Tooltip = L.__("EDIT_NOTES_TOOLTIP"),
	                                X = 704, Y = 2
                                } %>,
                                <%= Html.Field( m => Model.mOOTNotes, new { X = 489, Y = 24, Width = 239, Height = 265 } ) %>,

                                <%= Html.Label( m => Model.mCallSheetNotes, new { X = 732, Y = 5 } ) %>,
                                <%= new ExtButton( "CallSheets", "edit_mCallSheetNotes" ) {
	                                IconClass = "btn-notes-sm",
	                                CSSClass = "x-btn-icon", 
	                                Handler = "function() { editNotesField('mCallSheetNotes'); }",
	                                Text = "",
	                                Tooltip = L.__("EDIT_NOTES_TOOLTIP"),
	                                X = 947, Y = 2
                                } %>,
                                <%= Html.Field( m => Model.mCallSheetNotes, new { X = 732, Y = 24, Width = 239, Height = 265 } ) %>
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: ___('PARTS'),
                            tabTip: ___('PARTS'),
                            disabled: <%= Licensing.IsLicensedModule( ModuleType.METTeamExpress ).ToString().ToLower() %>,
                            layout: 'hbox',
                            items: [
								<% if (!Licensing.IsLicensedModule(ModuleType.METTeamExpress)) { %>
                                {
                                    xtype: 'panel',
                                    title: ___('PARTS'),
                                    height: 290,
                                    flex: 1,
                                    layout: 'fit',
                                    items: [
										<%= Html.RenderGrid( "FillgrdParts", new { ID = "grdParts", Listeners = "partsListeners" }, Model.nCallSheetUID ) %>
                                    ],
                                    bbar: {
                                        items: [
											<%= new ExtButton( "CallSheets", "cmdAddPart" ) { 
												IconClass = "btn-add-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(addPart); }",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_ADD_NEW_PART_TOOLTIP"),
												Disabled = isNewRecord || isLocked
											} %>,
											<%= new ExtButton( "CallSheets", "cmdDeletePart" ) { 
												IconClass = "btn-delete-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(deletePart); }",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_DELETE_SELECTED_PART_TOOLTIP"),
												Disabled = true
											} %>,
											<%= new ExtButton( "CallSheets", "cmdModifyPartLink" ) { 
												IconClass = "btn-modify-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "function() { showDirtyWarning(editPartLink); }",
												Text = "",
                                                Tooltip =  L.__("CALLSHEET_MODIFY_SELECTED_PART_LINK_TOOLTIP"),
												Disabled = true
											} %>,
											<%= new ExtButton( "CallSheets", "cmdModifyPart" ) { 
												IconClass = "btn-modify-sm",
												CSSClass = "x-btn-icon", 
                                                Handler = "modifyPart",
												Text = "",
                                                Tooltip = L.__("CALLSHEET_MODIFY_SELECTED_PART_TOOLTIP"),
												Disabled = true
											} %>
                                        ]
                                    }
                                }
								<% } %>
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: ___('CALLSHEET_SUBCONTRACT_ESTIMATE_TITLE'),
                            tabTip: ___('CALLSHEET_SUBCONTRACT_ESTIMATE_TITLE'),
                            disabled: <%= Licensing.IsLicensedModule( ModuleType.METTeamExpress ).ToString().ToLower() %>,
                            layout: 'absolute',
                            items: [
								<%= Html.Label( m => Model.nSubContractorUID, new { X = 5, Y = 5 } ) %>,
								<%= Html.Lookup( m => Model.nSubContractorUID, "cFacilityName", new { X = 5, Y = 20, Width = 240, ShowEditButton = true, TriggerHandler = "selectSubContractor" } ) %>,
								<%= Html.Label( m => Model.nSubContCost, new { X = 5, Y = 45 } ) %>,
								<%= Html.Field( m => Model.nSubContCost, new { X = 5, Y = 60, Width = 180, IsCurrency = true, Listeners = "PreventNegativeListener" } ) %>,
								<%= Html.Label( m => Model.nSubContLabCost, new { X = 5, Y = 85 } ) %>,
								<%= Html.Field( m => Model.nSubContLabCost, new { X = 5, Y = 100, Width = 180, IsCurrency = true, Listeners = "PreventNegativeListener" } ) %>,
								<%= Html.Label( m => Model.nSubContHours, new { X = 5, Y = 125 } ) %>,
								<%= Html.Field( m => Model.nSubContHours, new { X = 5, Y = 140, Width = 180, Listeners = "PreventNegativeListener" } ) %>,
								<%= Html.Label( m => Model.tDelayDate, new { X = 5, Y = 165 } ) %>,
								<%= Html.Field( m => Model.tDelayDate, new { X = 5, Y = 180, Width = 180 } ) %>,
                                {
                                    xtype: 'panel',
                                    title: ___('SUB CONTRACTOR NOTES'),
                                    x: 360,
                                    y: 0,
                                    width: 613,
                                    height: 290,
                                    layout: 'fit',
                                    items: [
										<%= Html.Field( m => Model.mSubContractorNotes, new { } ) %>
                                    ]
                                },
                                <%= new ExtButton( "CallSheets", "edit_mSubContractorNotes" ) {
	                                IconClass = "btn-notes-sm",
	                                CSSClass = "x-btn-icon", 
                                    Handler = "function() { editNotesField('mSubContractorNotes'); }",
	                                Text = "",
	                                Tooltip = L.__("EDIT_NOTES_TOOLTIP"),
	                                X = 949, Y = 3
                                } %>
                            ]
                        },
                        {
                            id: 'panel26',  // DO NOT REMOVE THIS!!! It is referenced in code above!
                            xtype: 'panel',
                            title: ___('WORK_ORDER_RESULTS'),
                            tabTip: ___('WORK_ORDER_RESULTS'),
                            layout: 'fit',
                            items: [
                                <%= Html.RenderGrid( "FillgrdCallSheetResults", new { ID = "grdWorkOrderResults", Listeners = "grdWorkOrderResultsListeners" }, Model.nCallSheetUID) %>
                            ],
                            bbar: {
                                items: [
									<%= new ExtButton( "CallSheets", "cmdAddWorkOrderResult" ) { 
										IconClass = "btn-add-sm",
										CSSClass = "x-btn-icon", 
										Handler = @"addWorkOrderResultHandler",
										Text = "",
                                        Tooltip = L.__("ADD_WORK_ORDER_RESULT_TOOLTIP"),
                                        Disabled = addResultsDisabled
									} %>,
									<%= new ExtButton( "CallSheets", "cmdDeleteWorkOrderResult" ) { 
										IconClass = "btn-delete-sm",
										CSSClass = "x-btn-icon", 
										Handler = @"deleteWorkOrderResult",
										Text = "",
                                        Tooltip = L.__("DELETE_WORK_ORDER_RESULT_TOOLTIP"),
										Disabled = true
									} %>,
   									<%= new ExtButton( "CallSheets", "cmdViewWorkOrderResult" ) { 
										IconClass = "btn-modify2-sm",
										CSSClass = "x-btn-icon", 
										Handler = @"viewWorkOrderResult",
										Text = "",
                                        Tooltip =L.__("VIEW_WORK_ORDER_RESULT_TOOLTIP"),
										Disabled = true
									} %>,
									<%= new ExtButton( "CallSheets", "cmdModifyWorkOrderResult" ) { 
										IconClass = "btn-modify-sm",
										CSSClass = "x-btn-icon", 
										Handler = @"modifyWorkOrderResult",
										Text = "",
										Tooltip =L.__("EDIT_WORK_ORDER_RESULT_TOOLTIP"),
										Disabled = false
									} %>,
                                    {
                                        xtype: 'splitbutton',
                                        id: 'cmdExternalImport',
                                        tooltip: ___('EXTERNAL_FILE_IMPORT'),
                                        iconCls: 'btn-external-import',
                                        width: 20,
                                        height: 20,
                                        handler: CompassImport,
                                        disabled: isNewRecord,
                                        menu: new Ext.menu.Menu({
                                            items: [
                                                {
                                                    text: ___('COMPASS_IMPORT'),
                                                    handler: function () { CompassImport(); },
                                                    tabTip: ___('COMPASS_IMPORT')
                                                },
                                                {
                                                    text: ___('METTEMPII_IMPORT'),
                                                    handler: function () { METTEMPIIImport(); },
                                                    tabTip: ___('METTEMPII_IMPORT')
                                                },
                                                {
                                                    text: ___('CUBYT_IMPORT'),
                                                    handler: function () { CubytImport(); },
                                                    tabTip: ___('CUBYT_IMPORT')
                                                }
                                            ]
                                        })
                                    },
                                    {
                                        xtype: 'splitbutton',
                                        tooltip: ___('EXPORT_RESULTS'),
                                        iconCls: 'btn-export',
                                        width: 20,
                                        height: 20,
                                        handler: ExportResults,
                                        disabled: isNewRecord || getResultsCount() === 0,
                                        menu: new Ext.menu.Menu({
                                            items: [
                                                {
                                                    text: ___('EXPORT_RESULTS_CURRENT'),
                                                    handler: function () { ExportResults(true); },
                                                    tabTip: ___('EXPORT_RESULTS_CURRENT')
                                                },
                                                {
                                                    text: ___('EXPORT_RESULTS_ALL'),
                                                    handler: function () { ExportResults(false); },
                                                    tabTip: ___('EXPORT_RESULTS_ALL')
                                                }
                                            ]
                                        })
                                    }
                                ]
                            }
                        }
                    ]
                }
            ];
            this.tbar = {
                xtype: 'toolbar',
                border: false,
                frame: false,
                margin: 0,
                padding: 0,
                defaults: {
                    scale: 'large',
                    iconAlign: 'top',
                    cls: 'x-btn-icon-text'
                },
                items: [
					<%= new ExtButton( "CallSheets", "tbFind" ) { 
						Text = L.__("FIND"),
                        Tooltip = L.__("FIND"),
				        IconClass = "tb-find",
				        CSSClass = "x-btn-icon-text", 
                        Disabled = EmxUser.CurrentUser.IsRemoteInstance() || isMetCal,
						Handler = @"doFind"
					} %>,
                    { xtype: 'menuseparator' },
                    {
                        xtype: 'splitbutton',
                        text: ___('PRINT'),
                        tooltip: ___('PRINT'),
                        id: 'tbPrint',
                        iconCls: 'tb-print',
                        disabled: isNewRecord,
                        handler: function () { doPrint("Print"); },
                        menu: new Ext.menu.Menu({
                            items: [
                                {
                                    text: ___('PRINT'),
                                    handler: function () { doPrint("Print"); },
                                    tabTip: ___('PRINT')
                                },
                                {
                                    text: ___('EXPORT'),
                                    handler: function () { doPrint("Export"); },
                                    tabTip: ___('EXPORT')
                                }
                            ]
                        })
                    },
                  
					<%= new ExtButton( "CallSheets", "tbBarcode" ) { 
						Text = L.__("BARCODE"), 
                        Tooltip = L.__("BARCODE"),
						IconClass = "tb-barcode",
						CSSClass = "x-btn-icon-text",
                        Hidden = true
					} %>,
					<%= new ExtButton( "CallSheets", "btnUnlock" ) { 
						Text = L.__("UNLOCK"), 
                        Tooltip = L.__("UNLOCK"),
						IconClass = "tb-unlock",
						CSSClass = "x-btn-icon-text",
                        Handler = @"doUnlock"
					} %>,
                    { xtype: 'menuseparator' },
                    { // print and export report for Cert button in MET/TEAM work order screen. 
                        xtype: 'splitbutton',
                        text: ___('CALLSHEET_CERT_TEXT'),
                        tooltip: ___('CALLSHEET_CERT_TEXT'),
                        id: 'tbCert',
                        iconCls: 'tb-cert',
                        disabled: isNewRecord,
                        handler: function () { doCertPrint("Print"); },
                        menu: new Ext.menu.Menu({
                            items: [
                                {
                                    text: ___('PRINT'),
                                    handler: function () { doCertPrint("Print"); },
                                    id: 'print',
                                    tabTip: ___('PRINT')
                                },
                                {
                                    text: ___('EXPORT'),
                                    handler: function () { doCertPrint("Export"); },
                                    tabTip: ___('EXPORT'),
                                    id: 'export'
                                }
                            ]
                        })
                    },
                    <%= new ExtButton( "CallSheets", "tbAddResult" ) { 
    					Text = L.__("ADD_WORK_ORDER_RESULT"), 
                        Tooltip = L.__("ADD_WORK_ORDER_RESULT_TOOLTIP"),
					    IconClass = "tb-add-result",
					    CSSClass = "x-btn-icon-text",
					    Handler = @"doAddResult",
                        Disabled = addResultsDisabled,
                        Listeners = @"resultsListener"
				    } %>, 
                    <%= new ExtButton() { 
                        ID = "btnShowPartialCal",
                        Text = L.__("CALLSHEET_PARTIAL_CAL_INFO"),
                        Tooltip = L.__("CALLSHEET_PARTIAL_CAL_INFO"),
                        IconClass = "tb-MET_CAL_Classic",
                        CSSClass = "x-btn-icon-text",
                        Handler = @"doShowPartialCalInfo",
                        Disabled = !TagMapModel.HasTagMaps(Model.nCallSheetUID)
                    } %>,
                    { xtype: 'menuseparator' },
					<%= new ExtButton( "CallSheets", "tbBatch" ) { 
						Text =  L.__("CALLSHEET_BATCH_TEXT"), 
                        Tooltip = L.__("CALLSHEET_BATCH_TEXT"),
						IconClass = "tb-process", 
						CSSClass = "x-btn-icon-text",
                        Disabled = isMetCal || isLocked || Model.IsClosed, // disable Batch button for locked WO
						Handler = @"doBatch"
					} %>,
                    { xtype: 'menuseparator' },
					<%= new ExtButton( "CallSheets", "tbGetAmbient" ) { 
						Text =  L.__("GET DATA"), 
                        Tooltip = L.__("GET DATA TOOLTIP"),
						IconClass = "tb-ambient", 
						CSSClass = "x-btn-icon-text",
                        Disabled = Model.IsClosed || DisableAmbientConditions, // disable this button for closed WO or if respective System default is inactive
						Handler = @"ViewAmbientConditions"
					} %>,

                    { xtype: 'menuseparator' },
					<%= new ExtButton( "CallSheets", "tbReturn" ) { 
					    Text = L.__("RETURN"), 
                        Tooltip = L.__("RETURN"),
						IconClass = "tb-return", 
						CSSClass = "x-btn-icon-text",
                        Disabled = (GuidHelper.GuidHandler.IsNewRecord(Model.nCallSheetUID)) || isLocked, 
						Handler = @"doReturn"
					} %>,

                    { xtype: 'menuseparator' },

					<%= new ExtButton( "CallSheets", "tbDelete" ) { 
						Text = L.__("DELETE"), 
                        Tooltip = L.__("DELETE"),
						IconClass = "tb-delete", 
						CSSClass = "x-btn-icon-text",
						Disabled = (GuidHelper.GuidHandler.IsNewRecord(Model.nCallSheetUID)) || isLocked || isMetCal, 
						Handler = "deleteRecord"
					} %>,
                    { xtype: 'menuseparator' },
					<%= new ExtButton( "CallSheets", "tbSave" ) { 
						Text = L.__("SAVE"), 
                        Tooltip = L.__("SAVE"),
						IconClass = "tb-save",
						CSSClass = "x-btn-icon-text", 
						Handler = "this.doSubmit",
						Disabled = true
					} %>,
					<%= new ExtButton( "CallSheets", "tbCancel" ) { 
						Text = L.__("CANCEL"), 
                        IconClass = "tb-cancel",
                        Tooltip = L.__("CANCEL"),
						CSSClass = "x-btn-icon-text",
						Handler = "cancelEdit",
						Disabled = true
					} %>,
                    { xtype: 'menuseparator' },
					<%= new ExtButton( "CallSheets", "tbClose" ) { 
						Text = L.__("CLOSE"),
                        Tooltip = L.__("CLOSE"),
						IconClass = "tb-close", 
						CSSClass = "x-btn-icon-text", 
						Handler = "masterclose"
					} %>
                ]
            };
            editForm.superclass.initComponent.call(this);
        },

        doSubmit: function () {
            // if the user bypasses security by pressing the button before it gets disabled, block it here
            if ('<%:EmxUser.CurrentUser.HasAccess("/Callsheet/Edit/","tbSave")%>' == 'False')
                return;

            var form = Ext.getCmp('edit-form').getForm();

            // Clean up the procedure stuff.
            var proc = Ext.getCmp('nProcedureUID');
            if (proc != undefined) {
                if ($.trim(proc.getValue()) == '')
                    Ext.getCmp('nTypeProcedureDefaultUID').setValue('');
            }

            // bypass prompt to clear signatures in onDataDirtyChanged event handler when validating form data
            bypassClearSignaturesPrompt = true;

            // Performs client-side validation
            if (!form.isValid()) {
                // restore prompt to clear signatures
                bypassClearSignaturesPrompt = false;
                return;
            }

            // restore prompt to clear signatures
            bypassClearSignaturesPrompt = false;

            if (!Ext.getCmp('tMaintNextDate').getValue()) { Ext.getCmp('tMaintNextDate').setValue(null) }
            if (!Ext.getCmp('tMaintDate').getValue()) { Ext.getCmp('tMaintDate').setValue(null) }
            if (!Ext.getCmp('tQCApprovedDate').getValue()) { Ext.getCmp('tQCApprovedDate').setValue(null) }
            if (!Ext.getCmp('tOpenDate').getValue()) { Ext.getCmp('tOpenDate').setValue(null) }
            if (!Ext.getCmp('tDelayDate').getValue()) { Ext.getCmp('tDelayDate').setValue(null) }
            if (!Ext.getCmp('tRequiredDate').getValue()) { Ext.getCmp('tRequiredDate').setValue(null) }

            function actuallySubmit(cUnlockedAnswer) {
                // Indicate busy status to user
                app.showBusyStatus(___('SAVING_WORK_ORDER'), true);

                // Perform Ext form submission via Ajax
                form.submit({
                    url: window.location.toString(),
                    waitMsg: ___('SAVING_WORK_ORDER'),
                    waitTitle: ___('PLEASE_WAIT'),
                    params: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                        ExtendedData: ExtendedData.gatherExtendedData(),
                        isUnlockedFlag: isUnlocked,
                        revisionAnswer: cUnlockedAnswer
                    },
                    success: function (form, action) {
                        app.sendMessage("recordchanged", {
                            table: myTable,
                            id: recordID,
                            sender: editForm
                        });
                        app.setStatus(___('CALLSHEET_WORK_ORDER_RECORD_SAVED_MSG'), true);
                        window.location.reload();
                    },
                    failure: function (form, action) {
                        switch (action.failureType) {
                            case Ext.form.Action.CLIENT_INVALID:
                                app.showError(___('VALIDATION_ERROR_TITLE'), ___('VALIDATION_ERROR_MSG'));
                                break;
                            case Ext.form.Action.CONNECT_FAILURE:
                                app.showError(___('COMMUNICATION_ERROR_TITLE'), ___('COMMUNICATION_ERROR_MSG'));
                                break;
                            case Ext.form.Action.SERVER_INVALID:
                                if (action.result && action.result.errors) {

                                    // If the DataChecks script changed anything in the model,
                                    // the changed data will be in [action.result.model] as 
                                    // JSON data, which will need to be parsed, and the changes
                                    // reflected in the UI.
                                    var changed = JSON.parse(action.result.model);
                                    clientWindow.updateFields(changed);

                                    // The DataCheck validation script may have indicated that it 
                                    // wanted a dialog presented to the user. 
                                    if (action.result.message) {
                                        // Display the dialog, and wait for the close callback before
                                        // continuing with other validation updates
                                        app.showError(___('VALIDATION_ERROR_TITLE'), action.result.message, function () {
                                            // The DataCheck script will indicate which focus should
                                            // get control by setting [action.result.focus]. If that 
                                            // value is set, attempt to set focus to the control with 
                                            // the same ID 
                                            if (action.result.focus) {
                                                clientWindow.setFocus(action.result.focus);
                                            }
                                        });
                                    }

                                }
                                else {
                                    app.showError(___('CALLSHEET_ERROR_SAVING_WORK_ORDER_TITLE'), action.result.message || ___('CALLSHEET_ERROR_SAVING_WORK_ORDER_MSG1'));
                                    app.setStatus(___('CALLSHEET_ERROR_SAVING_WORK_ORDER_MSG2'), true);
                                }
                                break;
                            }
                        }
                    });
                }

                // Check for revision stuff.
                // Prompt if the user wants to revise the work order (if it's just been unlocked)
                // and then send this info to the post.
                if (isUnlocked) {
                    if (setting_workOrderRevisionTracking == "0a" ||
                        setting_workOrderRevisionTracking == "1a" ||
                        setting_workOrderRevisionTracking == "2a") {

                        Ext.Msg.confirm(___("ATTENTION"), ___("REVISE_WO"), function (btn) {
                            actuallySubmit(btn);
                        });
                    } else {
                        actuallySubmit('');
                    }
                } else {
                    actuallySubmit('');
                }
            }
        });

        var form = new editForm();
        Ext.onReady(function () {

            var body = Ext.get(document.body);

            clientWindow.setTitle((isNewRecord ? ___('CALLSHEET_NEW_TITLE') : ___('EDIT_WORK_ORDER')) + ' - ' + Ext.getCmp("cCallSheetNumber").getValue());
            clientWindow.setIcon(isLocked ? "window-icon-locked" : (isUnlocked ? "window-icon-unlocked" : "window-icon-default")); // Show unlock icon for window when workorder is unlocked
            clientWindow.setSize(995, 585);
            clientWindow.center();

		    <% if (Model.nTechnicianUID == null) {
                var user = orx.Models.User.Retrieve(EmxUser.CurrentUser.nUserUID); %>
                Ext.getCmp('nTechnicianUID_display').setValue("<%= user.FullName %>");	// MUST use double-quotes to support names with apostrophes!
                Ext.getCmp('nTechnicianUID').setValue('<%= user.nUserUID %>');
	        <% } %>

            form.render(body);
            editWindow.initForm(form, myTable);

            var tool = clientWindow.windowObj.getTool("audit");
            if (tool)
                isNewRecord ? tool.hide() : tool.show();

            if ('<%=SystemDefault.IsActive(SysDefHelper.WORK_ORDER_ENABLE_COMPASS_DATA_FILE_IMPORT)%>' === 'False') {
                const compassImport = Ext.getCmp("cmdCompassImport");
                if (compassImport !== undefined)
                    compassImport.hide();
            }

            // avoid adding results to a Closed Work Order.
            if (Ext.getCmp("cCallSheetStatus").getValue() == 'Closed') {        
                Ext.getCmp("cmdAddWorkOrderResult").setDisabled(true);
            }

            updateWorkOrderResultsButtons();
            setCertButtonMenu();

            // disable print invoice button when nShipToiUID is null
            if (hasInvoice) {
                var invoiceUID = '<%= Model.nInvoiceUID %>';
                app.getInvoiceFacilityUID(invoiceUID, 'shipTo', function (nShipToUID) {
                    if (nShipToUID == null || nShipToUID == '')
                        Ext.getCmp('btnPrintInvoice').setDisabled(true);
                }, undefined, undefined, "Ship To Address");
            }

            // When right-click visible checkbox is unchecked on the Work Order screen, the Label, Text Box, Quick Link button, and Print button should disappear
            var invoiceLabel = Ext.getCmp('lbl_cInvoiceNo').hidden;
            if (invoiceLabel == true) {
                Ext.getCmp('nInvoiceUID_display').setVisible(false);
                Ext.getCmp('nInvoiceUID_edit').setVisible(false);
                Ext.getCmp('btnPrintInvoice').setVisible(false);
            }

            <% if (Model.tQCApprovedDate != null) { %>
            updateApprovedDate('tQCApprovedDate', new Date('<%= Model.tQCApprovedDate %> UTC'));
            <% } %>

            <% if (Model.tTechnicianApprovedDate != null) { %>
            updateApprovedDate('tTechnicianApprovedDate', new Date('<%= Model.tTechnicianApprovedDate %> UTC'));
            <% } %>

            updateTechnicianSignatureLabels();
            updateQCSignatureLabels();

            // required to ensure Unlock & Return button states are properly set, and other necessary logic is executed
            onDataDirtyChanged();
            nonStatusChangeMade = false;

            clientWindow.windowObj.on("message", function (tag, data) {

                // Do our best to ignore messages that originated in this window
                if (data.sender && data.sender == editForm) {
                    return;
                }

                if (tag === "labelchanged" && data.table === myTable) {
                    var field = editWindow.getField(data.column);
                    if (field) {
                        field.setLabel(data.text);
                    }
                }
                else if (tag === "recordchanged" && data.table === myTable) {
                    if (data.id == recordID) {
                        Ext.Msg.alert(___('RECORD_CHANGED_TITLE'), ___('RECORD_CHANGED_MSG') + '<br/>' + ___('DATA_RELOAD_MSG'));
                        setTimeout(function () { window.location.reload(); }, 5000);
                    }
                }
            });
        });

        // Log Notes are not blue/grey'd out on historical record
        Ext.override(Ext.grid.GridPanel, {
            viewConfig: {
                //Return CSS class to apply to rows depending upon data values
                getRowClass: function (record, index) {
                    if (isLocked) {
                        return 'readonly';
                    }
                }
            }
        });

        // set bgcolor blue if work order is closed
        Ext.override(Ext.form.TextArea, {
            style: (isLocked) ? "background:#C9DDF2;" : ""
        });

    </script>
</asp:Content>
