<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Edit.Master" Inherits="System.Web.Mvc.ViewPage<orx.Models.ManualTemplate>" %>

<%@ Import Namespace="orx.Helpers" %>
<%@ Import Namespace="orx" %>
<%@ Import Namespace="orx.Models" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" runat="server">

    <!-- Include the custom grid styles that are used only here. -->

    <style type="text/css">
    .row-type-0 {
        background-color: rgb(242, 242, 242) !important;
    }

    .row-type-1 {
        background-color: rgb(255, 255, 255) !important;
    }

    .row-type-2 {
        background-color: rgb(235, 213, 199) !important;
    }

    .row-type-3 {
        background-color: rgb(248, 250, 215) !important;
    }

    .green-cell {
        background-color: green !important;
    }

    .red-cell {
        background-color: red !important;
        color: white;
    }

    .cell-disabled {
        opacity: 1;
        background-color: #E9EFF5 !important;
        color: white;
    }

    .x-grid3-cell-inner {
        font-family: Verdana;
        color: black;
        font-size: xx-small;
        margin: 5px;
    }

    .x-grid3-header .x-grid3-cell {
        /* Note: this fixes a bug (seemingly with the ExtJS framework?) which
			   causes the columns to drift apart. */
        padding-left: 1px !important;
    }

    .x-grid3-cell {
    }

    .x-grid3-cell {
    }

    .x-grid3-col {
        border-right: 1px solid lightgray !important;
        border-bottom: 1px solid lightgray;
    }

    .disabledCell {
        background-color: lightgray !important;
    }

  </style>

    <!-- Include our script about the manual template plugins. -->
    <script type="text/javascript" src="/Scripts/ManualTemplate.js"></script>

    <!-- Page-Specific JS -->
    <script type="text/javascript">

        var myTable = 'ManualTemplates';
        var recordID = '<%: Model.PrimaryKey %>';
        var isNewRecord = <%: GuidHelper.AspxGuidHandler.IsNewRecord(Model.PrimaryKey) %>;
        var templateInUse = ('<%: ManualTemplateHelper.IsTemplateInUse(Model.PrimaryKey) %>' == 'True');

        // MTM-4810
        var isTransducer = <%: Model.lIsTransducer == 0 ? "false" : "true" %>;

        // Note this random "control field" declaration is used
        // so we can access some of its nifty number methods.
        var numeric = new Ext.ux.NumericField();

        // Instantiate our MMC helper class.
        // (defined in /Scripts/ManualTemplate.js)
        var mmc = new MMC();

        // Wizards
        var pWizard;
        var pWizardTransducer;

        // Update formula UI
        var pUpdateForml;

        // Context menus
        var ctxMenu;
        var ctxMenu_Basic;

        // Formula flag, row-level
        var hasFormula;

        var _msgWaitForTemplate;
        function ShowWaitForTemplate() {
            _msgWaitForTemplate = Ext.MessageBox.show({
                title: '<%=L.__("PLEASE_WAIT")%>',
                msg: '<%=L.__("LOADING_TEMPLATE") %>' + "...",
                width: 300,
                wait: true,
                waitConfig: { interval: 50 }
            });
        }

        function HideWaitForTemplate() {
            if (_msgWaitForTemplate !== undefined) {
                try { _msgWaitForTemplate.hide(); } catch (error) { }
            }
        }

        function trim(val) {
            val = val || '';
            for (var i = 0; i < val.length; i++) {
                if (val[i] == ' ')
                    val = val.substr(1);
                else
                    break;
            }

            for (var i = val.length; i > 0; i--) {
                if (val[i] == ' ')
                    val = val.substr(0, val.length - 1);
                else
                    break;
            }
            return val;
        }

        // Define the renderer functions.
        // *******************************************
        function setVal(record, colIndex, value) {
            var field = Ext.getCmp('grdEditor').getStore().fields.items[colIndex].name;
            record.set(field, value);
        }

        function getColIndex(colName) {
            return Ext.getCmp('grdEditor').getColumnModel().findColumnIndex(colName);
        }

        // This is the "master" renderer which should be called by almost all of the columns, 
        // in some capacity.
        function superRenderer(value, meta, record, row, col) {

            if (col == getColIndex('nUpperLimit') || col == getColIndex('nLowerLimit')) {
                if (record.get('WizardFormula') !== undefined) {
                    meta.css = "disabledCell";
                    return value;
                }
            }

            // Get the row type that has been selected for this record.
            var rowType = record.get('nRowType');
            // Check if the column we are trying to render should be disabled or not.
            if (mmc.isDisabled(rowType, row, col)) {
                // If it should be disabled, apply the proper class.
                meta.css = "cell-disabled";
                return "";
            }
            else if (col % 2 == 1)
                // This is to alternate row colors
                meta.css = "row-type-1";
            else
                meta.css = "row-type-0";

            // MTM-4766
            if ((rowType == t_RowType["<= Limit"] || rowType == t_RowType["<= Limit (!)"]) && col == 9) {
                value = "";
                // MTM-4766
            } else if ((rowType == t_RowType[">= Limit"] || rowType == t_RowType[">= Limit (!)"]) && col == 10) {
                value = "";
            }

            return value;
        }

        // This is the generic "string" renderer. It is meant to be used on string
        // fields.
        function strRowRenderer(value, meta, record, rowIndex, colIndex) {
            meta.css = "row-type-0";
            // Grab the requested resolution.
            var resolution = record.get('nResolution');

            // Call the "parent" function.
            var value = superRenderer(value, meta, record, rowIndex, colIndex);
            if (meta.css == "cell-disabled") return "";

            // Now do the resolution fix.
            return numeric.formatNumberLocale(mmc.applyResolution(value, resolution)).toString();

        }

        // MTM-4535
        // This is the a renderer for description and label columns only
        function labelRenderer(value, meta, record, rowIndex, colIndex) {
            meta.css = "row-type-1";

            // Get the row type that has been selected for this record.
            var rowType = record.get('nRowType');
            // Check if the column we are trying to render should be disabled or not.
            if (mmc.isDisabled(rowType, rowIndex, colIndex)) {
                // If it should be disabled, apply the proper class.
                meta.css = "cell-disabled";
                return "";
            }

            return value;
        }

        // MTM-4230 render TUR values
        // This is the renderer for the TUR column. Although the underlying element may
        // be a "text" box, the formatting will be processed by this method.
        function turRowRenderer(value, meta, record, rowIndex, colIndex) {
            meta.css = "row-type-1";

            // Call the "parent" function.
            value = superRenderer(value, meta, record, rowIndex, colIndex);
            if (meta.css == "cell-disabled") return "";
            if (value == null || value == 0) return "";  //MTM-4247: leave empty for null value

            return numeric.formatNumberLocale(value);
        }

        // MTM-7303 disabled for now
	    <%--		// MTM-4247 render Uncertainty values
		function uncRowRenderer( value, meta, record, rowIndex, colIndex ) {
		    meta.css = "row-type-1";

		    // MTM-6902 - Code changes to render nUncertainty 
		    var isActive = '<%= SystemDefault.IsActive(SysDefHelper.UNCERT_SIGN_DIGITS).ToString().ToLower() %>';
		    var resolution = 2;

		    if (isActive === 'true') {
		        var systemDefaultValue = '<%= SystemDefault.GetValue(SysDefHelper.UNCERT_SIGN_DIGITS, "") %>';
		        resolution = systemDefaultValue;
		    }
			
		    // Call the "parent" function.
		    value = superRenderer(value, meta, record, rowIndex, colIndex);
		    if ( meta.css == "cell-disabled" )  return "";
		    if (value == null || value == 0) return "";  //leave empty for null value

		    return numeric.formatNumberLocale(mmc.applyResolution(value,resolution)); // MTM-6902 - Code added to render digits after the decimal point for Uncertainty
		}--%>

        // This is the generic "number" renderer. Although the underlying element may
        // be a "text" box, the formatting will be processed by this method.
        function numRowRenderer(value, meta, record, rowIndex, colIndex) {
            meta.css = "row-type-1";
            // Grab the requested resolution.
            var resolution = record.get('nResolution');

            // Call the "parent" function.
            value = superRenderer(value, meta, record, rowIndex, colIndex);
            if (meta.css == "cell-disabled") return "";

            // Use our MMC math functions to apply the resolution
            // to the value we want to render.
            return numeric.formatNumberLocale(mmc.applyResolution(value, resolution));
        }

        function rowCheckBoxRender(value, meta, record, rowIndex, colIndex) {
            if (parseFloat(value || 0) == 0) {
                record.set('lUUTIsSource', 0);
                return ___("NO");
            } else {
                record.set('lUUTIsSource', -1);
                return ___("YES");
            }
        }

        // This is the renderer for transducer fields
        function transducerRenderer(value, meta, record, rowIndex, colIndex) {
            meta.css = "row-type-3";

            // Grab the requested resolution.
            var resolution = record.get('nResolution');

            // Call the "parent" function.
            value = superRenderer(value, meta, record, rowIndex, colIndex);
            if (meta.css == "cell-disabled") return "";

            // Use our MMC math functions to apply the resolution
            // to the value we want to render.
            return numeric.formatNumberLocale(mmc.applyResolution(value, resolution));
        }

        function unitRenderer(value, meta, record, rowIndex, colIndex) {
            meta.css = "row-type-1";
            return superRenderer(mmc.getUnitDisplay(value), meta, record, rowIndex, colIndex);
        }

        // This is the "Row Type" renderer. It is specifically meant to be used 
        // by the column with a dropdown box. (of which there is only 1)
        function rowTypeRenderer(value, meta, record, rowIndex, colIndex) {
            value = t_RowType.getDisplay(value);
            // (Note we don't call the "parent" renderer because this field
            // should never be disabled or really modified).
            return value;
        }

        // This is meant to be used with the "Resolution" column.
        function resolutionRowRenderer(value, meta, record, rowIndex, colIndex) {
            meta.css = "row-type-2";

            value = numeric.formatNumberEN(value);

            // Call the "parent" renderer.
            return superRenderer(value, meta, record, rowIndex, colIndex);
        }

        // This function is called automatically whenever the DataDirty state changes
        function onDataDirtyChanged() {
            // Check if data is dirty.
            var dirty = editWindow.getDataDirty();


            // Assign the disabled accordingly.
            Ext.getCmp('btnFind').setDisabled(dirty);
            Ext.getCmp('btnAdd').setDisabled(true); //MTM-8815 to disable add button.
            Ext.getCmp('btnCopy').setDisabled(true);	//MTM-9097
            Ext.getCmp('btnDelete').setDisabled(true); // MTM-9149 - added code to disable the Delete button.			
            Ext.getCmp('btnSave').setDisabled(!dirty);
            Ext.getCmp('btnCancel').setDisabled(!dirty || getQueryString()["isCopy"] === "true");
            if (!isNewRecord) {
                Ext.getCmp('btnAdd').setDisabled(dirty);//MTM-8815 to disable add button.
                Ext.getCmp('btnCopy').setDisabled(dirty);	//MTM-9097
                Ext.getCmp('btnDelete').setDisabled(dirty); // MTM-9149 - added code to disable the Delete button.
            }
        }

        // Reload the Designer Grid.
        // [deep] - If true, the grid will completely
        // remove all records and then re-load everything.
        //			If false, the grid will simply update
        // the UIDs for each record, assuming they all match.
        function doReloadGrid(deep) {

            // Can't update if there is no valid template uid!
            if (isNewRecord) return;

            // MTM-1486
            ShowWaitForTemplate();

            // JS DoEvents
            window.setTimeout(function () {

                // Get some variables.
                var grid = Ext.getCmp('grdEditor');
                var store = grid.getStore();

                // Make the ajax request.
                $.ajax({
                    url: '/ManualTemplate/GetTemplateRows/' + recordID,
                    data: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                    },  
                    type: 'post',
                    dataType: 'json',
                    async: false,
                    success: function (results) {
                        // Do the different kinds of things.
                        if (deep) {

                            var result = {};
                            var formulae = {};

                            // Iterate
                            for (var i = 0; i < results.length; i++) {

                                grid.addRow();

                                result[i] = results[i]['ManualTemplateRow'];
                                formulae[i] = results[i]['ManualTemplateRowTolerance'];

                                // Update the row
                                for (var prop in result[i]) {
                                    if (result[i].hasOwnProperty(prop)) {
                                        // Update the row
                                        try {
                                            if (!isNaN(result[i][prop]) && !isNaN(parseFloat(result[i][prop])) && prop !== 'cStep')
                                                store.getAt(i).set(prop, parseFloat(result[i][prop]));
                                            else
                                                store.getAt(i).set(prop, result[i][prop]);
                                        } catch (ex) { }
                                    }

                                    // Clear those annoying red flags.
                                    store.getAt(i).commit(true);
                                }

                                if (formulae[i]) {
                                    store.getAt(i).set('WizardFormula', JSON.stringify(formulae[i]));
                                }

                                store.getAt(i).commit(true);
                            }
                        } else {

                            function find(nOrdinal) {
                                for (var i = 0; i < result.length; i++) {
                                    if (result[i].nOrdinal === nOrdinal)
                                        return i;
                                }
                            }

                            store.each(function (item) {
                                try {
                                    var index = find(item.get('nOrdinal'));
                                    item.set('nManualTemplateRowUID', result[index].nManualTemplateRowUID);
                                } catch (ex) { }
                            });
                        }

                        Ext.getCmp('btnTransducer').toggle(isTransducer, false);

                        if (getQueryString()["isCopy"] === "true") {
                            recordID = '<%= GuidHelper.KnownGuids.GuidNewRecord %>'; // MTM-7919
                            editWindow.setDataDirty();
                        }
                        else
                            editWindow.clearDataDirty();
                    }
                });
            }, 200)      // .2s


            // MTM-1486
            window.setTimeout(function () {
                HideWaitForTemplate();
            }, 200)      // .2s
        }

        function isRowValid(rowType, nominal, low, high, unitUID, res, refNominal) {

            function msg(success, msg) {
                return {
                    success: success,
                    msg: msg
                };
            }

            // Turn everything into actual numbers.
            nominal = parseFloat(nominal);
            low = parseFloat(low);
            high = parseFloat(high);

            // MTM-5162
            refNominal = parseFloat(refNominal);

            // Basic data entry.
            // MTM-5162
            if (rowType == 1 || rowType == 2 || rowType == 3 || rowType == 10 || rowType == 11 || rowType == 12) {
                if (isNaN(nominal)) return msg(false, ___('ENTER_VALID_NOMINAL_VALUE'));
                if ((rowType != 2 && rowType != 11) && isNaN(low)) return msg(false, ___('ENTER_VALID_LOWER_LIMIT'));
                if ((rowType != 3 && rowType != 12) && isNaN(high)) return msg(false, ___('ENTER_VALID_UPPER_LIMIT'));
                if ((rowType == 10 || rowType == 11 || rowType == 12) && isNaN(refNominal)) return msg(false, ___('ENTER_VALID_REF_NOMINAL_VALUE'));
            }


            // MTM-3790
            if (res != null) {
                // negative resolution is invalid
                var testRes = Math.abs(res);

                // floor for pos values is equivalent to truncating fractions - needs to be int
                testRes = Math.floor(testRes);

                if (testRes !== res)
                    return msg(false, ___('RES_MUST_BE_POS_INT'));
                //
            }

            switch (rowType) {
                // MTM-5162
                case 10:
                case 1:
                    // Check if lower is greater than higher.
                    // Check if higher is lesser than lower.
                    // Check if nominal is within the range.
                    if (low > high)
                        return msg(false, ___('LOWER_LIMIT_MUST_BE_SMALLER'));
                    if (high < low)
                        return msg(false, ___('UPPER_LIMIT_MUST_BE_GREATER'));
                    // MTM-5162
                    if (rowType == 1) {
                        if (nominal > high || nominal < low)
                            return msg(false, ___('NOMINAL_NOT_IN_RANGE'));
                    }
                    else {
                        if (refNominal > high || refNominal < low)
                            return msg(false, ___('REF_NOMINAL_NOT_IN_RANGE'));
                    }
                    break;
                // MTM-5162
                case 11:
                    if (refNominal > high)
                        return msg(false, ___('REF_NOMINAL_NOT_BELOW_LIMIT'));
                    break;
                case 2:
                    // Less than limit.
                    // Check if Nominal is less than the upper limit.
                    if (nominal > high)
                        return msg(false, ___('NOMINAL_NOT_BELOW_LIMIT'));
                    break;
                // MTM-5162
                case 12:
                    // Greater than limit.
                    // Check if Nominal is greater than the lower limit.
                    if (refNominal < low)
                        return msg(false, ___('REF_NOMINAL_NOT_ABOVE_LIMIT'));
                    break;
                case 3:
                    // Greater than limit.
                    // Check if Nominal is greater than the lower limit.
                    if (nominal < low)
                        return msg(false, ___('NOMINAL_NOT_ABOVE_LIMIT'));
                    break;
            }

            return msg(true);
        }

        // Do a basic validation.
        function isBasicallyValid() {

            var cTemplateName = Ext.getCmp('cTemplateName').getValue();
            if (cTemplateName == '' || cTemplateName == undefined) {
                Ext.getCmp('tabPanel1').setActiveTab(0);

                //MTM-4434 do not display a message since that would be a one-off
                //Ext.Msg.alert(___("ATTENTION_TITLE"), ___("PLEASE_SUPPLY_TEMPLATE_NAME"), function () {
                //    Ext.getCmp('cTemplateName').focus();
                //});
                return false;
            }

            // MTM-7527 : Validate form for all Required fields
            var valid = Ext.getCmp('edit-form').getForm().isValid();
            if (!valid) {
                return;
            }

            var grid = Ext.getCmp('grdEditor');
            var store = grid.getStore();
            var errors = [];

            var index = 0;
            for (var i = 0; i < store.getCount(); i++) {

                var record = store.getAt(i);
                var rowType = record.get('nRowType');
                var nominal = record.get('cNominal');
                if (!nominal)  //MTM-4358: able to save after "Add Row"
                    nominal = 0;
                var low = record.get('nLowerLimit');
                var high = record.get('nUpperLimit');
                var unitUID = record.get('nNominalUnitUID');
                var res = record.get('nResolution');
                // MTM-5162
                var refNominal = record.get('cRefNominal');
                var msg = isRowValid(rowType, nominal, low, high, unitUID, res, refNominal);

                if (msg.success == false) {
                    var row = $(".x-grid3-row").eq(i);
                    row.fadeOut(250);
                    Ext.getCmp('tabPanel1').setActiveTab(1);
                    row.fadeIn(350, function () {
                        Ext.Msg.alert(___("ATTENTION_TITLE"), ___("STEP") + " " + record.get('cStep') + " - " + msg.msg);
                    });
                    return false;
                }
            }

            return true;
        }

        function doFindAction() {

            var findWindow = app.openWindow({
                title: 'Find Manual Templates',
                url: '<%: Url.Content( "~/Shared/Find" ) %>',
                modal: true,
                callbacks: {
                    context: 'FindManualTemplates',
                    controller: 'ManualTemplates',
                    onRecordSelected: function (record) {

                        // Open the edit window, passing in the selected record identifiers.                    
                        window.location.assign('/ManualTemplate/Edit/' + record.get('UID'));

                        // MTM-6453 - To get rid of IE exceptions and closing this find window once everything is done
                        // Close the find dialog.
                        findWindow.close();

                    }
                }
            });

        }

        function doCopyAction() {
            var actionUrl = '/ManualTemplate/Edit/' + recordID + '/?isCopy=true';
            app.openWindow({
                url: actionUrl,
                width: 1010,
                height: 525,
                resizable: false,
                minimizable: true,
                maximizable: false,
                auxColor: true
            });
        }

        function doAddAction() {
            window.location.assign('/ManualTemplate/Edit/' + '<%= GuidHelper.KnownGuids.GuidStringNewRecord %>');
        }

        function doDeleteAction() {
            Ext.Msg.confirm(___('DELETE_RECORD_TITLE'), ___('DELETE_RECORD_MSG'), function (btn) {

                // If they don't answer yes, break out.
                if (btn != "yes") return;

                // If they do answer yes, then continue
                var actionUrl = '/ManualTemplate/Delete/';

                // Make the centralized framework call.
                app.call({
                    url: actionUrl,
                    contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                    data: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                        id: recordID
                    },
                    success: function (result) {

                        // Alert the user to the result message in the bottom toolbar
                        app.showBusyStatus(result.message, true);

                        // Check if there were problems deleting the record
                        if (!result.success) {
                            // Pop up a message with the results.
                            Ext.Msg.alert(___('ATTENTION_TITLE'), result.message, function () { });
                        } else {
                            // Navigate to the find.
                            // Close the window and open the find screen.
                            var findWindow = app.openWindow({
                                title: 'Find Manual Template',
                                url: '/Shared/Find',
                                modal: true,
                                callbacks: {
                                    context: "FindManualTemplates",
                                    controller: "ManualTemplate"
                                }
                            });

                            // Close our parent screen
                            clientWindow.close();
                        }
                    },
                    error: function (err) {
                        debugger;
                        Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNKNOWN_ERROR_MSG'));
                    }
                }); // Close the app.call function.
            }); // Close the question
        }

        function doTransducer(btn, pressed) {
            // MTM-4810
            isTransducer = pressed;

            // Set data dirty.
            editWindow.setDataDirty();

            // Enable/Disable the proper columns.
            var grid = Ext.getCmp('grdEditor');
            var cmodel = grid.getColumnModel();

            // Check what they should be.
            cmodel.setHidden(cmodel.findColumnIndex('cRefNominal'), !pressed);
            cmodel.setHidden(cmodel.findColumnIndex('nRefUnitUID'), !pressed);

            // MTM-4766 validate all row types
            if (!pressed) {
                var store = grid.getStore();
                var invalid = 0;
                store.each(function (item) {
                    var rowType = item.get('nRowType');
                    switch (rowType) {
                        case 10:
                        case 11:
                        case 12:
                            invalid++;
                            item.set('nRowType', rowType - 9);  // default to same row type without "(!)"
                    }
                });
                if (invalid > 0) {
                    Ext.MessageBox.alert(___('Invalid_Row_Type_Title'), ___('Invalid_Row_Type_Changed_Msg'));
                }
            }

            // MTM-4414 Allow nominal value adjustment is not applicable to Transducer templates!
            var chk = Ext.getCmp('lAllowActual');
            chk.setDisabled(pressed);
            if (pressed)
                chk.setValue(false);

        }

        function doCancelAction() {
            window.location.assign(window.location.toString());
        }

        function doCloseAction() {
            clientWindow.close();
        }

        function getIsTemplateInUse() {
            return templateInUse;
        }

        // opens step wizard window
        function stepWizard() {
            var grid = Ext.getCmp('grdEditor');
            pWizard = new PrimaryWizard({
                grid: grid
            });

            pWizard.show();
            pWizard = null;
        }

        // opens step Transducer wizard window
        function stepTransducerWizard() {
            var grid = Ext.getCmp('grdEditor');
            pWizardTransducer = new PrimaryWizard({
                grid: grid,
                transducer: true
            });        

            pWizardTransducer.show();
            pWizardTransducer = null;
        }

        // opens the update formula window
        function doUpdateFrml(row) {

            var grid = Ext.getCmp('grdEditor');
            var record = grid.getStore().getAt(row);
            var formula = {};
            var tol = record.get('WizardFormula');
            if (tol)
                formula = JSON.parse(tol);

            var nominal = record.get('cNominal') || '';
            var unit = mmc.getUnitDisplay(record.get('nNominalUnitUID') || '<%: GuidHelper.KnownGuids.GuidStringUnitsBlank %>');
            var unitUID = record.get('nNominalUnitUID') || '<%: GuidHelper.KnownGuids.GuidStringUnitsBlank %>';
            var outputUnit = unit;

            // xducer
            var refNominal = record.get('cRefNominal') || '';
            var refUnit = mmc.getUnitDisplay(record.get('nRefUnitUID') || '<%: GuidHelper.KnownGuids.GuidStringUnitsBlank %>');

            pUpdateForml = new UpdateFormula({
                grid: grid,
                row: row,
                transducer: isTransducer,
                resolution: record.get('nResolution') || '',
                nominal: nominal,
                unit: unit,
                unitUID: unitUID,       // needed for updating the description
                refNominal: refNominal,
                refUnit: refUnit,
                outputUnit: outputUnit,
                formula: formula
            });

            pUpdateForml.show();
            pUpdateForml = null;
        }

        function doDeleteFormula(row) {
            var grid = Ext.getCmp('grdEditor');
            var record = grid.getStore().getAt(row);
            record.set('WizardFormula', null);
            doSetDataDirty();
        }

        function tryGet(key) {
            var obj = Ext.getCmp(key);
            if (obj !== undefined)
                return obj.getValue();
            return "";
        }

        function getPackage() {
            var grid = Ext.getCmp('grdEditor');
            var store = grid.getStore();

            // Collect all the rows.
            var rows = grid.getStore().data;
            var records = [];
            for (var i = 0; i < rows.length; i++) {
                // Update the ordinal.
                var row = store.getAt(i);

                // MTM-4810
                if (!isTransducer) {
                    row.set('cRefNominal', '');
                    row.set('nRefUnitUID', '<%: GuidHelper.KnownGuids.GuidStringUnitsBlank %>');
                }

                row.set('nOrdinal', i);

                var f = row.get('WizardFormula');
                if (f) {
                    try {
                        var formula = JSON.parse(f);
                        row.set('WizardFormula', formula);
                    }
                    catch (e) {
                        // value was likely already parsed and set from previous save attempt/failure
                    }
                }

                // Build the record item.
                records[records.length] = row.data;

                // MTM-5523 make sure cNominal and cRefNominal are actually stored as strings before saving!
                // MTM-5696 check for null values is so consider as a empty string
                records[records.length - 1].cNominal = (records[records.length - 1].cNominal == null) ? "" : records[records.length - 1].cNominal.toString();
                records[records.length - 1].cRefNominal = (records[records.length - 1].cRefNominal == null) ? "" : records[records.length - 1].cRefNominal.toString();
            }

            // Now we have the collection of records, so create the rest of the packet to send.
            var savePacket = {
                nManualTemplateUID: recordID,
                cTemplateName: tryGet('cTemplateName'),
                mNotes: tryGet('mNotes'),
                lActive: tryGet('lActive') ? -1 : 0,
                // MTM-4414
                lAllowActual: tryGet('lAllowActual') ? -1 : 0,
                // MTM-4810
                lIsTransducer: isTransducer ? -1 : 0,

                Records: records
            };

            return savePacket;
        }

        editForm = Ext.extend(Ext.form.FormPanel, {

            id: 'edit-form',
            url: window.location,
            frame: false,
            hideBorders: true,
            labelWidth: 120,
            labelAlign: 'top',
            layout: 'fit',
            //height: 400,
            defaults: {
                msgTarget: 'side'
            },
            listeners: {
                afterrender: function (self) {
                    // KW 01/15/2014 - MTM-4162 - Attempt to resize
                    var resizeProxy = function () {
                        var notes = Ext.get('mNotes');
                        var doc = Ext.get(document.body);
                        var pos = self.getPosition();
                        var width = doc.getWidth() - pos[0];
                        var height = doc.getHeight(); //MTM:9048 Code changes done to fix gray screen issue in Manual Template screen.
                        self.setSize(width, height);
                        notes.setSize(width - 23, height - 236);

                        var name = Ext.get('cTemplateName');
                        name.setWidth(width - 23);
                    }
                    Ext.EventManager.onWindowResize(resizeProxy, self);
                    resizeProxy();
                }
            },
            initComponent: function () {
                this.items = [
                    {
                        xtype: 'panel',
                        hideCollapseTool: true,
                        layout: 'fit',
                        frame: false,
                        hideBorders: true,
                        items: [

                            new Ext.TabPanel({
                                id: 'tabPanel1',
                                activeTab: 0,
                                items: [
                                    new Ext.Panel({

                                        title: ___('Template'),
                                        tabTip: ___('Template'),
                                        layout: 'absolute',
                                        width: 900,
                                        height: 500,
                                        items: [
                                            <%= Html.Field(w => Model.lActive, new { X = 10, Y = 10 }) %>
                                            ,<%= Html.Field(w => Model.lAllowActual, new { X = 10, Y = 30 }) %>											
                                            ,<%= Html.Label(w => Model.cTemplateName, new { X = 10, Y = 60 })%>
                                            ,<%= Html.Field(w => Model.cTemplateName, new { X = 10, Y = 80, Width = 850 }) %>
                                            ,<%= Html.Label(w => Model.mNotes, new { X = 10, Y = 110 }) %>
                                            ,<%= Html.Field(w => Model.mNotes, new { X = 10, Y = 130, Width = 850, Height = 200 }) %>
                                        ]
                                    }),
                                    new Ext.Panel({
                                        title: ___('Template Design'),
                                        tabTip: ___('Template Design'),
                                        layout: 'fit',
                                        items: [

                                            new Ext.grid.ExcelGrid({
                                                id: 'grdEditor',
                                                width: 903,
                                                height: 300,
                                                defaultLogic: true,
                                                store: new Ext.data.JsonStore({
                                                    fields: ['lUUTIsSource', 'nManualTemplateRowUID', 'cDescription', 'cLabel', 'cNominal', 'cRefNominal', { name: 'cStep', sortType: 'asInt' }, 'nNominalUnitUID', 'nRefUnitUID', 'nUncertainty', 'nLowerLimit', 'nOrdinal', 'nResolution', 'nRowType', 'nTur', 'nUpperLimit']
                                                }),
                                                colModel: new Ext.grid.ColumnModel({
                                                    columns: [
                                                        { header: ___('Source'), dataIndex: 'lUUTIsSource', width: 55, renderer: rowCheckBoxRender, editor: new Ext.form.CheckboxEditor() },
                                                        { header: ___('Step #'), dataIndex: 'cStep', width: 60, renderer: labelRenderer, sortable: true, editor: new Ext.form.BasicEditor() },
                                                        { header: ___('Description'), dataIndex: 'cDescription', width: 200, renderer: labelRenderer, editor: new Ext.form.TextField({ listeners: { change: function () { editWindow.setDataDirty(); } } }) },

                                                        // MTM-4370
                                                        { header: ___('Label'), dataIndex: 'cLabel', width: 100, renderer: labelRenderer, editor: new Ext.form.TextField({ listeners: { change: function () { editWindow.setDataDirty(); } } }) },

                                                        // MTM-4040 Do we need to do anything here???
                                                        {
                                                            header: ___('Row Type'), dataIndex: 'nRowType', fixed: true, width: 150, renderer: rowTypeRenderer, editor: new Ext.form.RowType({
                                                                listeners: {
                                                                    focus: function (self) {
                                                                        var grid = Ext.getCmp('grdEditor');
                                                                        var pos = grid.getSelectionModel().getSelectedCell();
                                                                        self.row = pos[0];
                                                                    },
                                                                    change: function (self) {
                                                                        var grid = Ext.getCmp('grdEditor');
                                                                        var pos = grid.getSelectionModel().getSelectedCell();
                                                                        var record = grid.getStore().getAt(self.row);
                                                                        switch (self.getValue()) {

                                                                            case t_RowType["Blank"]:
                                                                            case t_RowType["Checkbox"]:
                                                                            case t_RowType["Y = Pass"]:
                                                                            case t_RowType["Y = Fail"]:
                                                                            case t_RowType["Report Label"]:
                                                                            case t_RowType["Bold Label"]:
                                                                            case t_RowType["Enter Text"]:

                                                                                // Reset all the values.
                                                                                try {                                                                                    
                                                                                    record.set('nResolution', 2);
                                                                                    record.set('nNominalUnitUID', '<%: GuidHelper.KnownGuids.GuidStringUnitsBlank %>');
                                                                                    record.set('nRefUnitUID', '<%: GuidHelper.KnownGuids.GuidStringUnitsBlank %>');
                                                                                    record.set('cNominal', '0');
                                                                                    record.set('cRefNominal', '0');
                                                                                    record.set('nUpperLimit', ''); // MTM-7673 - do not set to 0 here for the above rowTypes
                                                                                    record.set('nLowerLimit', ''); // MTM-7673 - do not set to 0 here for the above rowTypes
                                                                                    record.set('WizardFormula', null);
                                                                                } catch (ex) { }
                                                                                break;
                                                                            // MTM-4766
                                                                            case t_RowType["Inside Limit (!)"]:
                                                                                if (!isTransducer) {
                                                                                    Ext.MessageBox.alert(___('Invalid_Row_Type_Title'), ___('Invalid_Row_Type_Msg'));
                                                                                    self.setValue('Blank');
                                                                                }
                                                                                break;
                                                                            case t_RowType["<= Limit (!)"]:
                                                                                if (!isTransducer) {
                                                                                    Ext.MessageBox.alert(___('Invalid_Row_Type_Title'), ___('Invalid_Row_Type_Msg'));
                                                                                    self.setValue('Blank');
                                                                                }
                                                                                try {
                                                                                    record.set('nLowerLimit', '');
                                                                                    record.set('WizardFormula', null);
                                                                                } catch (ex) { }
                                                                                break;
                                                                            case t_RowType[">= Limit (!)"]:
                                                                                if (!isTransducer) {
                                                                                    Ext.MessageBox.alert(___('Invalid_Row_Type_Title'), ___('Invalid_Row_Type_Msg'));
                                                                                    self.setValue('Blank');
                                                                                }
                                                                                try {
                                                                                    record.set('nUpperLimit', '');
                                                                                    record.set('WizardFormula', null);
                                                                                } catch (ex) { }
                                                                                break;
                                                                            case t_RowType["<= Limit"]:
                                                                                try {
                                                                                    record.set('nLowerLimit', '');
                                                                                    record.set('WizardFormula', null);
                                                                                } catch (ex) { }
                                                                                break;
                                                                            case t_RowType[">= Limit"]:
                                                                                try {
                                                                                    record.set('nUpperLimit', '');
                                                                                    record.set('WizardFormula', null);
                                                                                } catch (ex) { }
                                                                                break;
                                                                        }
                                                                    }
                                                                }
                                                            })
                                                        },

                                                        // Source Type
                                                        { header: ___('Ref Nominal'), dataIndex: 'cRefNominal', hidden: true, width: 80, renderer: transducerRenderer, editor: new Ext.form.BasicEditor() },// MTM-5138 - Increased column width
                                                        {
                                                            header: ___('Ref Units'), dataIndex: 'nRefUnitUID', hidden: true, width: 80, renderer: unitRenderer, editor: new Ext.form.UnitCombo({
                                                                onAddUnit: function (value, display) {
                                                                    mmc.LoadUnits();
                                                                    var grid = Ext.getCmp('grdEditor');
                                                                    grid.mmc.LoadUnits();
                                                                    var pos = grid.getSelectionModel().getSelectedCell();
                                                                    grid.startEditing(pos[0], pos[1] - 1);
                                                                    grid.getStore().getAt(pos[0]).set('nRefUnitUID', value);
                                                                    grid.stopEditing(false);
                                                                }
                                                            })
                                                        },

                                                        // Everything else.
                                                        { header: ___('Nominal'), dataIndex: 'cNominal', width: 70, renderer: strRowRenderer, editor: new Ext.form.BasicEditor() }, // MTM-5138 - Increased column width
                                                        {
                                                            header: ___('Unit'), dataIndex: 'nNominalUnitUID', width: 60, renderer: unitRenderer, editor: new Ext.form.UnitCombo({
                                                                onAddUnit: function (value, display) {
                                                                    mmc.LoadUnits();
                                                                    var grid = Ext.getCmp('grdEditor');
                                                                    grid.mmc.LoadUnits();
                                                                    var pos = grid.getSelectionModel().getSelectedCell();
                                                                    grid.startEditing(pos[0], pos[1] - 1);
                                                                    grid.getStore().getAt(pos[0]).set('nNominalUnitUID', value);
                                                                    grid.stopEditing(false);
                                                                }
                                                            })
                                                        },
                                                        { header: ___('Low Limit'), dataIndex: 'nLowerLimit', width: 70, renderer: numRowRenderer, editor: new Ext.form.BasicEditor() },
                                                        { header: ___('High Limit'), dataIndex: 'nUpperLimit', width: 70, renderer: numRowRenderer, editor: new Ext.form.BasicEditor() },
                                                        { header: ___('Template_Resolution'), dataIndex: 'nResolution', width: 70, renderer: resolutionRowRenderer, editor: new Ext.form.NumberField({ listeners: { change: function () { editWindow.setDataDirty(); } } }) }, // MTM-5138 - Increased column width
                                                        { header: ___('TUR'), dataIndex: 'nTur', width: 50, renderer: turRowRenderer, editor: new Ext.form.BasicEditor() },
                                                        // MTM-7303 uncRenderer disabled for now { header: ___('Uncertainty'), dataIndex: 'nUncertainty', width: 80, renderer: uncRowRenderer, editor: new Ext.form.BasicEditor() },
                                                        { header: ___('Uncertainty'), dataIndex: 'nUncertainty', width: 80, renderer: turRowRenderer, editor: new Ext.form.BasicEditor() },
                                                        { dataIndex: 'nManualTemplateRowUID', hidden: true } // MTM-5138 - Increased column width
                                                    ]
                                                }),
                                                listeners: {
                                                    viewready: function () {
                                                        if (!isNewRecord) {
                                                            doReloadGrid(true);
                                                            editWindow.clearDataDirty();
                                                        }                                                        

                                                        // MTM-3544
                                                        // This fixes the grid offset (it's a really lame way to do it,
                                                        // but I'm not sure what else we could do).
                                                        var newW = $(".x-grid3-cell").parent().first().width();
                                                        $(".x-grid3-header-offset").width(newW + 100);
                                                    },
                                                    sortchange: function () {
                                                        editWindow.setDataDirty();
                                                    },
                                                    containerclick: function (grid) {
                                                        grid.getSelectionModel().clearSelections();
                                                    },
                                                    contextmenu: function (evt) {
                                                        evt.stopEvent();
                                                        ctxMenu_Basic = new ExcelGridContext();
                                                        ctxMenu_Basic.row = -1;
                                                        ctxMenu_Basic.showAt(evt.xy);
                                                        ctxMenu_Basic = null;
                                                        return false;
                                                    },
                                                    cellcontextmenu: function (self, row, col, evt) {
                                                        evt.stopEvent();

                                                        var grid = Ext.getCmp('grdEditor');
                                                        var record = grid.getStore().getAt(row);
                                                        var formula = record.get('WizardFormula');
                                                        hasFormula = formula;

                                                        ctxMenu = new ExcelGridContext();
                                                        ctxMenu.showMenu(self, evt.xy, row, col);
                                                        ctxMenu = null;
                                                        return false;
                                                    }
                                                }
                                            })

                                        ]

                                    })
                                ]

                            })

                        ]
                    }
                ];

                this.tbar = {
                    xtype: 'toolbar',
                    border: false,
                    frame: false,
                    margin: 0,
                    padding: 0,
                    defaults: {
                        scale: 'large',
                        iconAlign: 'top',
                        cls: 'x-btn-icon-text',
                        width: 50,
                        height: 50
                    },
                    items: [

                        // Find Button
                        {
                            id: 'btnFind',
                            text: ___('FIND'),
                            tooltip: ___('FIND'),
                            iconCls: 'tb-find',
                            handler: doFindAction
                        },
                        { xtype: 'menuseparator' },
                        // Transducer Button
                        {
                            id: 'btnTransducer',
                            text: ___('Transducer'),
                            tooltip: ___('Transducer'),
                            iconCls: 'tb-pressure',
                            enableToggle: true,
                            autoWidth: true,
                            toggleHandler: doTransducer
                        },
                        {
                            id: 'btnCopy',
                            text: ___('COPY'),
                            tooltip: ___('COPY'),
                            iconCls: 'tb-copy',
                            handler: doCopyAction
                        },
                        { xtype: 'menuseparator' },

                        // Add/Delete/Save Buttons
                        {
                            id: 'btnAdd',
                            text: ___('ADD'),
                            tooltip: ___('ADD'),
                            iconCls: 'tb-add',
                            handler: doAddAction
                        }, {
                            id: 'btnDelete',
                            text: ___('DELETE'),
                            tooltip: ___('DELETE'),
                            iconCls: 'tb-delete',
                            handler: doDeleteAction
                        }, {
                            id: 'btnSave',
                            text: ___('SAVE'),
                            tooltip: ___('SAVE'),
                            iconCls: 'tb-save',
                            handler: this.doSubmit
                        },
                        { xtype: 'menuseparator' },
                        // Cancel/Close
                        {
                            xtype: 'button',
                            id: 'btnCancel',
                            text: ___('CANCEL'),
                            tooltip: ___('CANCEL'),
                            iconCls: 'tb-cancel',
                            handler: doCancelAction
                        },
                        {
                            xtype: 'button',
                            id: 'btnClose',
                            text: ___('CLOSE'),
                            tooltip: ___('CLOSE'),
                            iconCls: 'tb-close',
                            handler: doCloseAction
                        }]
                };
                editForm.superclass.initComponent.call(this);
            },
            doSubmit: function () {

                // Stop editing the form.
                var grid = Ext.getCmp('grdEditor');
                grid.stopEditing(false);
                if (!isBasicallyValid()) return;

                // Indicate busy status to user
                app.showBusyStatus(___('SAVING_INFORMATION'), true);

                var form = window.form.getForm();

                // Performs client-side validation
                if (!form.isValid()) {
                    return;
                }

                // Submit the save packet.
                form.submit({
                    async: false,
                    url: '/ManualTemplate/QuickSave/',
                    params: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                        packet: JSON.stringify(getPackage())
                    },
                    waitMsg: ___('SAVING_INFORMATION'),
                    waitTitle: ___('PLEASE_WAIT'),
                    timeout: 240000,    // set lengthy timeout to allow sufficient processing time for large manual templates
                    success: function (form, action) {
                        // When a new record is created, action.result.id will contain the 
                        // new record's primary key value
                        if (action.result && action.result.message) {
                            // If we saved the record and a new uid is returned, update
                            // the recordID variable so we can perform more actions.
                            recordID = action.result.message;
                            window.location.assign('/ManualTemplate/Edit/' + recordID);
                        } else if (!(action.result || {}).success) {
                            Ext.msg.Alert(___('ATTENTION_TITLE'), ___('AN_ERROR_SAVING_THE_DAT_MSG'));
                        }
                        
                        editWindow.clearDataDirty();
                        doReloadGrid(false);            // shallow reload

                        // stringify the formulas
                        var grid = Ext.getCmp('grdEditor');
                        var store = grid.getStore();
                        store.each(function (item) {
                            if (item.get('WizardFormula')) {
                                item.set('WizardFormula', JSON.stringify(item.get('WizardFormula')))        
                            }
                        });                
                    },
                    failure: function (form, action) {
                        switch (action.failureType) {
                            case Ext.form.Action.CLIENT_INVALID:
                                app.showError(___('VALIDATION_ERROR_TITLE'), ___('VALIDATION_ERROR_MSG'));
                                break;
                            case Ext.form.Action.CONNECT_FAILURE:
                                app.showError(___('COMMUNICATION_ERROR_TITLE'), ___('COMMUNICATION_ERROR_MSG'));
                                break;
                            case Ext.form.Action.SERVER_INVALID:
                                if (action.result && action.result.errors) {

                                    // If the DataChecks script changed anything in the model,
                                    // the changed data will be in [action.result.model] as 
                                    // JSON data, which will need to be parsed, and the changes
                                    // reflected in the UI.
                                    var changed = JSON.parse(action.result.model);
                                    clientWindow.updateFields(changed);

                                    // The DataCheck validation script may have indicated that it 
                                    // wanted a dialog presented to the user. 
                                    if (action.result.msg) {
                                        // Display the dialog, and wait for the close callback before
                                        // continuing with other validation updates
                                        app.showError(___('VALIDATION_ERROR_TITLE'), action.result.msg, function () {
                                            // The DataCheck script will indicate which focus should
                                            // get control by setting [action.result.focus]. If that 
                                            // value is set, attempt to set focus to the control with 
                                            // the same ID 
                                            if (action.result.focus) {
                                                clientWindow.setFocus(action.result.focus);
                                            }
                                        });
                                    }

                                }
                                else {
                                    app.showError(___('ERROR_SAVING_RECORD'), action.result.msg || ___('UNKNOWN_ERROR_SAVING'));
                                    app.setStatus(___('ERROR_SAVING_MSG'), true);
                                }
                                break;
                        }
                    }
                });

            }
        });

        var form = new editForm();

        Ext.onReady(function () {
            var body = Ext.get(document.body);

            form.render(body);
            editWindow.initForm(form, myTable);

            var tool = clientWindow.windowObj.getTool("audit");
            if (tool)
                isNewRecord ? tool.hide() : tool.show();

            // found during MTM-4191, not specifying fixed size will remember last
            //clientWindow.setSize( 920, 420 );

            var isCopy = getQueryString()["isCopy"] === "true";

            // Clear data dirty.
            editWindow.clearDataDirty();
            if (isNewRecord) {
                clientWindow.setTitle(___('ADD_MANUAL_TEMPLATE'));
                Ext.getCmp('btnCopy').setDisabled(true);  //MTM-8814 Code changes done to disable the Copy button.
            }
            else if (!isCopy) {
                clientWindow.setTitle(___('EDIT_MANUAL_TEMPLATE') + ' - <%= HttpUtility.JavaScriptStringEncode( Model.cTemplateName ) %>');
            }

            if (isCopy) {
                clientWindow.setTitle(___('ADD_MANUAL_TEMPLATE') + "*");
                Ext.getCmp('cTemplateName').setValue(___('COPY_OF') + " " + Ext.getCmp('cTemplateName').getValue());
            }

            // Initially toggle the toolbar.
            onDataDirtyChanged();

            Ext.getCmp('cTemplateName').focus();           

        });

    </script>

</asp:Content>
