﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<dynamic>" %>

<%@ Import Namespace="MetTeamShared" %>
<%@ Import Namespace="orx.Models" %>
<%@ Import Namespace="orx.Helpers" %>
<% string userName = EmxUser.CurrentUser.cUsername.Replace("'", "&#39"); %>

<script type="text/javascript">

    var mainMenu;
    var menuContext;

    function areAllApplicationsClosed(callback) {
        $.ajax({
            url: '/MetMobile/FindOpenApplications',
            type: 'POST',
            dataType: 'json',
            async: false,
            success: function (result) {
                if (result.message != "") {
                    Ext.Msg.alert(___('ERROR_TITLE'), result.message);
                    callback(false);
                }
                else {
                    callback(true);
                }
            },
            failure: function () {
                Ext.Msg.alert(___('ERROR_TITLE'), ___('FILE_GEENERATION_ERROR'));
                callback(false);
            }
        });
    }

    function requestMobileExe() {

        function getExecutable(facilities) {
            var msg = Ext.MessageBox.wait(___('GENERATING_METTEAM_MOBILE_CONFIGURATION_UTILITY_MSG') + "<br/>" + ___('PLEASE_WAIT') + "...", ___('ATTENTION_TITLE'));
            $.ajax({
                url: '/MetMobile/RequestExe',
                type: 'POST',
                data: JSON.stringify({
                    facilities: facilities,
                    checkInMode: <%= (EmxUser.CurrentUser.IsMobile).ToString().ToLower() %>
				}),
                dataType: 'json',
                contentType: 'application/json',
                success: function (result) {

                    msg.hide();

                    if (result.success) {
                        window.onbeforeunload = function () { };
                        window.location = '/FileManager/DownloadFile/' + result.message;

                        Ext.Msg.show({
                            title: ___('Logoff'),
                            buttons: Ext.MessageBox.OK,
                            msg: ___('MOBILE_LOGOFF_MSG'),
                            fn: function (btn) { doLogoff() }
                        });

                    } else {
                        Ext.Msg.alert(___('ERROR_TITLE'), result.message);
                    }
                },
                failure: function () {
                    msg.hide();
                    Ext.Msg.alert(___('ERROR_TITLE'), ___('FILE_GEENERATION_ERROR'));
                }
            });
        }

        areAllApplicationsClosed(function(ret) {
            if (ret) {
                <% if (EmxUser.CurrentUser.IsMobile == true)
{ %>

                getExecutable([]);

                <% }
else
{ %>

                var findWindow = app.openWindow({
                    title: '<%=L.__("SELECT_FACILITIES")%>',
                    url: '<%: Url.Content( "~/Shared/MultiFind" ) %>?customerOnly=1',
                    modal: true,
                    callbacks: {
                        context: 'FindFacilities',
                        controller: 'Facility',
                        disableAddButton: 'true',
                        onRecordSelected: function(a, b, c) {
                            var facilities = [];
                            c.getStore().each(function(item) {
                                facilities[facilities.length] = item.get('UID');
                            });

                            getExecutable(facilities);

                            findWindow.close();
                        }
                    }
                });
                <% } %>

            }
        });
    }

    function showAbout() {
        app.openWindow({
            title: ___('ABOUT_MET_TEAM'),
            url: '<%: Url.Content( "~/Help/About/" ) %>',
            width: 490,
            height: 325,
            modal: true,
            resizable: false,
            closable: true,
            minimizable: false,
            maximizable: false
        });
    }

    function configureMetCalSecurity() {
        app.openWindow({
            title: ___('Configure MET/CAL Security'),
            url: '/Config/EditMetCal',
            width: 400,
            resizable: true,
            height: 300
        });
    }

    function configureMetCalPrompts() {
        var findWindow = app.openWindow({
            title: ___('Find_Prompt'),
            url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            callbacks: {
                context: "FindPrompt",
                controller: "Prompt",
                disableAddButton: "false",

                onRecordSelected: function (record) {
                    app.openWindow({
                        title: ___('Prompt'),
                        resizable: true,
                        url: '/Prompt/Edit/' + record.get('UID'),
                        width: 1000,
                        height: 500
                    });

                    findWindow.close();
                },
                onCreateNewRecord: function () {
                    app.openWindow({
                        title: ___('Prompt'),
                        resizable: true,
                        url: '/Prompt/Create/' + '<%=GuidHelper.KnownGuids.GuidNewRecord%>',
                        width: 1000,
                        height: 500
                    });

                     find.close();
                 }
             }
         });
    }

    function doPrintCertBatch() {

        var findWindow = app.openWindow({
            title: ___('SELECT_WORK_ORDERS_TITLE'),
            url: '<%: Url.Content( "~/Shared/MultiFind/" ) %>?doPrintCertBatch=1',
            modal: true,
            callbacks: {
                context: 'FindCallSheet',
                controller: 'CallSheet',
                onRecordSelected: function (a, b, c) {

                    // Get the new batch session id.
                    var sessionID = 0;
                    $.ajax({
                        url: '/PrintCertBatch/GenerateBatchSession',
                        data: {
                            __RequestVerificationToken: getSiteAntiForgeryTokenValue()
                        },  
                        type: 'post',
                        dataType: 'json',
                        success: function (result) {
                            if (result !== undefined && result.message !== undefined) {
                                sessionID = result.message;

                                var records = '';
                                var callsheets = [];
                                var index = 0;

                                // The modified onRecordSelected signature now sends
                                // a = record selected, b = context grid, c = multiSelectGrid
                                // So iterate through each record in the multi select grid.
                                c.getStore().each(function (item) {
                                    callsheets[callsheets.length] = item.get('UID');
                                });

                                do {
                                    var records = '';
                                    for (var i = index; i < Math.min(index + 25, callsheets.length); i++) {
                                        records += '&callsheets=' + callsheets[i];
                                    }

                                    index += 25;

                                    $.ajax({
                                        url: '/PrintCertBatch/AddCallSheets?sessionID=' + sessionID + records,
                                        data: {
                                            __RequestVerificationToken: getSiteAntiForgeryTokenValue()
                                        },  
                                        type: 'post',
                                        async: false
                                    });

                                } while (index < callsheets.length);

                                findWindow.close();

                                // Open the edit window, passing in the selected record identifiers.                    
                                app.openWindow({
                                    title: ___('BATCH_PRINTING'),
                                    url: '/PrintCertBatch/Manage/?sessionID=' + sessionID
                                });
                            }
                        }
                    });



                }
            }
        });
    }

    function doBatchChange() {

        var findWindow = app.openWindow({
            title: ___('SELECT_WORK_ORDERS_TITLE'),
            url: '<%: Url.Content( "~/Shared/MultiFind" ) %>?doBatchChange=1',
            modal: true,
            callbacks: {
                context: 'FindCallSheet',
                controller: 'CallSheet',
                onRecordSelected: function (a, b, c) {

                    // The modified onRecordSelected signature now sends
                    // a = record selected, b = context grid, c = multiSelectGrid
                    // So iterate through each record in the multi select grid.
                    c.getStore().each(function (item) {
                        // Adding one at a time since the strings get to long to pass when we process hundreds of records
                        var csUID = item.get('UID');
                        $.ajax({
                            url: '/BatchChange/AddWorkOrder',
                            type: 'post',
                            async: false,
                            data: {
                                __RequestVerificationToken: getSiteAntiForgeryTokenValue(),
                                uid: csUID,
                            }
                        });
                    });

                    findWindow.close();

                    // Open the edit window, passing in the selected record identifiers.                    
                    app.openWindow({
                        title: ___('BATCH CHANGE'),
                        url: '/BatchChange/Edit?1=1',
                        callbacks: {
                            close: function () {
                                $.ajax({
                                    type: 'post',
                                    url: '/BatchChange/ResetWorkOrders',
                                    data: {
                                        __RequestVerificationToken: getSiteAntiForgeryTokenValue()
                                    },  
                                });

                            }
                        }
                    });

                }
            }
        });

    }

    function doBulkReceiving() {
        // open screen to select .csv file to read data from (similar to Import Setup)
        // Select CSV file, data column to use, header rows to skip, field to match value to - Barcode, AssetID, Serial Number
        app.openWindow({
            title: ___('BULK_RECEIVING'),
            url: '/Receiving/Bulk',
            resizable: false
        });
    }

    // This is a special one-off case that uses the Multi-Find screen and heavy customization of properties and function callbacks.
    function doReceivingFind() {
        // Open the find window.
        var findWindow = app.openWindow({
            // Give it a title
            title: ___('FIND_ASSETS'),
            // And specify the URL to be the MultiFind grid. (which is essentially an extension of the regular find grid).
            url: '<%: Url.Content( "~/Shared/MultiFind" ) %>',
            // Tell it to be modal.
            modal: true,
            // Specify the callbacks/overridden variables
            callbacks: {
                // Use the specified find context and set the controller to a certain object.
                context: '<%= (SystemDefault.IsActive(SysDefHelper.RECEIVING_ALLOW_MULTIPLE_WORK_ORDERS)) ? "FindUnReceivedAssets" : "FindUnReceivedClosedAssets" %>',
                controller: 'Asset',
                disableAddButton: 'false',
                // Overwrite the onRecordSelected function...
                onRecordSelected: function (a, b, c) {
                    // When a record from the multi select grid is chosen...
                    // Create a QueryString representing the selected values.
                    // Store an index of how many items are being added.
                    var i = 0;

                    $.ajax({
                        url: '/Receiving/CreateReceivingAssetStore',
                        type: 'POST',
                        async: false,
                    });

                    // The modified onRecordSelected signature now sends
                    // a = record selected, b = context grid, c = multiSelectGrid
                    // So iterate through each record in the multi select grid.
                    c.getStore().each(function (item) {
                        // Generate the querystring, passing in the UID of the selected item.
                        $.ajax({
                            url: '/Receiving/AddReceivingAsset/',
                            type: 'POST',
                            async: false,
                            dataType: 'json',
                            data:
                            {
                                nAssetUID: item.get('UID'),
                            },
                        });
                    });
                    // Open the edit window, passing in the selected assets.                    
                    app.openWindow({
                        title: ___('PROCESS_RECEIVING'),
                        url: '/Receiving/Edit?1=1'
                    });
                    findWindow.close();
                }
            }
        });
    }

    // This is a special one-off case that uses the Multi-Find screen and heavy customization of properties and function callbacks.
    function doReturningFind() {
        // Open the find window.
        var findWindow = app.openWindow({
            // Give it a title
            title: ___('FIND_COMPLETED_WORK_ORDERS'), // Changed to Completed work order from closed work order
            // And specify the URL to be the MultiFind grid. (which is essentially an extension of the regular find grid).
            url: '<%: Url.Content( "~/Shared/MultiFind" ) %>',
            // Tell it to be modal.
            modal: true,
            // Specify the callbacks/overridden variables
            callbacks: {
                // Use the specified find context and set the controller to a certain object.
                context: 'FindClosedCallSheets',
                controller: 'CallSheet',
                // Overwrite the onRecordSelected function...
                onRecordSelected: function (a, b, c) {
                    // When a record from the multi select grid is chosen...
                    // Create a QueryString representing the selected values.
                    $.ajax({
                        url: '/Returning/CreateReturningWorkOrderStore',
                        type: 'POST',
                        async: false,
                        dataType: 'json'
                    });

                    // The modified onRecordSelected signature now sends
                    // a = record selected, b = context grid, c = multiSelectGrid
                    // So iterate through each record in the multi select grid.
                    c.getStore().each(function (item) {
                        // Generate the querystring, passing in the UID of the selected item.
                        $.ajax({
                            url: '/Returning/AddReturningWorkOrder/',
                            type: 'POST',
                            async: false,
                            dataType: 'json',
                            data:
                            {
                                nCallSheetUID: item.get('UID'),
                            },
                        });

                    });
                    app.openWindow({
                        title: ___('RETURNING'),
                        url: '/Returning/Edit?1=1'
                    });
                    findWindow.close();
                }
            }
        });
    }

    function doLogoff() {
        window.onbeforeunload = function () { }
        top.window.location = '<%: Url.Content( "~/Authentication/LogOff" ) %>';
    }

    function notImplemented() {
        app.showError(___('NOT_IMPLEMENTED_TITLE'), ___('NOT_IMPLEMENTED_MSG'));
    }

    function doCombineWorkOrders() {
        var find = app.openWindow({
            title: ___('FIND_ASSET'),
            url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            callbacks: {
                context: 'FindAsset',
                controller: 'Asset',
                disableAddButton: "true",
                onRecordSelected: function (item) {
                    // Resets the Session 
                    $.ajax({
                        url: '/CallSheet/ResetCombineWorkOrderStore',
                        type: 'POST',
                        async: false,
                        dataType: 'json'
                    });
                    app.openWindow({
                        title: ___('COMBINE WORK ORDERS'),
                        url: '/Asset/CombineWorkOrders/' + item.get('UID')
                    });

                    find.close();
                }
            }
        });
    }

    function doManualTemplate() {
        var find = app.openWindow({
            title: ___('FIND_MANUAL_TEMPLATE_TITLE'),
            url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            callbacks: {
                context: 'FindManualTemplates',
                controller: 'ManualTemplate',
                onRecordSelected: function (item) {

                    app.openWindow({
                        title: ___('MANUAL TEMPLATE'),
                        resizable: true,
                        url: '/ManualTemplate/Edit/' + item.get('UID')
                    });

                    find.close();
                },
                onCreateNewRecord: function () {
                    app.openWindow({
                        title: ___('MANUAL TEMPLATE'),
                        resizable: true,
                        url: '/ManualTemplate/Edit/' + '<%=GuidHelper.KnownGuids.GuidNewRecord%>',
                    });

                    find.close();
                }
            }
        });
    }

    function doQuoteFind() {
        var findWindow = app.openWindow({
            title: ___('FIND_QUOTE'),
            url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            callbacks: {
                context: "FindEstimate",
                controller: "Estimate",
                disableAddButton: "false",
                onRecordSelected: function (record) {
                    app.openWindow({
                        title: ___('QUOTE'),
                        url: '/Quote/Edit/' + record.get('UID')
                    });

                    findWindow.close();
                },
                onCreateNewRecord: function () {
                    app.openWindow({
                        title: ___('QUOTE'),
                        url: '/Quote/Edit/' + '<%=GuidHelper.KnownGuids.GuidNewRecord%>',
                    });

                    find.close();
                }
            }
        });
    }

    function findDataCheck() {
        var find = app.openWindow({
            title: ___('FIND_DATA_CHECK'),
            url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            callbacks: {
                context: 'FindValidations',
                controller: 'Validation',
                onRecordSelected: function (item) {

                    app.openWindow({
                        title: ___('EDIT_DATA_CHECK_SCRIPT_TITLE'),
                        resizable: true,
                        url: '/Validation/Create/' + item.get('UID'),
                        width: 1070,
                        height: 600
                    });

                    find.close();
                },
                onCreateNewRecord: function () {
                    app.openWindow({
                        title: ___('EDIT_DATA_CHECK_SCRIPT_TITLE'),
                        resizable: true,
                        url: '/Validation/Create/' + '<%=GuidHelper.KnownGuids.GuidNewRecord%>',
                        width: 1070,
                        height: 600
                    });

                    find.close();
                }
            }
        });
    }

    function doOpenCallSheetFind(controller, context, windowWidth, windowHeight) {
        var find = app.openWindow({
            title: ___('FIND_WORK_ORDER'),
            url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            callbacks: {
                newWindowTitle: ___('EDIT_WORK_ORDER'),
                context: "FindCallsheet",
                controller: "Callsheet",
                disableAddButton: "true"
            }
        });
    }

    function doPartsFind() {
        var find = app.openWindow({
            title: ___('FIND_PART'),
            url: '<%: Url.Content( "~/Shared/Find/" ) %>?doMainPartsSelect=1',
            callbacks: {
                newWindowTitle: ___('EDIT_PART'),
                context: "FindProcedureParts",
                controller: "Part",
                disableAddButton: "false"
            }
        });
    }

    function doFind(controller, context, windowWidth, windowHeight, title) {
        if (title === undefined)
            title = " Find " + controller;

        app.openWindow({
            title: title,
            url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            callbacks: {
                context: context,
                controller: controller,
                editWindowSize: { width: windowWidth || 800, height: windowHeight || 535 }
            }
        });
    }

    function VerifyImportDataDirectorySet() {

        // check if the Import - Data Directory is valid.
        var jqXHR = $.ajax({
            url: '/Import/VerifyImportDataDirectorySet',
            data: {
                __RequestVerificationToken: getSiteAntiForgeryTokenValue()
            },  
            dataType: 'json',
            type: 'POST',
            async: false,
            success: function (result) {
                if (!result.success) {
                    Ext.Msg.confirm(___('ATTENTION_TITLE'), ___('SYSTEM_DEFAULT_INVALID_DATA_DIRECTORY'),
                        function (btn) {
                            if (btn == "yes")
                                FindSystDefaults();
                        });
                }
            }
        });

        var result = JSON.parse(jqXHR.responseText);
        return result.success;
    }

    function VerifyImportFilesDirectorySet() {

        // check if the Import - Files Directory is valid.
        var jqXHR = $.ajax({
            url: '/Import/VerifyImportFilesDirectorySet',
            data: {
                __RequestVerificationToken: getSiteAntiForgeryTokenValue()
            },  
            dataType: 'json',
            type: 'POST',
            async: false,
            success: function (result) {
                if (!result.success) {
                    Ext.Msg.confirm(___('ATTENTION_TITLE'), ___('SYSTEM_DEFAULT_INVALID_FILE_DIRECTORY'),
                        function (btn) {
                            if (btn == "yes")
                                FindSystDefaults();
                        });
                }
            }
        });

        var result = JSON.parse(jqXHR.responseText);
        return result.success;
    }

    function FindSystDefaults() {
        var findWindow = app.openWindow({
            title: ___('FIND_SYSTEM_DEFAULTS'),
            url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            modal: true,
            callbacks: {
                context: "FindSystemDefaults",
                controller: "SystemDefault",
                onRecordSelected: function (record) {
                    var id = record.get("UID");
                    app.openWindow({
                        url: '<%=Url.Content( "~/SystemDefault/Edit" ) %>?id=' + id,
                        width: 555,
                        height: 410,
                        resizable: true
                    });
                    findWindow.close();
                }
            }
        });
    }


    function doImportFind() {
        if (VerifyImportDataDirectorySet())
            if (VerifyImportFilesDirectorySet()) {
                var window = app.openWindow({
                    title: ___('FIND_IMPORT'),
                    url: '/Shared/Find',
                    callbacks: {
                        context: 'FindImport',
                        controller: 'Import'
                    }
                });
            }
    }

    function doImportSetupFind() {
        var window = app.openWindow({
            title: ___('FIND_IMPORT_SETUP'),
            url: '/Shared/Find',
            callbacks: {
                context: 'FindSetupImports',
                controller: 'ImportSetup'
            }
        });
    }

    function doImportDefinitionFind() {
        var window = app.openWindow({
            title: ___('FIND_IMPORT_DEFINITION'),
            url: '/Shared/Find',
            callbacks: {
                context: 'FindImportDefinition',
                controller: 'ImportDefinition'
            }
        });
    }

    function openRootHelp() {
        var url = "/Help/GetHelp";
        app.openWindow({
            title: ___('HELP'),
            url: url,
            width: 800,
            height: 500,
            modal: false,
            resizable: true,
            minimizable: true,
            maximizable: true,
            help: false
        });
    }

    function openHelpWebsite() {
        var url = '<%= SystemDefault.GetValue(SysDefHelper.HELP_WEBSITE, "" ).Replace( "\\", "\\\\" ) %>';
        if (url == '') {
            Ext.Msg.alert(___('WEBSITE_NOT_CONFIGURED_TITLE'), ___('WEBSITE_NOT_CONFIGURED_MSG'));
        }
        else {
            window.open(url);
        }
    }

<% if (EmxUser.CurrentUser.CanConfigure)
    { %>

    var customizationMenu = null;

    function configureMenu() {
        app.openWindow({
            title: ___('MENU_CONFIGURATION'),
            width: 755,
            height: 525,
            url: '<%=Url.Content( "~/Config/Edit" ) %>',
            help: true,
            refresh: true,
            callbacks: {
                model: 'MainMenu',
                target: mainMenu
            }
        });
    }

    function configureSecurityGroups() {
        var findWindow = app.openWindow({
            title: ___('FIND_SECURITY_GROUP'),
            url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            modal: true,
            callbacks: {
                context: "FindSecurityGroups",
                controller: "SecurityGroup",
                onRecordSelected: function (record) {
                    var id = record.get("UID");
                    app.openWindow({
                        title: ___('EDIT_SECURITY_GROUP'),
                        url: '<%=Url.Content( "~/SecurityGroup/Edit" ) %>?id=' + id,
                        width: 580,
                        height: 425
                    });
                    findWindow.close();
                }
            }
        });
    }

    function engineConfig() {
        app.openWindow({
            title: ___('ALERT_ENGINE_CONFIG'),
            url: '<%: Url.Content( "~/Alerting/GetEngineConfig/" ) %>',
            width: 490,
            height: 325,
            modal: true,
            resizable: false,
            closable: true,
            minimizable: false,
            maximizable: false
        });
    }

    function mobileConfig() {
        app.openWindow({
            title: ___('MOBILE_CONFIG'),
            url: '<%: Url.Content( "~/Mobile/MobileConfig/" ) %>',
            width: 490,
            height: 325,
            modal: true,
            resizable: false,
            closable: true,
            minimizable: false,
            maximizable: false
        });
    }

    function ApiTokens() {
        app.openWindow({
            title: ___('API_TOKEN'),
            url: '<%: Url.Content( "~/Api/Select/" ) %>',
            width: 490,
            height: 325,
            modal: true,
            resizable: false,
            closable: true,
            minimizable: false,
            maximizable: false
        });
    }

    function configureSystemDefaults() {
        var findWindow = app.openWindow({
            title: ___('FIND_SYSTEM_DEFAULTS'),
            url: '<%: Url.Content( "~/Shared/Find/" ) %>',
            modal: true,
            callbacks: {
                context: "FindSystemDefaults",
                controller: "SystemDefault",
                onRecordSelected: function (record) {
                    var id = record.get("UID");
                    app.openWindow({
                        url: '<%=Url.Content( "~/SystemDefault/Edit" ) %>?id=' + id,
                        width: 555,
                        height: 410,
                        resizable: true
                    });
                    findWindow.close();
                }
            }
        });
    }

    function configureExtendedData() {
        app.openWindow({
            title: ___('EXTENDED DATA'),
            url: '<%= Url.Content( "~/ExtendedData/Edit" ) %>',
            width: 575,
            height: 400,
            layout: 'fit'
        });
    }

<% } %>
    Ext.override(Ext.app.App, {

        initMainMenu: function () {
            /// <summary>Not intended for use outside of the ClientApp class</summary>

            var mainToolbar = mainMenu = new Ext.Toolbar({
                renderTo: "main-toolbar",
                style: {
                    overflow: 'visible'     // For the Combo popup
                },
                items: [
					<%= Html.Menu( "mnuFile", new {  Text = L.__("FILE") },
						Html.Menu( "mnuLogoff", new { Text =  L.__("LOGOFF"), Handler = "doLogoff" }) ,
						"-",
                        Html.Menu( "mnuImport", new { Text = "Import", Hidden = EmxUser.CurrentUser.IsMobile },
                                Html.Menu( "mnuImportDefinition", new { Text = L.__("IMPORT DEFINITION"), Handler = "function() { doImportDefinitionFind(); }" }),
                                Html.Menu( "mnuImportSetup", new { Text =  L.__("IMPORT SETUP"), Handler = "function() { doImportSetupFind(); }" }),
                                Html.Menu( "mnuImportExecute", new { Text = L.__("RUN IMPORT"), Handler = "function() { doImportFind(); }" })
                        ),
						Html.Menu( "mnuMobile", new { Text = "Mobile" },
							Html.Menu( "mnuMobileCheckIn", new { Text = L.__("CHECK IN"), Hidden = !EmxUser.CurrentUser.IsMobile, Handler = "requestMobileExe", Disabled = false } ),
                            Html.Menu( "mnuMobileCheckOut", new { Text = L.__("CHECK OUT"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "requestMobileExe" } )
						)
					) %>,
					<%= Html.Menu( "mnuWorkflow", new { Text = L.__("WORKFLOW")},
						Html.Menu( "mnuWorkflowReceiving", new { Text =  L.__("RECEIVING"), Handler = "function() { doReceivingFind(); }" } ),
						Html.Menu( "mnuWorkflowWorkOrders", new { Text = L.__("WORK ORDERS"), Handler = "function() { doOpenCallSheetFind(); }" } ),
						Html.Menu( "mnuReturning", new { Text = L.__("RETURNING"), Handler = "doReturningFind" } ),
						"-",
						Html.Menu( "mnuWorkflowBulkReceiving", new { Text =  L.__("BULK_RECEIVING"), Handler = "function() { doBulkReceiving(); }" } ),
                        Html.Menu( "mnuShipping", new { Text = L.__("SHIPPING"), Handler = "function() { doFind( 'Shipment', 'FindShipments', undefined, undefined, ___('FIND_SHIPPMENT') ); }" } ),
						Html.Menu( "mnuBatchChange", new { Text = L.__("BATCH CHANGE"), Handler = "doBatchChange" } ),
						Html.Menu( "mnuWorkflowTools", new { Text = L.__("TOOL ASSIGNMENTS"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "function() { app.openWindow( ___('TOOL ASSIGNMENT'), '/ToolAssignment/Manage' ); }" } ),
                        Html.Menu( "mnuCombineWorkOrders", new { Text = L.__("COMBINE WORK ORDERS"), Handler = "function() { doCombineWorkOrders(); }" } ),
						"-",
						Html.Menu( "mnuMyWork", new { Text =L.__("MY WORK"), Handler = "function() { app.openWindow( ___('MY WORK'), '/MyWork/Edit/" + GuidHelper.KnownGuids.GuidNewRecord +  "'); }" } )
					) %>,
					<%= Html.Menu( "mnuMaintenance", new { Text = L.__("MAINTENANCE")},
                        Html.Menu( "mnuMaintAssets", new { Text = L.__("ASSETS"), Handler = "function() { doFind( 'Asset', 'FindAsset', 900, 525, ___('FIND_ASSET') ); }" } ),
                        Html.Menu( "mnuMaintTypes", new { Text = L.__("TYPES"), Handler = "function() { doFind( 'Type', 'FindType', undefined, undefined, ___('FIND_TYPE_TITLE') ); }" } ),
                        Html.Menu( "mnuMaintProcedures", new { Text = L.__("PROCEDURES"), Handler = "function() { doFind( 'Procedure', 'FindProcedure', undefined, undefined, ___('FIND_PROCEDURE_TITLE') ); }" } ),
                        Html.Menu( "mnuMaintFacilities", new { Text = L.__("FACILITIES"), Handler = "function() { doFind( 'Facility', 'FindFacilities', undefined, undefined, ___('FIND_FACILITY_TITLE') ); }" } ),
                        Html.Menu( "mnuMaintJobNumbers", new { Text =  L.__("JOB NUMBERS"), Handler = "function() { doFind( 'JobNumber', 'FindJobNumbers', undefined, undefined, ___('FIND_JOBNUMBER_TITLE') ); } " }),
                        Html.Menu( "mnuMaintUnits", new { Text =  L.__("UNITS"), Handler = "function() { doFind( 'Unit', 'FindUnits', undefined, undefined, ___('FIND_UNIT') ); } " }),
                        "-",
                        Html.Menu( "mnuMaintParts", new { Text =L.__("PARTS"), Handler = "function() { doPartsFind(); }" } ),
                        "-",
                        Html.Menu( "mnuMaintManualTemplates", new { Text =L.__("MANUAL TEMPLATES"), Handler = "function() { doManualTemplate(); }" } ),
                        Html.Menu( "mnuMaintFiles", new { Text = L.__("FILES"), Handler = "function() { doFind( 'File', 'FindFiles', undefined, undefined, ___('FIND_FILE_TITLE') ); }" } ),
                        Html.Menu( "mnuMaintAccreditation", new { Text = L.__("ACCREDITATIONS"), Handler = "function() { doFind( 'Accreditation', 'FindAccreditation', undefined, undefined, ___('FIND_A_ACCREDITATION') ); }" } ),
                        "-",
                        Html.Menu( "mnuMaintDataCleanup", new { Text =  L.__("Data Cleanup"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "function() { app.openWindow({ title: ___('Data Cleanup'), url: '/DataTool/Edit' }); }" } )
                    ) %>,
					<%= Html.Menu( "mnuManagement", new { Text = L.__("MANAGEMENT") },
                        Html.Menu( "mnuBusinessStatus", new { Text = L.__("BUSINESS STATUS"), Handler = "function() { app.openWindow(___('BUSINESS_STATUS_TITLE'), '/BusinessStatus/Edit'); }" } ),
                        Html.Menu( "mnuBilling", new { Text = L.__("BILLING"), Handler = "function(){ doFind( 'Invoice', 'FindInvoice', undefined, undefined, ___('FIND_INVOICE') ); }" } ),
						"-",
						Html.Menu( "mnuProblemReports", new { Text =  L.__("PROBLEM REPORTS"), Handler = "function() { doFind( 'ProblemReport', 'FindProblemReport', undefined, undefined, ___('FIND_PROBLEM_REPORT') ); }" } ),
						Html.Menu( "mnuTechAssignments", new { Text = L.__("TECH ASSIGNMENT"), Handler = "function() { app.openWindow({ title:___('TECH ASSIGNMENT'), url: '/TechAssign/Edit', resizable: true})}" } ),
                        Html.Menu( "mnuQuote", new { Text = L.__("QUOTE"), Handler = "function() { doQuoteFind(); }" } ),
                        Html.Menu( "mnuContractPricing", new { Text = L.__("CONTRACT PRICING"), Handler = "function() { doFind( 'Pricing', 'FindPricing', undefined, undefined, ___('FIND_PRICING') ); }" } ),
						"-",
						Html.Menu( "mnuManageCalendar", new { Text = L.__("CALENDAR"), Handler = "function() { app.openWindow(___('CALENDAR'), '/Calendar/Manage'); }" } )
					) %>,
					<%= Html.Menu( "mnuReports", new { Text = L.__("REPORTS")},
						Html.Menu( "mnuRecall", new { Text = L.__("RECALL"), Handler = "function() { app.openWindow(___('RECALL'), '/Recall/Generate' ) }" } ),
						"-",
                        Html.Menu( "mnuBatchCert", new { Text = L.__("BATCH_PRINTING"), Handler = "function() { doPrintCertBatch(); }" } ),
						"-",
						Html.Menu( "mnuCustomReports", new { Text = L.__("CUSTOM REPORTS"), Handler = "function() { app.openWindow({ title: ___('BROWSE_REPORTS'), url: '/Report/ReportBrowser', minWidth: 300, minHeight: 300, resizable: true } ) }" } ),
                        "-",
                        Html.Menu( "mnuAlerting", new { Text = L.__("ALERTING SCHEDULES"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "function() { doFind('Alerting', 'FindAlert', undefined, undefined, ___('FIND_ALERT_TITLE') ); }" } )
					) %>,
					<%= Html.Menu( "mnuSetup", new { Text =  L.__("SETUP")},
						Html.Menu( "mnuSetupContacts", new { Text = L.__("CONTACTS"), Handler = "function() { doFind( 'Contact', 'FindContacts', undefined, undefined, ___('FIND_CONTACT_TITLE') ); }" } ),
						Html.Menu( "mnuSetupUsers", new { Text = L.__("USERS"), Handler = "function() { doFind( 'User', 'FindUsers', undefined, undefined, ___('FIND_USER_TITLE') ); }" } ),
						Html.Menu( "mnuSetupServices", new { Text =  L.__("SERVICES"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "function() { app.openWindow(___('Service Types'), '/ServiceType/Select' ) }" } )
					) %>,
					<%= Html.Menu( "mnuHelp", new { Text = L.__("HELP") },
						Html.Menu( "mnuHelpHelp", new { Text = L.__("HELP"), Handler = "openRootHelp" } ),
						Html.Menu( "mnuHelpWebsite", new { Text = L.__("WEBSITE"), Handler = "openHelpWebsite" } ),
						'-',
						Html.Menu( "mnuHelpAbout", new { Text =  L.__("ABOUT"), Handler = "showAbout" } )
					) %>,
                    <% if (EmxUser.CurrentUser.CanConfigure)
    { %>
					<%= Html.Menu( "mnuSystem", new {Text =  L.__("CONFIGURE")},
							Html.Menu( "mnuSystemEvent", new { Text = L.__("SEND SYSTEM MESSAGE"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "function() { Ext.Msg.prompt(___('CREATE_SYSTEM_EVENT_TITLE'), ___('CREATE_SYSTEM_EVENT_MSG'), function( btn, message ) { if ( btn !== 'ok' ) return; $.ajax({ type: 'post', url: '/Event/AddSystemEvent?message=' + escape(message), data: { __RequestVerificationToken: getSiteAntiForgeryTokenValue() } }); }, this, true); }" } ),
							Html.Menu( "mnuSystemDefaults", new { Text = L.__("SYSTEM DEFAULTS"), Handler = "configureSystemDefaults" } ),
							Html.Menu( "mnuSystemConfigureMenu", new { Text = L.__("MENU SECURITY"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "configureMenu" } ),
                            Html.Menu( "mnuSystemConfigureMetCalMenu", new { Text = L.__("MET/CAL Security"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "configureMetCalSecurity" } ),
                            Html.Menu( "mnuSystemMetCalPromptsMenu", new { Text = L.__("MET_CAL_Prompts"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "configureMetCalPrompts" } ),
							Html.Menu( "mnuSystemValidations", new { Text = L.__("DATA CHECKS"), Handler = "function() { findDataCheck(); }" } ),
							Html.Menu( "mnuSystemExtendedData", new { Text = L.__("EXTENDED DATA"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "configureExtendedData" } ),
							Html.Menu( "mnuConfigureGroups", new { Text =  L.__("GROUPS"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "configureSecurityGroups" } ),
                            Html.Menu( "mnuAlertingEngine", new { Text = L.__("ALERT_ENGINE_CONFIG"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "engineConfig" } ),
					        Html.Menu( "mnuMobileConfig", new { Text = L.__("MOBILE_CONFIG"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "mobileConfig" } )//,
                            /*Html.Menu( "mnuApiTokens", new { Text = L.__("API_TOKEN"), Hidden = EmxUser.CurrentUser.IsMobile, Handler = "ApiTokens" } )*/
					) %>,
<% } %>
                    { xtype: 'tbfill' },
                    "<b>" + ___('FACILITY') +":&nbsp;</b> <%= EmxUser.CurrentUser.GetActiveFacility().cFacilityName %>",
                    { xtype: 'tbspacer', width: 15 },
                    { xtype: 'tbtext', text: '<b>' + ___('USER_TXT') +': </b><span id="logged-in-user"><%= userName %></span>' },

                    { xtype: 'tbspacer', width: 15 },
					<%= Html.Menu( "mnuLogoffButton", new { Text = L.__("LOGOFF"), Handler = "doLogoff" } ) %>,
                    { xtype: 'tbspacer', width: 15 }
                ]
            });

            if ( '<%= Licensing.IsLicensedModule( ModuleType.METTeamExpress, false, false).ToString().ToLower() %>' == 'true') {
                var mnuShipping = Ext.getCmp('mnuShipping');
                if (mnuShipping !== undefined)
                    mnuShipping.setDisabled(true);

                var mnuMaintJobNumbers = Ext.getCmp('mnuMaintJobNumbers');
                if (mnuMaintJobNumbers !== undefined)
                    mnuMaintJobNumbers.setDisabled(true);

                var mnuMaintParts = Ext.getCmp('mnuMaintParts');
                if (mnuMaintParts !== undefined)
                    mnuMaintParts.setDisabled(true);

                var mnuBusinessStatus = Ext.getCmp('mnuBusinessStatus');
                if (mnuBusinessStatus !== undefined)
                    mnuBusinessStatus.setDisabled(true);

                var mnuRecallEscalation = Ext.getCmp('mnuRecallEscalation');
                if (mnuRecallEscalation !== undefined)
                    mnuRecallEscalation.setDisabled(true);

                var mnuBatchCert = Ext.getCmp('mnuBatchCert');
                if (mnuBatchCert !== undefined)
                    mnuBatchCert.setDisabled(true);

                var mnuSystemValidations = Ext.getCmp('mnuSystemValidations');
                if (mnuSystemValidations !== undefined)
                    mnuSystemValidations.setDisabled(true);
            }

            if ('<%= Licensing.IsLicensedModule( ModuleType.METTeamCommerce, false, false).ToString().ToLower() %>' == 'false') {
                var mnuBilling = Ext.getCmp('mnuBilling');
                if (mnuBilling !== undefined)
                    mnuBilling.setDisabled(true);

                var mnuQuote = Ext.getCmp('mnuQuote');
                if (mnuQuote !== undefined)
                    mnuQuote.setDisabled(true);

                var mnuContractPricing = Ext.getCmp('mnuContractPricing');
                if (mnuContractPricing !== undefined)
                    mnuContractPricing.setDisabled(true);
            }

            if ('<%= Licensing.IsLicensedModule( ModuleType.METTeamMobile, false, false).ToString().ToLower() %>' == 'false') {
                var mnuMobileCheckOut = Ext.getCmp('mnuMobileCheckOut');
                if (mnuMobileCheckOut !== undefined)
                    mnuMobileCheckOut.setDisabled(true);
            }

            return mainToolbar;

        }

    });

</script>
