﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Edit.Master" Inherits="System.Web.Mvc.ViewPage<ToolAssignmentModel>" %>

<%@ Import Namespace="orx" %>
<%@ Import Namespace="orx.Helpers" %>
<%@ Import Namespace="orx.Models" %>
<%@ Import Namespace="MetTeamShared" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" runat="server">

    <%
        ToolAssignment toolAssignment = new ToolAssignment();

        bool editMode = (Model.ToolAssignmentGrid.Count() > 0);

        int isReceiving = (Model.IsReceiving ? 1 : 0);
        if (Model.IsReceiving)
            editMode = false;

        string taRecords = "";

        if (Model.ToolAssignmentRecords.Count() > 0)
        {
            foreach (ToolAssignment ta in Model.ToolAssignmentRecords)
            {
                if (ta != null)
                    taRecords += ta.ToJSON() + ",";
            }

            if (taRecords.EndsWith(","))
                taRecords = taRecords.Remove(taRecords.Length - 1, 1);
        }


        string vwTaRecords = "";

        if (Model.ToolAssignmentGrid.Count() > 0)
        {
            foreach (vw_ToolAssignment vwTa in Model.ToolAssignmentGrid)
            {
                if (vwTa != null)
                    vwTaRecords += vwTa.ToJSON() + ",";
            }
        }

        if (vwTaRecords.Length > 1)
            vwTaRecords = vwTaRecords.Remove(vwTaRecords.Length - 1, 1);

    %>

    <script src="<%: Url.Content("~/Scripts/jquery.validate.min.js") %>" type="text/javascript"></script>
    <script src="<%: Url.Content("~/Scripts/jquery.validate.unobtrusive.min.js") %>" type="text/javascript"></script>
    <script src="<%: Url.Content("~/Scripts/EmxWeb.CrystalReports.js") %>" type="text/javascript"></script>
    <script src="<%: Url.Content("~/Scripts/EmxWeb.ExtendedData.js") %>" type="text/javascript"></script>

    <script type="text/javascript">
    <%
        // hack to handle multiple querystrings with the same value.
        var loaded = Request.QueryString["isLoaded"] ?? "false";
        loaded += ",";
        loaded = loaded.ToLower();
    %>
        var isReturning = <%= (isReceiving == 0) ? "false" : "true" %>;
        var isLoaded = <%= loaded.Split(',').FirstOrDefault() ?? "false" %>;
        var isLocked = <%: ViewData[ "locked" ] != null ? "true" : "false" %>;

        var records = [<%= vwTaRecords %>];

        var lastToolId = '<%= GuidHelper.KnownGuids.GuidNewRecord %>';
        var lastAssetUID = '<%= GuidHelper.KnownGuids.GuidNewRecord %>';
        var cached = [<%= taRecords %>];

        // Fix for datefield.
        // NOTE: This should probably be set in ext-extensions, however, due to the depth of that file, I opted to include the code here instead. We can address that later if issues actually pop up.
        // This works because the *actual* setValue() has other code which returns a different value based on whether the control is  marked as 'rendered' or not. And removing that code is the key.
        Ext.override(Ext.form.DateField, {
            getValue: function () {
                var v = this.value;

                if (v === this.emptyText || v === undefined)
                    v = '';
                
                return v;
            },
            listeners: {
                blur: function (field) {
                    if (field === undefined || field.getValue() === undefined || $.trim(field.getValue()).length === 0) return;

                    var today = new Date();
                    field.setValue(field.getValue().setHours(today.getHours(), today.getMinutes(), today.getSeconds()));
                },
                change: function (field) {
                    if (field === undefined || field.getValue() === undefined || $.trim(field.getValue()).length === 0) return;

                    var today = new Date();
                    field.setValue(field.getValue().setHours(today.getHours(), today.getMinutes(), today.getSeconds()));
                }
            }
        });

        function saveExData(id) {
            $.ajax({
                type: 'POST',
                url: '/ToolAssignment/UpdateExtendedData/',
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                    id: id,
                    ExtendedData: ExtendedData.gatherExtendedData()
                },
                dataType: 'json',
                async: false
            });

        }

        function processResultRows(result) {

            // If no results (or results.rows is undefined or not an array)  exit early.
             if (!result || !Array.isArray(result.rows))
                return;

            for (var i = 0; i < result.rows.length; i++) {
                var row = result.rows[i];
                var key = row.field;
                var val = row.value;

                if (key[0] === 't' && !isNaN(parseFloat(val))) {
                    val = parseFloat(val);

                    var date = new Date(val);
                    var utc = new Date(new Date(val).getUTCTime && new Date(val).getUTCTime());

                    // Fallback if getUTCTime is undefined
                    if (!utc || isNaN(utc.getTime())) {
                        utc = new Date(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds());
                    }

                    var oDST = utc.isDST ? utc.isDST() : false;
                    var tDST = date.isDST ? date.isDST() : false;

                    var offset = 0;
                    if (oDST && !tDST) offset = -1 * 60 * 60 * 1000;
                    else if (!oDST && tDST) offset = 1 * 60 * 60 * 1000;

                    var adjustedDate = new Date(val + (new Date(val).getTimezoneOffset() * 60000) - offset);
                    row.value = adjustedDate.toISOString();
                }
            }
        }


        function loadExDataCommon(id, updateUI) {
            $.ajax({
                url: '/ExtendedData/GetExtendedData/?Type=ToolAssignment&ID=' + id,
                type: 'POST',
                dataType: 'json',
                contentType: 'application/json',
                async: false,
                success: function (result) {
                    if (updateUI) {
                        var exDataGrid = Ext.getCmp('ToolAssignmentEx');

                        if (!exDataGrid)
                            return;

                        exDataGrid.getStore().each(function (item) {
                            if (item !== undefined)
                                item.set('value', '');
                        });
                    }

                    processResultRows(result);

                    try {
                        if (updateUI && exDataGrid)
                            exDataGrid.getStore().loadData(result);

                        associateExDataWithToolAssigmentRow(id, result);
                    }
                    catch (err) { }
                }
            });
        }

        function loadExDataNoUIUpdate(id) {
            loadExDataCommon(id, false);
        }

        function loadExData(id) {
            loadExDataCommon(id, true);
        }

        function formatData(record) {
            var formatted = Object.assign({}, record); // shallow clone
            var returnDateCheck = false;
            var isReturning = <%= isReceiving.ToString().ToLower() %>;

            // Fix tLoanDate
            if (typeof formatted.tLoanDate !== typeof new Date())
                formatted.tLoanDate = new Date(formatted.tLoanDate);
            
            // Fix tExpectedReturnDate
            if ($.trim(formatted.tExpectedReturnDate) === '')
                formatted.tExpectedReturnDate = '';
            else if (!isNaN(new Date(formatted.tExpectedReturnDate)))
                formatted.tExpectedReturnDate = new Date(formatted.tExpectedReturnDate);
            else
                formatted.tExpectedReturnDate = '';

            // Handle tReturnDate
            if (isReturning && formatted.tReturnDate === undefined)
                formatted.tReturnDate = new Date();
            else {
                returnDateCheck = true;
                const parsed = new Date(formatted.tReturnDate);
                if (!isNaN(parsed))
                    formatted.tReturnDate = parsed;
                else
                    formatted.tReturnDate = '';
            }

            return {
                record: formatted,
                returnDateCheck: returnDateCheck
            };
        }

        function loadData(id, assetId) {

            function load(record) {
                
                var result = formatData(record);
                record = result.record;

                Ext.getCmp('cAssignmentNumber').setValue(record.cAssignmentNumber);
                Ext.getCmp('cAssignedLocation').setValue(record.cAssignedLocation);
                Ext.getCmp('nPastDue').setText(record.nPastDue);
                Ext.getCmp('tLoanDate').setValue(record.tLoanDate);
                Ext.getCmp('tExpectedReturnDate').setValue(record.tExpectedReturnDate);
                Ext.getCmp('mNotes').setValue(record.mNotes);
                Ext.getCmp('nContactUID').setValue(record.nContactUID);
                Ext.getCmp('nContactUID_display').setValue(record.cFullName);
                Ext.getCmp('nContactUID_edit').setDisabled(false);
                Ext.getCmp('nUseCount').setValue(record.nUseCount);
                Ext.getCmp('tReturnDate').setValue(record.tReturnDate);

                if (result.returnDateCheck)
                    returnDateCustomValidator(true);

                lastToolId = id;
                lastAssetUID = assetId;
                
                loadExData(id);
                loadToolAssignmentFilesGrid(id);
            }

            if (cached !== undefined) {
                for (var i = 0; i < cached.length; i++) {
                    var item = cached[i];
                    if (item !== undefined) {
                        if (item.nToolAssignmentUID == id && item.nAssetUID == assetId)
                            load(item);
                    }
                }
            }
        }

        function saveData(saveExtData) {

            function save(record) {
                record.cAssignmentNumber = Ext.getCmp('cAssignmentNumber').getValue();
                record.cAssignedLocation = Ext.getCmp('cAssignedLocation').getValue();
                record.tLoanDate = new Date(Ext.getCmp('tLoanDate').getValue());
                record.tExpectedReturnDate = new Date(Ext.getCmp('tExpectedReturnDate').getValue());
                record.mNotes = Ext.getCmp('mNotes').getValue();
                record.nContactUID = Ext.getCmp('nContactUID').getValue();
                record.cFullName = Ext.getCmp('nContactUID_display').getValue();
                record.nUseCount = Ext.getCmp('nUseCount').getValue();

                // Update the return date if the field is editable. Otherwise, ignore it.
                if (!Ext.getCmp('tReturnDate').readOnly)
                    record.tReturnDate = new Date(Ext.getCmp('tReturnDate').getValue());
            }

            var record = undefined;

            Ext.each(cached, function (item) {
                if (item !== undefined) {
                    if (item.nToolAssignmentUID == lastToolId && item.nAssetUID == lastAssetUID) {
                        save(item);

                        if (saveExtData)
                            saveExData(lastToolId);
                    }
                }
            });
        }

        // custom validator for the returned date field.
        function returnDateCustomValidator(supress) {

            if (supress == undefined) supress = true;

            var today = new Date().getTime() + 60 * 1000 + 1;
            var field = Ext.getCmp('tReturnDate').getValue();
            if (field === undefined || field === null) return true;

            if ($.trim(field).length > 0) {
                if (field.getTime() > today) {
                    Ext.Msg.alert(___('INVALID_RETURN_DATE_TITLE'), ___('INVALID_RETURN_DATE_MSG'));
                    Ext.getCmp('tReturnDate').markInvalid(___('DATE_CANNOT_BE_IN_THE_FUTURE_ERROR_MESSAGE'));
                    return false;
                }
            }

            if (supress)
                return;

            var blnReturn = true;
            Ext.each(cached, function (record) {
                if (record !== undefined && record !== null) {
                    if (isReturning && record.tReturnDate === undefined) {
                        Ext.Msg.alert(___('ERROR_TITLE'), ___('SPECIFY_RETURN_DATE_FOR_ALL_RECORDS_MSG'));
                        blnReturn = false;
                    }

                    if (record.tReturnDate !== undefined && (!Ext.getCmp('tReturnDate').readOnly)) {
                        // since it's always local time, this should work.
                        if (record.tReturnDate.getTime() > today) {
                            Ext.Msg.alert(___('ERROR_TITLE'), ___('RETURN_DATE_INVALID_MSG'));
                            blnReturn = false;
                        }
                    }
                }
            });

            return blnReturn;

        }

        var fillGrdListener = {
            
            viewready: function (grid) {
                if (records.length > 0) {

                    Ext.each(records, function (record) {                       
                        grid.getStore().add(new Ext.data.Record(record));
                        loadExData(record.nToolAssignmentUID);
                    });

                    grid.getStore().singleSort('tLoanDate', 'DESC');

                    var sm = grid.getSelectionModel();
                    sm.selectFirstRow();

                    grid.fireEvent('rowclick', grid, 0, undefined);
                    grid.getView().focusRow(0);
                }
            },

            // handle arrow up/arrow down events. Because row selection does not actually change until after this event has been processed, we have to manually "look ahead" to
            // determine which record will be selected after the event.
            keydown: function (evt) {
                var v = evt.getKey();
                if (v == 38 || v == 40) {
                    var grid = Ext.getCmp("fillGrdAssignments");

                    var sm = grid.getSelectionModel();
                    if (sm === undefined) return;

                    var record = sm.getSelected();
                    if (record === undefined) return;

                    var recPos = 0;
                    for (var i = 0; i < grid.store.data.getCount(); i++) {
                        var rec = grid.store.getAt(i);
                        if (rec.id == record.id) {
                            recPos = (v == 38) ? i - 1 : i + 1;
                            break;
                        }
                    }

                    recPos = (recPos < 0) ? 0 : ((recPos > grid.store.data.getCount() - 1) ? grid.store.data.getCount() - 1 : recPos);

                    record = grid.store.getAt(recPos);
                    if (record === undefined) return;

                    loadData(record.get('nToolAssignmentUID'), record.get('nAssetUID'));
                }
            },

            rowclick: function (grid, index, evt) {
                var sm = grid.getSelectionModel();
                if (sm === undefined) return;

                var record = sm.getSelected();
                if (record === undefined) return;

                saveData(true);
                loadData(record.get('nToolAssignmentUID'), record.get('nAssetUID'));
            }
        };

        function associateExDataWithToolAssigmentRow(toolAssigmentID, exData) {
            var grid = Ext.getCmp("fillGrdAssignments");
            if (!grid) return;

            var store = grid.getStore();
            if (!store) return;

            store.each(function (record) {
                if (record.get('nToolAssignmentUID') == toolAssigmentID) {
                    record.exData = exData;
                    return false;
                }
            });
        }


        function doAdd() {

            var findWindow = app.openWindow({
                title: ___('ASSET_SELECT_ASSETS_TEXT'),
                url: '<%: Url.Content( "~/Shared/MultiFind" ) %>',
                modal: true,
                callbacks: {
                    context: 'FindAsset',
                    controller: 'Asset',
                    onRecordSelected: function (a, b, c) {

                        var records = '';

                        // The modified onRecordSelected signature now sends a = record selected, b = context grid, c = multiSelectGrid
                        // So iterate through each record in the multi select grid.
                        c.getStore().each(function (item) {
                            records += "&id=" + item.get('UID');
                        });

                        window.location.assign('/ToolAssignment/AddMode/?1=1' + records);

                        // To get rid of this IE exceptions and closing this find window once everything is done
                        findWindow.close();
                    }
                }
            });

            return findWindow;
        }

        function doToolAssignFind(onlyLoaned, callback) {

            if (onlyLoaned === undefined) onlyLoaned = false;
            var qs = "";

            if (onlyLoaned) qs = "/?returnMode";

            if (callback === undefined) {
                callback = function (a, b, c) {

                    var records = '';

                    // The modified onRecordSelected signature now sends a = record selected, b = context grid, c = multiSelectGrid
                    // So iterate through each record in the multi select grid.
                    c.getStore().each(function (item) {
                        records += "&id=" + item.get('UID');
                    });

                    var url = '';
                    if (onlyLoaned === undefined || onlyLoaned === false) {
                        url = '/ToolAssignment/EditMode/?isReceiving=false' + records;
                    } else {
                        url = '/ToolAssignment/EditMode/?isReceiving=true' + records;
                    }

                    // "window.location = {x}" doesn't work in Firefox
                    window.location.assign(url);

                    // To get rid of this IE exceptions and closing this find window once everything is done
                    findWindow.close();
                };
            }

            var findWindow = app.openWindow({
                title: ___('SELECT_TOOL_ASSIGNMENTS_TITLE'),
                url: '<%: Url.Content( "~/Shared/MultiFind" ) %>' + qs,
            modal: true,
            callbacks: {
                context: 'FindToolAssignments',
                controller: 'ToolAssignment',
                onRecordSelected: callback
            }
        });

            return findWindow;
        }


        function onDataDirtyChanged() {

            var value = editWindow.getDataDirty();

            Ext.getCmp('btnFind').setDisabled(value);
            if (value)
                Ext.getCmp('btnPrint').setDisabled(value);
            else
                Ext.getCmp('btnPrint').setDisabled(<%= (!editMode && !Model.IsReceiving).ToString().ToLower() %>);

            Ext.getCmp('btnAdd').setDisabled(value);
            if (value)
                Ext.getCmp('btnDelete').setDisabled(value);
            else
                Ext.getCmp('btnDelete').setDisabled(<%= (!editMode && !Model.IsReceiving).ToString().ToLower() %>);

            Ext.getCmp('btnSave').setDisabled(!value);
            Ext.getCmp('btnCancel').setDisabled(!value);

        }


        function PrintData(reportType) {

            var reportName = '<%= SystemDefault.GetValue(SysDefHelper.TOOL_ROOM_REPORT, SysDefHelper.TOOL_ROOM_REPORT_DEFAULT_VALUE) %>';

            var grid = Ext.getCmp('fillGrdAssignments');
            if (grid === undefined) return;

            var uids = "";

            grid.getStore().each(function (item) {
                uids += "&toolAssignmentUIDs=" + item.get('nToolAssignmentUID');
            });

            uids += "&1=1";

            Report.PreviewReport(reportName, [], "/ToolAssignment/Print/?2=2" + uids, false, false, reportType);
        }

        var returnDateListener = {
            select: ReturnDateChange
        };

        function ReturnDateChange() {
            editWindow.setDataDirty();
            returnDateCustomValidator();

            // Recalculate the past due.
            $.ajax({
                url: '/ToolAssignment/Retrieve/' + lastToolId,
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                },  
                type: 'post',
                dataType: 'json',
                success: function (result) {
                    if (result !== undefined) {
                        if (result.nPastDue !== undefined)
                            Ext.getCmp('nPastDue').setText(result.nPastDue);
                    }
                }
            });
        }

        var dateListener = {
            keydown: function (form, event) {
                var keyCode = event.getKey();
                if (event.getKey() == event.BACKSPACE || keyCode == 8 || keyCode == 46) {
                    var ctrlId = $(this).attr('id');
                    Ext.getCmp(ctrlId).setValue(null);
                    editWindow.setDataDirty();
                }
            },
            select: function (form, event) {
                editWindow.setDataDirty();
            },
            change: function (form, event) {
                editWindow.setDataDirty();
            }
        };

        var myTable = '<%: Html.GetTable( Model ) %>';
        var recordID = '<%= GuidHelper.KnownGuids.GuidStringNewRecord %>';

        editForm = Ext.extend(Ext.form.FormPanel, {

            id: 'edit-form',
            url: window.location,
            frame: false,
            hideBorders: true,
            labelWidth: 120,
            labelAlign: 'top',
            layout: 'fit',
            height: 560,
            width: 688,
            defaults: {
                msgTarget: 'side'
            },
            initComponent: function () {
                this.items = [{
                    xtype: 'container',
                    width: 688,
                    height: 500,
                    layout: 'absolute',
                    items: [
                        // DO NOT CHANGE THE NAME/ID OF THIS GRID!! Doing so will break the DataCheck.ToolAssignmentMode function!
                    <%= Html.RenderGrid("FillgrdAssignments", null, new { ID = "fillGrdAssignments", X = 10, Y = 5, PageSize = 1500000,  RemoteSort = false, Width = 635, Height = 208, Listeners = "fillGrdListener" }, new string[] { GuidHelper.KnownGuids.GuidStringNewRecord }) %>
                    ,
                    {
                        id: 'btnAddSm',
                        xtype: 'button',
                        iconCls: 'btn-add-sm',
                        tooltip: ___('ADD_ASSET_TO_LIST_TOOLTIP'),
                        x: 650,
                        y: 5,
                        disabled: <%= (!editMode && !Model.IsReceiving).ToString().ToLower() %>,
                        handler: function () {
                            var grid = Ext.getCmp('fillGrdAssignments');
                            if (grid === undefined) return;

                            var findWindow = doToolAssignFind(isReturning, function (a, b, c) {

                                var searchRecords = '';

                                c.getStore().each(function (item) {
                                    searchRecords += "&id=" + item.get('UID');
                                });

                                $.ajax({
                                    url: '/ToolAssignment/RetrieveRange/?1=1' + searchRecords,
                                    data: {
                                        __RequestVerificationToken: getWindowAntiForgeryTokenValue()
                                    },  
                                    type: 'POST',
                                    dataType: 'json',
                                    success: function (result) {

                                        var index = -1;
                                        Ext.each(result.ToolAssignmentRecords, function (item) {

                                            index++;

                                            var skip = false;
                                            Ext.each(cached, function (row) {
                                                if (row === undefined) return;
                                                if (row.nAssetUID == item.nAssetUID && row.nToolAssignmentUID == item.nToolAssignmentUID)
                                                    skip = true;
                                            });

                                            if (skip)
                                                return;

                                            // Fix the time for ticks that begin with zero. Apparently this isn't an issue for records that are initially loaded.
                                            for (var prop in item) {
                                                if (prop.startsWith('t')) {
                                                    var val = item[prop].toString();
                                                    if (val[0] == '0') {
                                                        for (var r = 0; r < val.length; r++) {
                                                            if (val[r] == '0')
                                                                val = val.substr(1);
                                                            else
                                                                break;
                                                        }
                                                    }
                                                    item[prop] = parseFloat(val);
                                                }
                                            }

                                            // If the item has an undefined return date and we are in returning mode, default it to today.
                                            if (item.tReturnDate === undefined && isReturning)
                                                item.tReturnDate = (new Date());

                                            var gridItem = result.ToolAssignmentGrid[index];
                                            var cacheItem = result.ToolAssignmentRecords[index];

                                            grid.getStore().add(new Ext.data.Record(gridItem));
                                            loadExDataNoUIUpdate(gridItem.nToolAssignmentUID);
                                            cached[cached.length] = cacheItem;
                                        });

                                    }
                                });

                                findWindow.close();
                            });
                        }
                    },
                    {
                        id: 'btnDeleteSm',
                        xtype: 'button',
                        iconCls: 'btn-delete-sm',
                        tooltip: ___('REMOVE_SELECTED_ASSET_FROM_LIST_TOOLTIP'),
                        x: 650,
                        y: 35,
                        disabled: <%= (!editMode && !Model.IsReceiving).ToString().ToLower() %>,
                        handler: function () {
                            var grid = Ext.getCmp('fillGrdAssignments');
                            if (grid === undefined) return;

                            var store = grid.getStore();
                            var count = store.getCount();
                            if (count === 1) {
                                Ext.Msg.alert(___('ATTENTION_TITLE'), ___('AT_LEAST_ONE_ASSET_SELECTED_MSG'));
                                return;
                            }

                            var sm = grid.getSelectionModel();
                            var record = sm.getSelected();
                            if (record === undefined) return;
                            for (var i = 0; i < cached.length; i++) {
                                if (cached[i] !== undefined) {
                                    if (cached[i].nToolAssignmentUID === record.get('nToolAssignmentUID') && cached[i].nAssetUID === record.get('nAssetUID')) {
                                        cached[i] = undefined;
                                    }
                                }
                            }


                            sm.selectNext();
                            grid.getStore().remove(record);

                            if (sm.getSelected() === undefined)
                                sm.selectPrevious();

                            if (sm.getSelected() !== undefined) {
                                grid.fireEvent('rowclick', grid, null, null);
                            }
                        }
                    },
                    {
                        xtype: 'button',
                        id: 'btnModifyAsset',
                        iconCls: 'btn-modify-sm',
                        tooltip: ___('MODIFY_SELECTED_ASSET_TOOLTIP'),
                        x: 650,
                        y: 65,
                        disabled: <%= (!editMode&& !Model.IsReceiving).ToString().ToLower() %>,
                        handler: function () {

                            var grid = Ext.getCmp('fillGrdAssignments');
                            if (grid === undefined) return;

                            var sm = grid.getSelectionModel();
                            var record = sm.getSelected();
                            if (record === undefined) return;

                            if (record.get('nAssetUID') === undefined) return;

                            var findWindow = app.openWindow({
                                title: ___('EDIT_ASSET'),
                                url: '<%: Url.Content( "~/Asset/Edit" ) %>/' + record.get('nAssetUID')
                            });
                        }
                    },
                    {
                        xtype: 'tabpanel',
                        activeTab: 0,
                        x: 10,
                        y: 220,
                        width: 635,
                        height: 265,
                        items: [
                            {
                                xtype: 'panel',
                                title: ___('GENERAL'),
                                tabTip: ___('GENERAL'),
                                height: 220,
                                layout: 'absolute',
                                items: [
                                    {
                                        xtype: 'container',
                                        x: 0,
                                        y: 0,
                                        height: 220,
                                        layout: 'absolute',
                                        width: 635,
                                        items: [
                                            <%= Html.Label( model => toolAssignment.nContactUID, new { X = 5, Y = 5, ReadOnly = !editMode }) %>
                                            ,<%= Html.Lookup( model => toolAssignment.nContactUID, "FullName", new { TabIndex = 1, X = 5, Y = 20, Width = 300, ShowEditButton = true, ReadOnly = !editMode }) %>
                                            ,<%= Html.Label( model => toolAssignment.tLoanDate, new { X = 5, Y = 45, ReadOnly = true }) %>
                                            ,<%= Html.Field( model => toolAssignment.tLoanDate, new { X = 5, Y = 60, Width = 150, ReadOnly = true }) %>
                                            ,<%= Html.Label( model => toolAssignment.tExpectedReturnDate, new { TabIndex = 1, X = 160, Y = 45, ReadOnly = !editMode }) %>
                                            ,<%= Html.Field( model => toolAssignment.tExpectedReturnDate, new { X = 160, Y = 60, Width = 150, ReadOnly = !editMode, Listeners = "dateListener"}) %> 
                                            ,<%= Html.Label( model => toolAssignment.tReturnDate, new { X = 315, Y = 45, ReadOnly = editMode }) %>
                                            ,<%= Html.Field( model => toolAssignment.tReturnDate, new { X = 315, Y = 60, Listeners = "returnDateListener", Width = 150, ReadOnly = (isReceiving == 0) ? true : false}) %>
                                            ,<%= Html.Label( model => toolAssignment.nUseCount, new { X = 5, Y = 85, ReadOnly = !editMode }) %>
                                            ,<%= Html.Field( model => toolAssignment.nUseCount, new { TabIndex = 2, X = 5, Y = 100, Width = 150, ReadOnly = !editMode }) %>
                                            ,<%= Html.Label( model => toolAssignment.cAssignmentNumber, new { X = 160, Y = 85, ReadOnly = !editMode }) %>
                                            ,<%= Html.Field( model => toolAssignment.cAssignmentNumber, new { X = 160, Y = 100, Width = 150, ReadOnly = true }) %>
                                            ,<%= Html.Label( model => toolAssignment.cAssignedLocation, new { X = 315, Y = 85, ReadOnly = !editMode }) %>
                                            ,<%= Html.Field( model => toolAssignment.cAssignedLocation, new { TabIndex = 3, X = 315, Y = 100, Width = 310, ReadOnly = !editMode }) %>
                                            ,<%= new ExtLabel("ToolAssignments", "nPastDue", new { X = 510, Y = 5, Width = 120, ReadOnly = !editMode }) %>
                                            ,<%= new ExtLabel("ToolAssignments", "nPastDue", new { ClientID = "nPastDue", Text = "0", X = 510, Y = 40, Style = "font-size: xx-large;font-weight: bold;padding-left: 10px;", Width = 60, Height = 60 }) %>

                                            ,<%= Html.Label( model => toolAssignment.mNotes, new { X = 5, Y = 128 } ) %>
                                            ,<%= new ExtButton( "ToolAssignments", "edit_mNotes" ) {
	                                            IconClass = "btn-notes-sm",
	                                            CSSClass = "x-btn-icon", 
	                                            Handler = "function() { editNotesField('mNotes'); }",
	                                            Text = "",
	                                            Tooltip = L.__("EDIT_NOTES_TOOLTIP"),
	                                            X = 603, Y = 125
                                            } %>
                                            ,<%= Html.Field( model => toolAssignment.mNotes, new { TabIndex = 4, X = 5, Y = 147, Width = 620, Height = 90 }) %>
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: ___('EXTENDED DATA'),
                                tabTip: ___('EXTENDED DATA'),
                                layout: 'fit',
                                height: 220,
                                width: 635,
                                items: [

				                   <%= ExtendedDataHtmlHelper.ExtendedDataGrid( "ToolAssignment", GuidHelper.KnownGuids.GuidNewRecord, new { ID = "ToolAssignmentEx", Height = 220, Width = 635, ColumnLines = true } ) %>
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: ___('Files'),
                                tabTip: ___('Files'),
                                height: 220,
                                width: 655,
                                layout: 'absolute',
                                disabled: <%: Html.IsFieldDisabled( "ToolAssignment", "pnlFiles" ).ToString().ToLower() %>,
                                items: [
      						        <%= new ExtButton( "ToolAssignmentFiles", "cmdAddFiles" ) { 
									        IconClass = "btn-add-sm",
									        CSSClass = "x-btn-icon", 
									        Handler = @"addToolAssignmentFile",
									        Text = "",
									        X = 595,
									        Y = 25,
									        Tooltip = L.__("ATTACH_EXISTING_FILE_TOOLTIP"),
									        Disabled = true,
									        XType = "splitbutton",
									        Menu = new ExtMenu( "ToolAssignment", "mnuAddFiles", new { Items = new List<ExtMenu>() {
										        new ExtMenu( "ToolAssignment", "mnuAttachFile", new { Text = L.__("ATTACH_FILE_TITLE"), Handler = "addToolAssignmentFile" } ),
										        new ExtMenu( "ToolAssignment", "mnuUploadFile", new { Text = L.__("UPLOAD_FILE_TEXT"), Handler = "uploadToolAssignmentFile" } )
									        } } )
							        } %>,
							        <%= new ExtButton( "ToolAssignmentFiles", "cmdDeleteFiles" ) { 
								        IconClass = "btn-delete-sm",
								        CSSClass = "x-btn-icon", 
								        Handler = @"deleteToolAssignmentFile",
								        X = 595,
								        Y = 45,
								        Text = "",
								        Tooltip = L.__("DELETE_SELECTED_FILE_TOOLTIP"),
								        Disabled = true
							        } %>,
							        <%= new ExtButton( "ToolAssignmentFiles", "cmdModifyFiles" ) { 
								        IconClass = "btn-modify-sm",
								        CSSClass = "x-btn-icon", 
								        Handler = @"modifyToolAssignmentFile",
								        X = 595,
								        Y = 65,
								        Text = "",
								        Tooltip = L.__("MODIFY_SELECTED_FILE_TOOLTIP"),
								        Disabled = true
							        } %>,
							        <%= new ExtButton( "ToolAssignmentFiles", "cmdViewFiles" ) { 
								        IconClass = "btn-modify2-sm",
								        CSSClass = "x-btn-icon", 
								        Handler = @"viewToolAssignmentFile",
								        X = 595,
								        Y = 85,
								        Text = "",
								        Tooltip = L.__("VIEW_SELECTEDFILE_TOOLTIP"),
								        Disabled = true
							        } %>,
							        <%= Html.RenderGrid( "FillgrdToolAssignmentFiles", new { ID = "grdToolAssignmentFiles", Listeners = "grdToolAssignmentFileListener", Width = 590, Height = 220, PageSize = 150000, RemoteSort = false }, new string[] { ViewData["SelectedToolAssignmentRecord"] == null ? GuidHelper.KnownGuids.GuidNewRecord.ToString() : ViewData["SelectedToolAssignmentRecord"].ToString() }) %>
                                ]
                            }
                        ]
                    }
                ]
            }];
            this.tbar = {
                xtype: 'toolbar',
                border: false,
                frame: false,
                margin: 0,
                padding: 0,
                defaults: {
                    scale: 'large',
                    iconAlign: 'top',
                    cls: 'x-btn-icon-text',
                    width: 50,
                    height: 50
                },
                items: [
                    {
                        xtype: 'button',
                        text: ___('FIND'),
                        tooltip: ___('FIND'),
                        iconCls: 'tb-find',
                        id: 'btnFind',
                        handler: function () {
                            doToolAssignFind();
                        }
                    },
                    { xtype: 'menuseparator' },
                    {
                        xtype: 'splitbutton',
                        text: ___('PRINT'),
                        tooltip: ___('PRINT'),
                        id: 'btnPrint',
                        iconCls: 'tb-print',
                        handler: function () { PrintData("Print"); },
                        menu: new Ext.menu.Menu({
                            items: [
                                {
                                    text: ___('PRINT'),
                                    handler: function () { PrintData("Print"); },
                                    tabTip: ___('PRINT')
                                },
                                {
                                    text: ___('EXPORT'),
                                    handler: function () { PrintData("Export"); },
                                    tabTip: ___('EXPORT')
                                }
                            ]
                        })
                    },
                    {
                        xtype: 'button',
                        text: ___('Check In'),
                        tooltip: ___('Check In'),
                        id: 'btnReturning',
                        iconCls: 'tb-grid',
                        handler: function () {
                            doToolAssignFind(true);
                        }
                    },
                    { xtype: 'menuseparator' },
                    {
                        xtype: 'button',
                        text: ___('Check Out'),
                        tooltip: ___('Check Out'),
                        id: 'btnAdd',
                        iconCls: 'tb-add',
                        handler: function () {
                            doAdd();
                        }
                    },
                    {
                        xtype: 'button',
                        text: ___('DELETE'),
                        tooltip: ___('DELETE'),
                        id: 'btnDelete',
                        iconCls: 'tb-delete',
                        handler: function () {

                            var grid = Ext.getCmp('fillGrdAssignments');
                            if (grid === undefined) return;

                            var sm = grid.getSelectionModel();
                            var record = sm.getSelected();
                            if (record === undefined) return;

                            Ext.Msg.confirm(___('WARNING_TITLE'), ___('DELETE_RECORD_MSG'), function (btn) {

                                if (btn === "yes") {
                                    var id = record.get('nToolAssignmentUID');

                                    $.ajax({
                                        url: '/ToolAssignment/Delete/' + id,
                                        type: 'POST',
                                        dataType: 'json',
                                        success: function (result) {
                                            if (result.success) {
                                                for (var i = 0; i < records.length; i++) {
                                                    var row = records[i];
                                                    if (row.nToolAssignmentUID === record.get('nToolAssignmentUID') && row.nAssetUID === record.get('nAssetUID')) {
                                                        records[i] = undefined;
                                                    }
                                                }
                                                grid.getStore().remove(record);
                                            }
                                            Ext.Msg.alert(___('ATTENTION_TITLE'), result.message);
                                        }
                                    });
                                }

                            });

                        }

                    },
                    { xtype: 'menuseparator' },
                    {
                        xtype: 'button',
                        type: 'submit',
                        id: 'btnSave',
                        text: ___('SAVE'),
                        tooltip: ___('SAVE'),
                        iconCls: 'tb-save',
                        handler: this.doSubmit
                    },
                    {
                        xtype: 'button',
                        text: ___('CANCEL'),
                        tooltip: ___('CANCEL'),
                        id: 'btnCancel',
                        iconCls: 'tb-cancel',
                        handler: function () {
                            clientWindow.refresh();
                        }
                    },
                    { xtype: 'menuseparator' },
                    {
                        xtype: 'button',
                        text: ___('CLOSE'),
                        id: 'btnClose',
                        tooltip: ___('CLOSE'),
                        iconCls: 'tb-close',
                        handler: function () {
                            clientWindow.close();
                        }
                    }
                ]
            };
            editForm.superclass.initComponent.call(this);
        },

            doSubmit: function () {

                function doSubmitAction() {
                    saveData(false);    // do not save ext data!
                    var form = window.form.getForm();

                    if (!returnDateCustomValidator(false))
                        return;

                    // Performs client-side validation
                    if (!form.isValid()) {
                        return;
                    }

                    app.showBusyStatus(___('SAVING_INFORMATION') + " <%: Html.GetTable( Model ) %> ", true);
                    var msg = Ext.MessageBox.wait(___('UPDATING_DATA_TITLE'), ___('ATTENTION_TITLE'));
                    var submitData = new Array();

                    Ext.each(cached, function (item) {
                        if (item !== undefined) {

                            // Don't send these values.
                            item.tAddTime = undefined;
                            item.tUpdateTime = undefined;
                            item.tSystemUpdateTime = undefined;
                            item.tMobileTime = undefined;

                            // IE Compatibility.
                            if (isNaN(item.tReturnDate) || item.tReturnDate === null || item.tReturnDate === undefined)
                                item.tReturnDate = '';

                            // IE Compatibility.
                            if (isNaN(item.tExpectedReturnDate) || item.tExpectedReturnDate === null || item.tExpectedReturnDate === undefined)
                                item.tExpectedReturnDate = '';

                            submitData.push(item);
                        }
                    });

                    // prompt for password/reason FIRST if auditing is on, then save the record and update the reason afterwards.

                    msg.hide();

                    function saveRecord(submitData, updateReason, reason) {
                        $.ajax({
                            type: 'post',
                            url: '/ToolAssignment/Edit',
                            dataType: 'json',
                            data: {
                                __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                                modelsJson: JSON.stringify(submitData),
                                updateAssets: isReturning
                            },
                            success: function (result) {
                                if (updateReason) {
                                    $.ajax({
                                        url: '/Auditing/DoUpdateReason',
                                        type: 'post',
                                        async: false,
                                        data: {
                                            __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                                            reason: reason,
                                            tableName: 'ToolAssignments'
                                        }
                                    });
                                }
                                showSuccessMessage();
                            }
                        });

                    }

                    function showSuccessMessage() {
                        Ext.Msg.alert(___('SUCCESS'), ___('RECORDS_SUCCESSFULLY_UPDATED_MSG'), function () {
                            window.location = window.location + "&isLoaded=true";
                        });
                    }

                    // handle auditing / change tracking
                    if ((this.disableAuditing || false) == false) {
                        var doAudit = window["auditingEnabled"] || window.parent["auditingEnabled"] || false;
                        if (doAudit.toString() == 'true') {

                            function onSuccess(reason) {
                                saveRecord(submitData, true, reason);
                            }

                            function onFail() {
                                Ext.Msg.alert(__('ATTENTION_TITLE'), __('INCORRECT_PASSWORD_PLEASE_TRY_AGAIN'));
                                return false;
                            }

                            auditing._prompt(onSuccess, onFail);

                        } else {
                            var doChangeTracking = (window["changeTrackingEnabled"] || window.parent["changeTrackingEnabled"] || false).toString();
                            saveRecord(submitData, (doChangeTracking == 'true'), null);
                        }
                    }
                    else
                        saveRecord(submitData, false, null);
                }

                saveData(true);  // call saveData as current items may have changed and the newly changed data would not be accessible to the DataCheck

                executeDataChecks(function (obj) {
                    if (obj.pass) {
                        doSubmitAction();
                    }
                });
            }
        });

        function executeDataChecks(callback) {
            let obj = [];
            let assetsGrid = Ext.getCmp('fillGrdAssignments');
            let index = 0;

            // For each asset ...
            assetsGrid.getStore().each(function (itm) {
                let formData = {};
                let assetUID = itm.get('nAssetUID');
                let objToolAssignment = null;

                if (cached !== undefined) {
                    for (let i = 0; i < cached.length; i++) {
                        let record = cached[i];
                        if (record !== undefined) {
                            if (record.nAssetUID == assetUID) {

                                let result = formatData(record);

                                formData = {
                                    nToolAssignmentUID: record.nToolAssignmentUID,
                                    nContactUID: result.record.nContactUID,
                                    cAssignmentNumber: result.record.cAssignmentNumber,
                                    cAssignedLocation: result.record.cAssignedLocation,
                                    nUseCount: result.record.nUseCount,
                                    mNotes: result.record.mNotes,
                                    tLoanDate: result.record.tLoanDate, 
                                    tReturnDate: result.record.tReturnDate,
                                    tExpectedReturnDate: result.record.tExpectedReturnDate,
                                };

                                break;
                            }
                        }
                    }
                }

                $.ajax({
                    url: '/ToolAssignment/GetDataCheckModel',
                    type: 'post',
                    dataType: 'json',
                    async: false,
                    data: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                        data: JSON.stringify(formData)
                    },
                    success: function (result) {
                        objToolAssignment = (result !== undefined && result !== null) ? result : formData;
                    }
                });


                $.ajax({
                    url: '/ToolAssignment/GetAssetModel',
                    type: 'post',
                    dataType: 'json',
                    async: false,
                    data: {
                        __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                        nAssetUID: assetUID
                    },
                    success: function (result) {
                        if (result !== undefined && result !== null) {
                            obj[index] = result;
                            obj[index].ToolAssignment = objToolAssignment;
                        }
                    }
                });

                index++;
            });

            DataCheck.ExecuteBatch(obj, "ToolAssignments", callback);
        }

        var grdToolAssignmentFileListener = {
            render: function (grid) {
                grid.getSelectionModel().on("selectionchange", function (selModel) {
                    updateToolAssignmentFileButtons();
                });
            },
        };

        function addToolAssignmentFile() {
            var grid = Ext.getCmp("grdToolAssignmentFiles");

            var findWindow = app.openWindow({
            title: ___('FIND_FILE_TITLE'),
                url: '/Shared/Find/?Type=Tool Assignment',
                modal: true,
                callbacks: {
                context: 'FindFiles',
                    controller: 'File',
                    persistFindScreenOnAdd: 'true',
                    onRecordSelected: function (record) {
                        var id = record.get("UID");
                        findWindow.close();
                        attachFile(id);
                    }
                }
            });

        }

        function uploadToolAssignmentFile() {
            var dialog = app.openWindow({
            title: ___('ADD_FILE'),
                url: '<%: Url.Content( "~/File/Create/" ) %>?FileType=Tool%20Assignment',
            modal: true,
            width: 385,
            height: 240,
            callbacks: {
                onSave: function (recordID) {
                    var id = recordID;
                    dialog.close();
                    attachFile(id);
                }
            }
        });
        }

        function attachFile(id) {
            var grid = Ext.getCmp("grdToolAssignmentFiles");
            var store = grid.getStore();
            var selectionModel = grid.getSelectionModel();
            var actionUrl = '<%: Url.Content( "~/ToolAssignment/AttachFile/" ) %>';
            app.call({
                url: actionUrl,
                contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                    toolAssignmentID: lastToolId,
                    fileID: id
                },
                success: function (result) {
                    if (loadToolAssignmentFilesGrid(lastToolId))
                    {
                        var recordIndex = store.find("nToolAssignmentFileUID", result.id);
                        if (recordIndex >= 0) {
                            setTimeout(function () {
                                selectionModel.selectRow(recordIndex);
                            }, 1);

                            updateToolAssignmentFileButtons();
                        }
                    }
                },
                error: function (err) {
                    debugger;
                    Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                }
            });
        }

        function loadToolAssignmentFilesGrid(id) {
            var grid = Ext.getCmp("grdToolAssignmentFiles");
            var store = grid.getStore();
            var actionUrl = '<%: Url.Content( "~/ToolAssignment/GetToolAssignmentFilesGridData/" ) %>';
            app.call({
                url: actionUrl,
                contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                    toolAssignmentID: id,
                    listener: 'grdToolAssignmentFileListener'
                },
                success: function (result) {
                    if (result === undefined) {
                        Ext.Msg.alert(___('COULD_NOT_LOAD_GRID_DATA_ERRORMSG'));
                        return false;

                    } else {
                        store.loadData(result);

                        updateToolAssignmentFileButtons();
                        return true;
                    }
                },
                error: function (err) {
                    debugger;
                    Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                    return false;
                }
            });

        }

        function deleteToolAssignmentFile() {
            var grid = Ext.getCmp("grdToolAssignmentFiles");
            var selectionModel = grid.getSelectionModel();
            var record = selectionModel.getSelected();
            var id = record.get("nToolAssignmentFileUID");

            Ext.Msg.confirm(___('DELETE_RECORD_TITLE'), ___('REMOVE_FILE_MSG'), function (btn) {
                if (btn != "yes")
                    return;

                var actionUrl = '<%: Url.Content( "~/ToolAssignment/RemoveToolAssignmentFile/" ) %>';
            app.call({
                url: actionUrl,
                contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                data: {
                    __RequestVerificationToken: getWindowAntiForgeryTokenValue(),
                    toolAssignmentFileID: id
                },
                success: function (result) {
                    if (result.success) {
                        grid.getStore().remove(record);
                        updateToolAssignmentFileButtons();
                        Ext.Msg.alert(___("SUCCESS"), result.message);
                    }
                },
                error: function (err) {
                    debugger;
                    Ext.Msg.alert(___('UNKNOWN_ERROR_TITLE'), ___('UNEXPECTED_SERVER_RESPONSE_ERROR_MSG'));
                }
            });

        });

        }

        function modifyToolAssignmentFile() {
            var grid = Ext.getCmp("grdToolAssignmentFiles");
            var selectionModel = grid.getSelectionModel();
            var record = selectionModel.getSelected();
            var id = record.get("nFileUID");

            app.openWindow(
                {
                    title: ___('EDIT_FILE'),
                    url: '<%= Url.Content( "~/File/Edit/" ) %>' + id,
                width: 515,
                height: 330,
                modal: true,
                maximizable: false,
                minimizable: false,
                callbacks: {

                }
            });

        }

        function viewToolAssignmentFile() {
            var grid = Ext.getCmp("grdToolAssignmentFiles");
            if (grid === undefined) return;

            var selectionModel = grid.getSelectionModel();
            var record = selectionModel.getSelected();
            if (record === undefined) return;

            var id = record.get("nFileUID");

            if (id === undefined) return;

            File.Open(id);
        }

        function updateToolAssignmentFileButtons() {
            var grid = Ext.getCmp("grdToolAssignmentFiles");
            var selectionModel = grid.getSelectionModel();
            var hasSelection = selectionModel.getCount() > 0;

            Ext.getCmp("cmdAddFiles").setDisabled(lastToolId <= 0);
            Ext.getCmp("cmdDeleteFiles").setDisabled(!hasSelection || lastToolId <= 0);
            Ext.getCmp("cmdModifyFiles").setDisabled(!hasSelection || lastToolId <= 0);
            Ext.getCmp("cmdViewFiles").setDisabled(!hasSelection || lastToolId <= 0);
        }

        function setupExDataOnUpdateEvent() {
            
            var grid = Ext.getCmp('ToolAssignmentEx');
            if (!grid) 
                return;

            grid.getStore().on('update', function (store, record, operation) {
                
                if (operation === Ext.data.Record.COMMIT) {  // Only respond to 'commit' operations

                    // Get the fillGrdAssignments grid
                    var assignGrid = Ext.getCmp("fillGrdAssignments");
                    if (!assignGrid) return;

                    var sm = assignGrid.getSelectionModel();
                    if (!sm) return;

                    var taRec = sm.getSelected();
                    if (!taRec || !taRec.exData || !taRec.exData.rows) return;

                    // Loop through extended data rows
                    Ext.each(taRec.exData.rows, function (item) {
                        if (item.id == record.id && item.field === record.get('field'))
                            item.value = record.get('value');
                    });
                }
            });
        }

        var form = new editForm();

        Ext.onReady(function () {

            var body = Ext.get(document.body);

            // get the History Log button control.
            var tool = clientWindow.windowObj.getTool("audit");

            // hide the History Log button control on Add screen.
            if (tool)
            '<%= !(Model.ToolAssignmentGrid.Count() > 0) %>' === 'True' ? tool.hide() : tool.show();

        form.render(body);
        editWindow.initForm(form, myTable);
        clientWindow.setIcon("window-icon-default");
        clientWindow.setSize(700, 590);

        onDataDirtyChanged();

        // Update the date components so they are registered when the save button is pressed.
        for (var i = 0; i < cached.length; i++) {

            if (!isNaN(new Date(cached[i].tLoanDate)))
                cached[i].tLoanDate = new Date(cached[i].tLoanDate);
            else
                cached[i].tLoanDate = new Date();

            if (!isNaN(new Date(cached[i].tExpectedReturnDate)))
                cached[i].tExpectedReturnDate = new Date(cached[i].tExpectedReturnDate);
            else
                cached[i].tExpectedReturnDate = '';

            if (isReturning && cached[i].tReturnDate !== undefined) {
                cached[i].tReturnDate = new Date(cached[i].tReturnDate);

            } else if (isReturning) {

                cached[i].tReturnDate = new Date();

            } else {

                if (cached[i].tReturnDate !== undefined)
                    cached[i].tReturnDate = new Date(cached[i].tReturnDate);
                else
                    cached[i].tReturnDate = '';

            }
        }

       setupExDataOnUpdateEvent();                                                    

        // if we are in Check-in mode (returning), lets make all rows in the extended data grid readonly('blue') and then we must remove the event handler for double click (handled by: EmxWeb.ExtendedData.js onRowDoubleClick)
        if (isReturning) {
            
            var grid = Ext.getCmp('ToolAssignmentEx');
            if (grid) {
                grid.getView().getRowClass = function (record, index) {
                    return 'readonly';     // apply the 'readonly' class to every row
                };
                grid.getView().refresh();  // re-render the grid to apply the row class
            }

            grid.un('rowdblclick', ExtendedData.onRowDoubleClick); // Remove doubleclick handler
        }

        if (isLoaded) {
            Ext.getCmp('mNotes').setDisabled(true);
            Ext.getCmp('tReturnDate').setReadOnly(true);
            Ext.getCmp('tReturnDate').getEl().addClass("readonly");
            Ext.getCmp('btnDeleteSm').setDisabled(true);
            Ext.getCmp('btnAddSm').setDisabled(true);
            Ext.getCmp('edit_mNotes').setDisabled(true);

            editWindow.clearDataDirty();
        }
        else if (isReturning)
            editWindow.setDataDirty();

        clientWindow.windowObj.on("message", function (tag, data) {

            // Do our best to ignore messages that originated in this window
            if (data.sender && data.sender == editForm) {
                return;
            }

            if (tag === "labelchanged" && data.table === myTable) {
                var field = editWindow.getField(data.column);
                if (field) {
                    field.setLabel(data.text);
                }
            }
            else if (tag === "recordchanged" && data.table === myTable) {
                if (data.id == recordID) {
                    // NOTE: Using Ext.Msg.alert() instead of app.showAlert() means that 
                    // only this edit window will be blocked while the dialog is displayed.
                    Ext.Msg.alert(___('RECORD_CHANGED_TITLE'), ___('RECORD_CHANGED_MSG'));
                }
            }

        });
    });

        Ext.override(Ext.grid.GridPanel, {
            viewConfig: {
                getRowClass: function (record, index) {
                    if (isLocked) {
                        return 'readonly';
                    }
                }
            },
            style: function () {
                if (isLocked) {
                    return 'background:#c9ddf2;';
                }
            }
        });

        Ext.override(Ext.form.TextArea, {
            renderTo: document.body,
            style: function () {
                if (isLocked) {
                    return 'background:#c9ddf2;';
                }
            },
            listeners: {
                afterrender: function () {
                    if (isLocked) {
                        this.getEl().setStyle('readonly');
                    }
                }
            }
        });

    </script>

</asp:Content>

