//Version 1.3.7
/*
 * This is a demo player script for showcasing the webcast solution.
 * Please note the functions
 * 1. sendProgress
 * and
 * 2. GotoStep
 * Use these functions to record and reproduce the presentation progress.
 */
window.onload = function () {

    var init_slide = 1,
        isPresenter,
        presPath = 'data/';

    var window = this;

    var document = window.document;

    var getElementById = function(id) {
        return document.getElementById(id);
    };

    var getElementsByTagName = function(tagName, parent) {
        if(parent) {
            return parent.getElementsByTagName(tagName);
        } else {
            return document.getElementsByTagName(tagName);
        }
    };

    isPresenter = getElementsByTagName('body')[0].dataset.presenter === 'true';

    var firstLoaded = false, presSettings = {}, isTouchDevice, Presentation, isPlaying = false;

    var eventsHandler = function() {
        this.OnLoadingStart = function() {
            getElementById('loadingImg').style.display = 'block';
        };

        this.OnLoadingEnd = function(loadedSlideIndex) {

            getElementById('loadingImg').style.display = 'none';

            if (!firstLoaded) {

                firstLoaded = true;

                getElementById('btnPrev').onclick = Presentation.Prev;
                getElementById('btnNext').onclick = Presentation.Next;
                getElementById('btnNxtSlide').onclick = Presentation.NxtSlide;
                getElementById('btnPrvSlide').onclick = Presentation.PrvSlide;
                getElementById('btnGoto').onclick = function() {

                    var inputSlide = getElementById('inputSlide').value;
                    var slideIndex = parseInt(inputSlide, 10);

                    if (isNaN (slideIndex)) {
                        return;
                    }

                    var inputStep = getElementById('inputStep').value;
                    var animStep = parseInt(inputStep, 10);

                    var inputDirectJump = getElementById('cboxDirect').checked;

                    //for webcast
                    if (isNaN(slideIndex)) {
                        Presentation.GotoSlide(slideIndex);
                        sendProgress(false, slideIndex);
                    } else {
                        Presentation.JumpToAnim(animStep, slideIndex, !inputDirectJump);
                        sendProgress(animStep, slideIndex, !inputDirectJump);
                    }
                };
            }
        };

        //webcast note this part
        //This event handles the slide change event
        this.OnSlideChange = function(slideNo) {

            var currentStatus = Presentation.CurrentStatus();

            //Check if report progress is true.
            //If false the progress is not to be reported as the progress is
            //triggered by JumpToAnim slide change. Storing this would break the
            //progress/timeline in audience view.
            var reportProgress = Presentation.ReportProgress();
            if(reportProgress) {
                sendProgress(currentStatus.step, slideNo);
            }
            getElementById('inputSlide').value = slideNo;
            getElementById('totalSlides').value = ' / ' + presSettings.TotalSlides;
            getElementById('inputStep').value = currentStatus.step;
            getElementById('totalSteps').value = ' / ' + Presentation.ClickCount();
        };

        //webcast note this part
        this.OnMovToNxtAnim = function(step) {
            //here we can get the step to which presenter is progressed to.
            var reportProgress = Presentation.ReportProgress();
            if(reportProgress) {
                sendProgress(step, Presentation.CurrentStatus().slide, true);
            }
            getElementById('inputStep').value = step;
            getElementById('totalSteps').value = ' / ' + Presentation.ClickCount();
        };

        //webcast note this part
        this.OnMovToPrvAnim = function(step) {
            //here we can get the step to which presenter is progressed to.
            var reportProgress = Presentation.ReportProgress();
            if(reportProgress) {
                sendProgress(step, Presentation.CurrentStatus().slide, true);
            }
            getElementById('inputStep').value = step;
            getElementById('totalSteps').value = ' / ' + Presentation.ClickCount();
        };

        this.OnPlayingStart = function() {
            isPlaying = true;
        };

        this.OnPlayingEnd = function() {
            isPlaying = false;
        };

        this.OnProgressChange = function(t) {
        };

        this.OnSlideEnd = function (slideIndex, presEnd) {};

        this.OnSldOutlineLoad = function (o) {
            //console.log(o);
        };

        this.InitaliseSettings = function(o) {
            presSettings = o;
            AtInit();
        };
    };

    function AtInit(){
        var contentHolder = getElementById('contentHolder');
        contentHolder.style.width = presSettings.Width + 'px';
        contentHolder.style.height = presSettings.Height + 'px';
        //getElementsByTagName('body')[0].style.backgroundColor = presSettings.BackColr;
        resizeSlide();
        window.onresize = resizeSlide;
        function resizeSlide() {

            var slideHeight = presSettings.Height,
                slideWidth  = presSettings.Width;

            var contentHolder = getElementById('contentHolder');

            var windowHeight    = window.innerHeight;
            var windowWidth     = window.innerWidth;

            var slideRatio  = slideWidth / slideHeight;
            var windowRatio = windowWidth / windowHeight;

            var scale   = (windowRatio > slideRatio) ? (windowHeight / slideHeight) : (windowWidth / slideWidth);

            var scaledHeight    = slideHeight * scale;
            var scaledWidth     = slideWidth * scale;

            contentHolder.style.height  = scaledHeight + 'px';
            contentHolder.style.width   = scaledWidth+ 'px';

            var contentLeft = (windowWidth - scaledWidth) / 2;
            //var contentTop  = (windowHeight - scaledHeight) / 2;

            contentHolder.style.marginLeft = contentLeft + 'px';
            //contentHolder.style.marginTop = contentTop + 'px';

            var resizer = getElementById('resizer');
            resizer.style.transform = 'scale(' + scale + ')';

            var loadingImg = getElementById('loadingImg');
            loadingImg.style.width = scaledWidth + 'px';
            loadingImg.style.height = scaledHeight + 'px';

            var controls = getElementById('controls');
            controls.style.top = scaledHeight + 'px';

            var controlHeight = controls.clientHeight;
            parent.SetFrameHeight(scaledHeight + controlHeight);
        }
    }

    //use this function to recored the progress of presenter.
    //step, slide and play previous
    function sendProgress(step, slide, playPrevious) {
        //iPresenter is defined in player html
        if(isPresenter) {
            if (parent.Webcast)
              parent.Webcast.RecieveProgress(step, slide, playPrevious);
        }
    }

    //use this function to transfer the progress to audience.
    //step, slide and play previous
    window.GotoStep = function(step, slide, playPrevious) {
        if(!firstLoaded) {
            return;
        }
        //isPresenter is defined in player html
        if(!isPresenter) {
            if(step !== false) {
                Presentation.JumpToAnim(step, slide, playPrevious);
            } else {
                Presentation.GotoSlide(slide);
            }
        }
    };

    //Check if HTML5 is supported
    if (!(document.createElement('canvas').getContext)) {
        getElementById('resizer').innerHTML = '';
        document.body.innerHTML = 'Oops! Your browser does not support HTML5. You need to upgrade your browser to view this content.';
        return;
    }

    var step = 0;
    var backgroundColor = "";

    var options = {
        //playTransitionOnLoad: false,
        //OutputFileExtension: '.bin',
        //false if 0, true if 1, mixed if -1
        //showCenterPlayButton: -1,
        playAnimationsOnLoad: true,
        skipBlankSlide: true,
        jumpTo: {
            step: step,
            playPrev: true
        },
        /*resetAllSlide: true,*/
        dgradeAnim: false,
        disablePinchZoom: false,
        /*fileRequestArgument: "tkn=1505331010_4f16fa003936d5e4b5359729b3d4228fd57f59263fcf0b1eb3a79086618e2e0a",*/
        /*fileRequestArguments: argObject,*/
        dgradeAnim: false,
        bcolor: backgroundColor,
        respectHiddenSlideStatus: true,
        mediaCrossOrigin: ""
    };

    //options.container = getElementById('contentHolder');
    Presentation = new DopPresentation(new eventsHandler(), options);
    window.Presentation = Presentation;
    //press path is defined in player html file
    Presentation.SetRPath(presPath);
    try {
        document.createEvent('TouchEvent');
        isTouchDevice = true;
    } catch (err) {
        isTouchDevice = false;
    }
    //init_slide is defined in player html
    Presentation.LoadPres('pres', init_slide);
};
