%This MatLab script plots the results from a simulation and creates png and eps files.
%Use the "Export Sim" function for each experiment
%Below edit the input_dir to specify the location of you file. 
%Note different directory formats for Windows and Mac
%NO SPACES ARE ALLOWED IN DIRECTORY OR FILE NAMES
%Edit filename to specify the root of the filename (ignore the .sim.txt and
%.dat.txt parts.  Edit the xlabel and ylabel below. 

close all;
clear all;

%%%%%%% Input %%%%%%%
%input_dir='c:\KinTekExplorer\'; % Directory location of input file in PC format
%input_dir='/Volumes/Disk_1/KinTekExplorer/'; % Directory location of input file
%input_dir='/Users/kennethjohnson/Desktop/Jessica';
%filename='WTdTTP'  % Input file name
input_dir='\tmp';
filename='ssb4_exp2'  % Input file name

cd(input_dir); 
data=importdata([filename, '.data.txt']);
sim=importdata([filename,'.sim.txt']);

%set up colors
colorarray=get(gca,'colororder');
colorarray(1,1:end)=[1 0 0]; colorarray(3,1:end)=[0 0 1];
colorarray(6,1:end) = [.3 .8 .4]; colorarray(7,1:end) = [.2 .4 .7]; %RGB color 
colorarray = [colorarray;.8 0 .4;.2 1 .2;.4 .4 1;.5 0 .5;.5 .7 0;.8 0 .6;...
    1 .4 .4;0 .5 .6; 0 .8 .8;.9 .4 .9;.8 .6 0; .6 .8 0;.6 .4 .4];
%for all black, remove % from next line.
%colorarray=colorarray*0

yend=length(data(1,1:end));
send=length(sim(1,1:end));
npts=length(data(1:end,1));
ymax=max(max(data(1:end,2:end)));
ymin=min(min(data(1:end,2:end)));
xmax=max(max(data(1:end)))


% Change dot size and axis scale according to number of points
if (npts < 50), ptsize=3.5; xmax=1.1*xmax; end;
if (npts > 49), ptsize=2.5; xmax=1.1*xmax; end;
if (npts > 99), ptsize=1.6; end;
%ptsize=4; %override point size auto selection
if sim(end,1)<xmax, xmax=sim(end,1); end;

% Make plot
figure(1);

if send==yend;  %data and simulation have a single time scale
    for yindex=2:yend
        icolor=colorarray(yindex-1,1:end); pcolor=icolor.*0.6; %plot color is a darker shade
        %g=bar(data(1:end,1),data(1:end,yindex)); hold on;
        %set(g,'EdgeColor',[0 0 0],'Linewidth',0.5,'FaceColor',[0.4 0.4 1],'BarWidth',1)
        g=plot(data(1:end,1),data(1:end,yindex),'o'); hold on;
        if (ptsize>2) 
            set(g,'MarkerEdgeColor','k', 'MarkerFaceColor', icolor,'Markersize',ptsize); 
        else
            set(g,'MarkerEdgeColor',icolor, 'MarkerFaceColor', icolor,'Markersize',ptsize)
        end;
        h=plot(sim(1:end,1),sim(1:end,yindex),'Linewidth', 1.6, 'Color', pcolor); hold on;
    end;
else; %data have multiple time scales
    ymax=0; ymin=0
    for sindex=1:send-1
        icolor=colorarray(sindex,1:end); pcolor=icolor.*0.75; %plot color is a darker shade
        h=plot(sim(1:end,1),sim(1:end,sindex+1),'Linewidth', 1.5, 'Color', pcolor); hold on;     
        yindex=2*sindex;
        g=plot(data(1:end,yindex-1),data(1:end,yindex),'o'); hold on;
        if (ptsize>2) 
            set(g,'MarkerEdgeColor','k', 'MarkerFaceColor', icolor,'Markersize',ptsize); 
        else
            set(g,'MarkerEdgeColor',icolor, 'MarkerFaceColor', icolor,'Markersize',ptsize)
        end;
        ymax=max(max(data(1:end,yindex)),ymax);
        ymin=min(min(data(1:end,yindex)),ymin);
        xmax=max(max(data(1:end,yindex-1)),xmax);
    end;
end;
set(gca,'fontsize',9,'linewidth',0.7);
set(gcf, 'PaperPositionMode', 'manual');
set(gcf, 'PaperUnits', 'inches');
set(gcf, 'PaperPosition', [.25 1 3.33 2.5]);


deltay = 0.1*(ymax-ymin); 
ymax=ymax+deltay; 
if (ymin~=0), ymin=ymin-deltay; end;
%ymin =0;  %to force the y-axis to be at zero. 
%xmax=4.001;  
    
%title(strcat('Simulation Output: ',filename))
xlabel('Time (s) ','fontsize',10);
ylabel('Fluorescence ','fontsize',10);
%ylabel('[Product] (nM) ','fontsize',11);%NOTE: leave 2 spaced for greek
%leters to be inserted in Adobe Illustrator using symbol font
axis([0 xmax ymin ymax]) %set xmin xmax ymin ymax for graphhold off;

% OUTPUT graph in selected format, jpeg, png, or epsc (color) or eps
%print(gcf, '-djpeg', strcat(filename,'_sim'))
print(gcf, '-dpng', strcat(filename,'_sim'))
print(gcf, '-depsc', strcat(filename,'_sim'))








