@echo off
REM !/bin/bash

SET PYVER=3.11

REM 1) clear
echo "<<<<<<<<<<<<<<<<< 1) clear-all"
uvx --python 3.11 -i https://pypi-official.argos-labs.com/simple alabs.ppm2 clear-all

REM 2) test
echo "<<<<<<<<<<<<<<<<< 2) test"
uvx --python 3.11 -i https://pypi-official.argos-labs.com/simple alabs.ppm2 --python-version %PYVER% test
IF NOT %ERRORLEVEL% == 0 (
	echo "test have error"
    goto errorExit
)

REM 3) check unique
echo "<<<<<<<<<<<<<<<<< 3) plugin unique"
uvx --python 3.11 -i https://pypi-official.argos-labs.com/simple alabs.ppm2 plugin unique
IF NOT %ERRORLEVEL% == 0 (
	echo "unique error"
    goto errorExit
)

REM 4) build
echo "<<<<<<<<<<<<<<<<< 4) build"
uvx --python 3.11 -i https://pypi-official.argos-labs.com/simple alabs.ppm2 --python-version %PYVER% build
IF NOT %ERRORLEVEL% == 0 (
	echo "build have error"
    goto errorExit
)

REM 5) upload to private repository
echo "<<<<<<<<<<<<<<<<< 5) upload"
uvx --python 3.11 -i https://pypi-official.argos-labs.com/simple alabs.ppm2 --python-version %PYVER% upload
IF NOT %ERRORLEVEL% == 0 (
	echo "upload have error"
    goto errorExit
)

echo "Build all success!"

: errorExit