#!/usr/bin/env bash

PYVER=3.11

# 1) clear
echo "<<<<<<<<<<<<<<<<< 1) clear-all"
uvx --python 3.11 -i https://pypi-official.argos-labs.com/simple alabs.ppm2 clear-all

# 2) test
echo "<<<<<<<<<<<<<<<<< 2) test"
uvx --python 3.11 -i https://pypi-official.argos-labs.com/simple alabs.ppm2 --python-version ${PYVER} test
if [ $? -ne 0 ];then
	RC=$?
	echo "test failed!"
	exit $RC
fi

# 3) check unique
echo "<<<<<<<<<<<<<<<<< 3) plugin unique"
uvx --python 3.11 -i https://pypi-official.argos-labs.com/simple alabs.ppm2 plugin unique
if [ $? -ne 0 ];then
	RC=$?
	echo "unique failed!"
	exit $RC
fi

# 4) build
echo "<<<<<<<<<<<<<<<<< 4) build"
uvx --python 3.11 -i https://pypi-official.argos-labs.com/simple alabs.ppm2 --python-version ${PYVER} build
if [ $? -ne 0 ];then
	RC=$?
	echo "build failed!"
	exit $RC
fi

# 5) upload to private repository
echo "<<<<<<<<<<<<<<<<< 5) upload"
uvx --python 3.11 -i https://pypi-official.argos-labs.com/simple alabs.ppm2 --python-version ${PYVER} upload
if [ $? -ne 0 ];then
	RC=$?
	echo "upload failed!"
	exit $RC
fi

echo "Build all success!"
