#!/usr/bin/env python
# coding=utf8
"""
====================================
 :mod:`argoslabs.demo.helloworld`
====================================
.. moduleauthor:: Jerry Chae <mcchae@argos-labs.com>
.. note:: ARGOS-LABS License

Description
===========
ARGOS LABS plugin module : unittest
"""

################################################################################
import os
import sys
from alabs.common.util.vvargs import ArgsError
from unittest import TestCase, TestSuite, TestLoader, TextTestRunner
# noinspection PyProtectedMember
from argoslabs.demo.helloworld import _main as main


################################################################################
class TU(TestCase):
    """
    TestCase for argoslabs.demo.helloworld
    """
    # ==========================================================================
    isFirst = True

    # ==========================================================================
    def test0000_init(self):
        self.assertTrue(True)

    # ==========================================================================
    def test0050_failure(self):
        """
        argoslabs.demo.helloworld
        :return: raise exception ArgsError
        """
        try:
            _ = main('-vvv')
            self.assertTrue(False)
        except Exception as e:
            sys.stderr.write('\n%s\n' % str(e))
            self.assertTrue(True)

    # ==========================================================================
    def test0100_success(self):
        """
        argoslabs.demo.helloworld tom jerry
        :return: True
        """
        try:
            r = main('tom', 'jerry')
            self.assertTrue(r == 0)
        except ArgsError as e:
            sys.stderr.write('\n%s\n' % str(e))
            self.assertTrue(False)

    # ==========================================================================
    def test0110_success_with_opt(self):
        """
        argoslabs.demo.helloworld tom jerry
        :return: True
        """
        outfile = 'stdout.txt'
        try:
            r = main('Tom', 'Jerry', '--opt', 'Brad',
                     '--outfile', outfile)
            self.assertTrue(r == 0)
            with open(outfile, encoding='utf-8') as ifp:
                rs = ifp.read()
                print(rs)
                self.assertTrue(rs == 'Hello world Tom,Jerry with Brad')
        except ArgsError as e:
            sys.stderr.write('\n%s\n' % str(e))
            self.assertTrue(False)
        finally:
            if os.path.exists(outfile):
                os.remove(outfile)

    # ==========================================================================
    def test9999_quit(self):
        self.assertTrue(True)


################################################################################
if __name__ == '__main__':
    print("🚀 plugin unittest starting...")
    print("=" * 60)
    
    test_suite = TestSuite()
    test_suite.addTest(TestLoader().loadTestsFromTestCase(TU))
    
    runner = TextTestRunner(verbosity=2)
    result = runner.run(test_suite)
    
    print("=" * 60)
    print("🏁 plugin unittest completed...")
    print(f"✅ success: {result.testsRun - len(result.failures) - len(result.errors)}")
    print(f"❌ failure: {len(result.failures)}")
    print(f"🚨 error: {len(result.errors)}")
    
    if result.failures or result.errors:
        sys.exit(1)
    else:
        print("🎉 all tests passed!")
        sys.exit(0)
