#!/bin/bash

if [ "$(id -u)" -ne 0 ]; then
    echo "Error: You must be root to install."
    exit 1
fi

TARGET_OLD="oobdaemon"
INSTALL_DIR_OLD="/usr/local/sbin"
CONF_DIR_OLD="/etc"
CONF_FILE_OLD="oobdaemon.conf"
SYSTEMD_SERVICE_OLD="oobdaemon.service"
SERVICE_PATH_OLD="/etc/systemd/system/$SYSTEMD_SERVICE_OLD"

TARGET="ermidaemon"
INSTALL_DIR="/usr/local/sbin"
CONF_DIR="/etc"
CONF_FILE="ermidaemon.conf"
SYSTEMD_SERVICE="ermidaemon.service"
SERVICE_PATH="/etc/systemd/system/$SYSTEMD_SERVICE"


# Check and remove old oobdaemon if it exists
if [ -f $INSTALL_DIR_OLD/$TARGET_OLD ]; then
    echo "Old oobdaemon found, removing..."
    # Stop old service if running
    if systemctl is-active --quiet $SYSTEMD_SERVICE_OLD; then
        echo "Stopping old oobdaemon service..."
        systemctl stop $SYSTEMD_SERVICE_OLD
    fi
    # Disable old service
    if systemctl is-enabled --quiet $SYSTEMD_SERVICE_OLD; then
        echo "Disabling old oobdaemon service..."
        systemctl disable $SYSTEMD_SERVICE_OLD
    fi
    # Remove old files
    rm -f $INSTALL_DIR_OLD/$TARGET_OLD
    rm -f $CONF_DIR_OLD/$CONF_FILE_OLD
    rm -f $SERVICE_PATH_OLD
    echo "Old oobdaemon removed."
fi

if [ -f $INSTALL_DIR/$TARGET ]; then
    echo "$INSTALL_DIR/$TARGET exists, updating binary only..."
    install -m 755 $TARGET $INSTALL_DIR
    # Restart daemon if running
    if systemctl is-active --quiet $SYSTEMD_SERVICE; then
        echo "ermidaemon service is running, restarting..."
        systemctl restart $SYSTEMD_SERVICE
    else
        echo "ermidaemon service is not running, starting..."
        systemctl start $SYSTEMD_SERVICE
    fi
    echo "Update complete."
    exit 0
else
    echo "$INSTALL_DIR/$TARGET does not exist, performing fresh install..."
    install -m 755 $TARGET $INSTALL_DIR
    install -m 644 $CONF_FILE $CONF_DIR/$CONF_FILE
    echo "Setting up systemd service..."
    echo "[Unit]" > $SYSTEMD_SERVICE
    echo "Description=Out-of-Band Daemon" >> $SYSTEMD_SERVICE
    # Removed: After=network.target (unnecessary ordering constraint)
    echo "" >> $SYSTEMD_SERVICE
    echo "[Service]" >> $SYSTEMD_SERVICE
    echo "ExecStart=$INSTALL_DIR/$TARGET" >> $SYSTEMD_SERVICE
    echo "User=root" >> $SYSTEMD_SERVICE
    echo "Group=root" >> $SYSTEMD_SERVICE
    echo "Restart=always" >> $SYSTEMD_SERVICE
    echo "" >> $SYSTEMD_SERVICE
    echo "[Install]" >> $SYSTEMD_SERVICE
    echo "WantedBy=multi-user.target" >> $SYSTEMD_SERVICE
    install -m 644 $SYSTEMD_SERVICE $SERVICE_PATH
    rm -f $SYSTEMD_SERVICE
    echo "Enabling and starting the service..."
    systemctl enable $SYSTEMD_SERVICE
    systemctl start $SYSTEMD_SERVICE
    echo "Fresh install complete."
    exit 0
fi
