#!/bin/bash

if [ "$(id -u)" -ne 0 ]; then
    echo "Error: You must be root to uninstall."
    exit 1
fi

TARGET="ermidaemon"
INSTALL_DIR="/usr/local/sbin"
CONF_DIR="/etc"
CONF_FILE="ermidaemon.conf"
SYSTEMD_SERVICE="ermidaemon.service"

echo "Stopping and disabling the service..."
systemctl --no-ask-password stop $SYSTEMD_SERVICE || true
systemctl --no-ask-password disable $SYSTEMD_SERVICE || true

echo "Removing installed files..."
rm -f $INSTALL_DIR/$TARGET
rm -f $CONF_DIR/$CONF_FILE
rm -f /etc/systemd/system/$SYSTEMD_SERVICE

echo "Uninstallation complete."
